/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.RenderTarget;
import org.openrndr.extra.dnk3.Light;
import org.openrndr.extra.dnk3.SceneNode;
import org.openrndr.extra.dnk3.ShadowLight;
import org.openrndr.extra.dnk3.Shadows;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/extra/dnk3/DirectionalLight;", "Lorg/openrndr/extra/dnk3/Light;", "Lorg/openrndr/extra/dnk3/ShadowLight;", "direction", "Lorg/openrndr/math/Vector3;", "shadows", "Lorg/openrndr/extra/dnk3/Shadows;", "<init>", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/extra/dnk3/Shadows;)V", "getDirection", "()Lorg/openrndr/math/Vector3;", "setDirection", "(Lorg/openrndr/math/Vector3;)V", "getShadows", "()Lorg/openrndr/extra/dnk3/Shadows;", "setShadows", "(Lorg/openrndr/extra/dnk3/Shadows;)V", "projectionSize", "", "getProjectionSize", "()D", "setProjectionSize", "(D)V", "projection", "Lorg/openrndr/math/Matrix44;", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "hashCode", "", "deminityy"})
public final class DirectionalLight
extends Light
implements ShadowLight {
    @NotNull
    private Vector3 direction;
    @NotNull
    private Shadows shadows;
    private double projectionSize;

    public DirectionalLight(@NotNull Vector3 direction, @NotNull Shadows shadows) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        Intrinsics.checkNotNullParameter(shadows, "shadows");
        this.direction = direction;
        this.shadows = shadows;
        this.projectionSize = 50.0;
    }

    public /* synthetic */ DirectionalLight(Vector3 vector3, Shadows shadows, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector3 = Vector3.Companion.getUNIT_Z().unaryMinus();
        }
        if ((n & 2) != 0) {
            shadows = Shadows.None.INSTANCE;
        }
        this(vector3, shadows);
    }

    @NotNull
    public final Vector3 getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.direction = vector3;
    }

    @Override
    @NotNull
    public Shadows getShadows() {
        return this.shadows;
    }

    @Override
    public void setShadows(@NotNull Shadows shadows) {
        Intrinsics.checkNotNullParameter(shadows, "<set-?>");
        this.shadows = shadows;
    }

    public final double getProjectionSize() {
        return this.projectionSize;
    }

    public final void setProjectionSize(double d) {
        this.projectionSize = d;
    }

    @Override
    @NotNull
    public Matrix44 projection(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter(renderTarget, "renderTarget");
        return TransformsKt.ortho(-this.projectionSize / 2.0, this.projectionSize / 2.0, -this.projectionSize / 2.0, this.projectionSize / 2.0, 1.0, 150.0);
    }

    public int hashCode() {
        return this.getColor().hashCode();
    }

    @Override
    @NotNull
    public Matrix44 view(@NotNull SceneNode node) {
        return ShadowLight.DefaultImpls.view(this, node);
    }

    public DirectionalLight() {
        this(null, null, 3, null);
    }
}

