/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.dnk3.Camera;
import org.openrndr.extra.dnk3.SceneNode;
import org.openrndr.math.Matrix44;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/openrndr/extra/dnk3/OrthographicCamera;", "Lorg/openrndr/extra/dnk3/Camera;", "node", "Lorg/openrndr/extra/dnk3/SceneNode;", "<init>", "(Lorg/openrndr/extra/dnk3/SceneNode;)V", "getNode", "()Lorg/openrndr/extra/dnk3/SceneNode;", "setNode", "projectionMatrix", "Lorg/openrndr/math/Matrix44;", "getProjectionMatrix", "()Lorg/openrndr/math/Matrix44;", "viewMatrix", "getViewMatrix", "xMag", "", "getXMag", "()D", "setXMag", "(D)V", "yMag", "getYMag", "setYMag", "near", "getNear", "setNear", "far", "getFar", "setFar", "hashCode", "", "deminityy"})
public final class OrthographicCamera
extends Camera {
    @NotNull
    private SceneNode node;
    private double xMag;
    private double yMag;
    private double near;
    private double far;

    public OrthographicCamera(@NotNull SceneNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        this.node = node;
        this.xMag = 1.0;
        this.yMag = 1.0;
        this.near = 0.1;
        this.far = 100.0;
    }

    @NotNull
    public final SceneNode getNode() {
        return this.node;
    }

    public final void setNode(@NotNull SceneNode sceneNode) {
        Intrinsics.checkNotNullParameter(sceneNode, "<set-?>");
        this.node = sceneNode;
    }

    @Override
    @NotNull
    public Matrix44 getProjectionMatrix() {
        return TransformsKt.ortho(this.xMag, this.yMag, this.near, this.far);
    }

    @Override
    @NotNull
    public Matrix44 getViewMatrix() {
        return this.node.getWorldTransform().inversed();
    }

    public final double getXMag() {
        return this.xMag;
    }

    public final void setXMag(double d) {
        this.xMag = d;
    }

    public final double getYMag() {
        return this.yMag;
    }

    public final void setYMag(double d) {
        this.yMag = d;
    }

    public final double getNear() {
        return this.near;
    }

    public final void setNear(double d) {
        this.near = d;
    }

    public final double getFar() {
        return this.far;
    }

    public final void setFar(double d) {
        this.far = d;
    }

    public int hashCode() {
        int result = Double.hashCode(this.xMag);
        result = 31 * result + Double.hashCode(this.yMag);
        result = 31 * result + Double.hashCode(this.near);
        result = 31 * result + Double.hashCode(this.far);
        return result;
    }
}

