/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3.gltf;

import com.google.gson.Gson;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.dnk3.gltf.GltfFile;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"loadGltfFromGlbFile", "Lorg/openrndr/extra/dnk3/gltf/GltfFile;", "file", "Ljava/io/File;", "deminityy"})
public final class GlbKt {
    @NotNull
    public static final GltfFile loadGltfFromGlbFile(@NotNull File file) {
        GltfFile gltfFile;
        Intrinsics.checkNotNullParameter(file, "file");
        FileChannel channel = new RandomAccessFile(file, "r").getChannel();
        ByteBuffer headerBuffer = ByteBuffer.allocate(12).order(ByteOrder.nativeOrder());
        headerBuffer.rewind();
        channel.read(headerBuffer);
        headerBuffer.rewind();
        int magic = headerBuffer.getInt();
        int version = headerBuffer.getInt();
        int length = headerBuffer.getInt();
        ByteBuffer jsonBuffer = GlbKt.loadGltfFromGlbFile$readChunk(channel);
        jsonBuffer.rewind();
        byte[] jsonByteArray = new byte[jsonBuffer.capacity()];
        jsonBuffer.get(jsonByteArray);
        String json = new String(jsonByteArray, Charsets.UTF_8);
        Gson gson = new Gson();
        ByteBuffer bufferBuffer = channel.position() < (long)length ? GlbKt.loadGltfFromGlbFile$readChunk(channel) : null;
        GltfFile $this$loadGltfFromGlbFile_u24lambda_u240 = gltfFile = gson.fromJson(json, GltfFile.class);
        boolean bl = false;
        $this$loadGltfFromGlbFile_u24lambda_u240.setFile(file);
        $this$loadGltfFromGlbFile_u24lambda_u240.setBufferBuffer(bufferBuffer);
        GltfFile gltfFile2 = gltfFile;
        Intrinsics.checkNotNullExpressionValue(gltfFile2, "apply(...)");
        return gltfFile2;
    }

    private static final ByteBuffer loadGltfFromGlbFile$readChunk(FileChannel channel) {
        ByteBuffer chunkHeader = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder());
        channel.read(chunkHeader);
        chunkHeader.rewind();
        int chunkLength = chunkHeader.getInt();
        int chunkType = chunkHeader.getInt();
        ByteBuffer chunkBuffer = chunkType == 5130562 ? ByteBuffer.allocateDirect(chunkLength) : ByteBuffer.allocate(chunkLength);
        Intrinsics.checkNotNull(chunkBuffer, "null cannot be cast to non-null type java.nio.ByteBuffer");
        channel.read(chunkBuffer);
        chunkBuffer.order(ByteOrder.nativeOrder());
        return chunkBuffer;
    }
}

