/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.expressions.typed;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.extra.expressions.typed.Function2Kt;
import org.openrndr.extra.expressions.typed.Function3Kt;
import org.openrndr.extra.expressions.typed.Function4Kt;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001aH\u0010\u0016\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0018\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017j\u0002`\u001d0\u001cH\u0000\u00a8\u0006\u001e"}, d2={"vec2", "Lorg/openrndr/math/Vector2;", "x", "", "vec3", "Lorg/openrndr/math/Vector3;", "vec4", "Lorg/openrndr/math/Vector4;", "rgba", "Lorg/openrndr/color/ColorRGBa;", "cos", "sin", "normalize", "inverse", "transpose", "abs", "scale", "Lorg/openrndr/math/Matrix44;", "sqrt", "translate", "translation", "mat4", "dispatchFunction1", "Lkotlin/Function1;", "", "name", "", "functions", "", "Lorg/openrndr/extra/expressions/typed/TypedFunction1;", "orx-expression-evaluator-typed"})
@SourceDebugExtension(value={"SMAP\nFunction1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Function1.kt\norg/openrndr/extra/expressions/typed/Function1Kt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class Function1Kt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Vector2 vec2(@NotNull Object x) {
        Vector2 vector2;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object = x;
        if (object instanceof Double) {
            vector2 = new Vector2(((Number)x).doubleValue(), ((Number)x).doubleValue());
            return vector2;
        } else {
            if (!(object instanceof List)) throw new IllegalStateException(("vec2(): unsupported argument: '" + x + "'").toString());
            if (((List)x).size() != 2) throw new IllegalStateException(("vec2(): unsupported argument: '" + x + "'").toString());
            List cfr_ignored_0 = (List)x;
            vector2 = new Vector2(((Number)((List)x).get(0)).doubleValue(), ((Number)((List)x).get(1)).doubleValue());
        }
        return vector2;
    }

    @NotNull
    public static final Vector3 vec3(@NotNull Object x) {
        Vector3 vector3;
        block5: {
            block6: {
                Object object;
                block4: {
                    Intrinsics.checkNotNullParameter(x, "x");
                    object = x;
                    if (!(object instanceof Double)) break block4;
                    vector3 = new Vector3(((Number)x).doubleValue(), ((Number)x).doubleValue(), ((Number)x).doubleValue());
                    break block5;
                }
                if (!(object instanceof List)) break block6;
                switch (((List)x).size()) {
                    case 2: {
                        Object e = ((List)x).get(0);
                        Intrinsics.checkNotNull(e);
                        Object e2 = ((List)x).get(1);
                        Intrinsics.checkNotNull(e2);
                        vector3 = Function2Kt.vec3(e, e2);
                        break block5;
                    }
                    case 3: {
                        Object e = ((List)x).get(0);
                        Intrinsics.checkNotNull(e);
                        Object e3 = ((List)x).get(1);
                        Intrinsics.checkNotNull(e3);
                        Object e4 = ((List)x).get(2);
                        Intrinsics.checkNotNull(e4);
                        vector3 = Function3Kt.vec3(e, e3, e4);
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException(("vec3(): unsupported argument: '" + x + "'").toString());
                    }
                }
            }
            throw new IllegalStateException(("vec3(): unsupported argument: '" + x + "'").toString());
        }
        return vector3;
    }

    @NotNull
    public static final Vector4 vec4(@NotNull Object x) {
        Vector4 vector4;
        block6: {
            block7: {
                Object object;
                block5: {
                    Intrinsics.checkNotNullParameter(x, "x");
                    object = x;
                    if (!(object instanceof Double)) break block5;
                    vector4 = new Vector4(((Number)x).doubleValue(), ((Number)x).doubleValue(), ((Number)x).doubleValue(), ((Number)x).doubleValue());
                    break block6;
                }
                if (!(object instanceof List)) break block7;
                switch (((List)x).size()) {
                    case 2: {
                        Object e = ((List)x).get(0);
                        Intrinsics.checkNotNull(e);
                        Object e2 = ((List)x).get(1);
                        Intrinsics.checkNotNull(e2);
                        vector4 = Function2Kt.vec4(e, e2);
                        break block6;
                    }
                    case 3: {
                        Object e = ((List)x).get(0);
                        Intrinsics.checkNotNull(e);
                        Object e3 = ((List)x).get(1);
                        Intrinsics.checkNotNull(e3);
                        Object e4 = ((List)x).get(2);
                        Intrinsics.checkNotNull(e4);
                        vector4 = Function3Kt.vec4(e, e3, e4);
                        break block6;
                    }
                    case 4: {
                        Object e = ((List)x).get(0);
                        Intrinsics.checkNotNull(e);
                        Object e5 = ((List)x).get(1);
                        Intrinsics.checkNotNull(e5);
                        Object e6 = ((List)x).get(2);
                        Intrinsics.checkNotNull(e6);
                        Object e7 = ((List)x).get(3);
                        Intrinsics.checkNotNull(e7);
                        vector4 = Function4Kt.vec4(e, e5, e6, e7);
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException(("vec4(): unsupported argument: '" + x + "'").toString());
                    }
                }
            }
            throw new IllegalStateException(("vec4(): unsupported argument: '" + x + "'").toString());
        }
        return vector4;
    }

    @NotNull
    public static final ColorRGBa rgba(@NotNull Object x) {
        ColorRGBa colorRGBa;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object = x;
        if (object instanceof Double) {
            colorRGBa = new ColorRGBa(((Number)x).doubleValue(), ((Number)x).doubleValue(), ((Number)x).doubleValue(), 1.0, null, 16, null);
        } else if (object instanceof Vector3) {
            colorRGBa = new ColorRGBa(((Vector3)x).x(), ((Vector3)x).y(), ((Vector3)x).z(), 1.0, null, 16, null);
        } else if (object instanceof Vector4) {
            colorRGBa = new ColorRGBa(((Vector4)x).x(), ((Vector4)x).y(), ((Vector4)x).z(), ((Vector4)x).w(), null, 16, null);
        } else {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return colorRGBa;
    }

    @NotNull
    public static final Object cos(@NotNull Object x) {
        Object object;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object2 = x;
        if (object2 instanceof Double) {
            object = Math.cos(((Number)x).doubleValue());
        } else if (object2 instanceof Vector2) {
            object = ((Vector2)x).map(Function1Kt::cos$lambda$0);
        } else if (object2 instanceof Vector3) {
            object = ((Vector3)x).map(Function1Kt::cos$lambda$1);
        } else if (object2 instanceof Vector4) {
            object = ((Vector4)x).map(Function1Kt::cos$lambda$2);
        } else {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return object;
    }

    @NotNull
    public static final Object sin(@NotNull Object x) {
        Object object;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object2 = x;
        if (object2 instanceof Double) {
            object = Math.sin(((Number)x).doubleValue());
        } else if (object2 instanceof Vector2) {
            object = ((Vector2)x).map(Function1Kt::sin$lambda$3);
        } else if (object2 instanceof Vector3) {
            object = ((Vector3)x).map(Function1Kt::sin$lambda$4);
        } else if (object2 instanceof Vector4) {
            object = ((Vector4)x).map(Function1Kt::sin$lambda$5);
        } else {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return object;
    }

    @NotNull
    public static final Object normalize(@NotNull Object x) {
        EuclideanVector euclideanVector;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object = x;
        if (object instanceof Vector2) {
            euclideanVector = ((Vector2)x).getNormalized();
        } else if (object instanceof Vector3) {
            euclideanVector = ((Vector3)x).getNormalized();
        } else if (object instanceof Vector4) {
            euclideanVector = ((Vector4)x).getNormalized();
        } else {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return euclideanVector;
    }

    @NotNull
    public static final Object inverse(@NotNull Object x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (!(x instanceof Matrix44)) {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return ((Matrix44)x).inversed();
    }

    @NotNull
    public static final Object transpose(@NotNull Object x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (!(x instanceof Matrix44)) {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return ((Matrix44)x).transposed();
    }

    @NotNull
    public static final Object abs(@NotNull Object x) {
        Object object;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object2 = x;
        if (object2 instanceof Double) {
            object = Math.abs(((Number)x).doubleValue());
        } else if (object2 instanceof Vector2) {
            object = ((Vector2)x).map(Function1Kt::abs$lambda$6);
        } else if (object2 instanceof Vector3) {
            object = ((Vector3)x).map(Function1Kt::abs$lambda$7);
        } else if (object2 instanceof Vector4) {
            object = ((Vector4)x).map(Function1Kt::abs$lambda$8);
        } else {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return object;
    }

    @NotNull
    public static final Matrix44 scale(@NotNull Object scale) {
        Vector3 vector3;
        Intrinsics.checkNotNullParameter(scale, "scale");
        Object object = scale;
        if (object instanceof Double) {
            vector3 = new Vector3(((Number)scale).doubleValue(), ((Number)scale).doubleValue(), ((Number)scale).doubleValue());
        } else if (object instanceof Vector2) {
            vector3 = ((Vector2)scale).xy1();
        } else if (object instanceof Vector3) {
            vector3 = (Vector3)scale;
        } else {
            throw new IllegalStateException("unsupported axis argument".toString());
        }
        Vector3 scale2 = vector3;
        return TransformsKt.scale(Matrix44.Companion, scale2);
    }

    @NotNull
    public static final Object sqrt(@NotNull Object x) {
        Object object;
        Intrinsics.checkNotNullParameter(x, "x");
        Object object2 = x;
        if (object2 instanceof Double) {
            object = Math.sqrt(((Number)x).doubleValue());
        } else if (object2 instanceof Vector2) {
            object = ((Vector2)x).map(Function1Kt::sqrt$lambda$9);
        } else if (object2 instanceof Vector3) {
            object = ((Vector3)x).map(Function1Kt::sqrt$lambda$10);
        } else if (object2 instanceof Vector4) {
            object = ((Vector4)x).map(Function1Kt::sqrt$lambda$11);
        } else {
            throw new IllegalStateException(("type not supported " + Reflection.getOrCreateKotlinClass(x.getClass()).getSimpleName()).toString());
        }
        return object;
    }

    @NotNull
    public static final Matrix44 translate(@NotNull Object translation) {
        Vector3 vector3;
        Intrinsics.checkNotNullParameter(translation, "translation");
        Object object = translation;
        if (object instanceof Vector2) {
            vector3 = ((Vector2)translation).xy0();
        } else if (object instanceof Vector3) {
            vector3 = (Vector3)translation;
        } else {
            throw new IllegalStateException("unsupported axis argument".toString());
        }
        Vector3 translation2 = vector3;
        return TransformsKt.translate(Matrix44.Companion, translation2);
    }

    @NotNull
    public static final Matrix44 mat4(@NotNull Object x) {
        Matrix44 matrix44;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(x, "x");
                if (!(x instanceof List)) break block4;
                switch (((List)x).size()) {
                    case 16: {
                        matrix44 = Matrix44.Companion.fromDoubleArray(CollectionsKt.toDoubleArray((List)x));
                        break block5;
                    }
                    case 4: {
                        List cfr_ignored_0 = (List)x;
                        matrix44 = Matrix44.Companion.fromColumnVectors((Vector4)((List)x).get(0), (Vector4)((List)x).get(1), (Vector4)((List)x).get(2), (Vector4)((List)x).get(3));
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException(("mat4(): unsupported argument: '" + x + "'").toString());
                    }
                }
            }
            throw new IllegalStateException(("mat4(): unsupported argument: '" + x + "'").toString());
        }
        return matrix44;
    }

    @Nullable
    public static final Function1<Object[], Object> dispatchFunction1(@NotNull String name, @NotNull Map<String, ? extends Function1<Object, ? extends Object>> functions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(functions, "functions");
        return switch (name) {
            case "vec2" -> Function1Kt::dispatchFunction1$lambda$12;
            case "vec3" -> Function1Kt::dispatchFunction1$lambda$13;
            case "vec4" -> Function1Kt::dispatchFunction1$lambda$14;
            case "mat4" -> Function1Kt::dispatchFunction1$lambda$15;
            case "cos" -> Function1Kt::dispatchFunction1$lambda$16;
            case "sin" -> Function1Kt::dispatchFunction1$lambda$17;
            case "sqrt" -> Function1Kt::dispatchFunction1$lambda$18;
            case "abs" -> Function1Kt::dispatchFunction1$lambda$19;
            case "scale" -> Function1Kt::dispatchFunction1$lambda$20;
            case "rgba", "rgb" -> Function1Kt::dispatchFunction1$lambda$21;
            case "translate" -> Function1Kt::dispatchFunction1$lambda$22;
            case "transpose" -> Function1Kt::dispatchFunction1$lambda$23;
            case "inverse" -> Function1Kt::dispatchFunction1$lambda$24;
            case "normalize" -> Function1Kt::dispatchFunction1$lambda$25;
            default -> {
                Function1<Object, ? extends Object> v1 = functions.get(name);
                if (v1 != null) {
                    Function1<Object, ? extends Object> it = v1;
                    boolean $i$a$-let-Function1Kt$dispatchFunction1$15 = false;
                    yield arg_0 -> Function1Kt.dispatchFunction1$lambda$27$lambda$26(it, arg_0);
                }
                yield null;
            }
        };
    }

    private static final double cos$lambda$0(double it) {
        return Math.cos(it);
    }

    private static final double cos$lambda$1(double it) {
        return Math.cos(it);
    }

    private static final double cos$lambda$2(double it) {
        return Math.cos(it);
    }

    private static final double sin$lambda$3(double it) {
        return Math.sin(it);
    }

    private static final double sin$lambda$4(double it) {
        return Math.sin(it);
    }

    private static final double sin$lambda$5(double it) {
        return Math.sin(it);
    }

    private static final double abs$lambda$6(double it) {
        return Math.abs(it);
    }

    private static final double abs$lambda$7(double it) {
        return Math.abs(it);
    }

    private static final double abs$lambda$8(double it) {
        return Math.abs(it);
    }

    private static final double sqrt$lambda$9(double it) {
        return Math.sqrt(it);
    }

    private static final double sqrt$lambda$10(double it) {
        return Math.sqrt(it);
    }

    private static final double sqrt$lambda$11(double it) {
        return Math.sqrt(it);
    }

    private static final Vector2 dispatchFunction1$lambda$12(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.vec2(x[0]);
    }

    private static final Vector3 dispatchFunction1$lambda$13(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.vec3(x[0]);
    }

    private static final Vector4 dispatchFunction1$lambda$14(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.vec4(x[0]);
    }

    private static final Matrix44 dispatchFunction1$lambda$15(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.mat4(x[0]);
    }

    private static final Object dispatchFunction1$lambda$16(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.cos(x[0]);
    }

    private static final Object dispatchFunction1$lambda$17(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.sin(x[0]);
    }

    private static final Object dispatchFunction1$lambda$18(Object[] v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return Function1Kt.sqrt(v[0]);
    }

    private static final Object dispatchFunction1$lambda$19(Object[] v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return Function1Kt.abs(v[0]);
    }

    private static final Matrix44 dispatchFunction1$lambda$20(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.scale(x[0]);
    }

    private static final ColorRGBa dispatchFunction1$lambda$21(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.rgba(x[0]);
    }

    private static final Matrix44 dispatchFunction1$lambda$22(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.translate(x[0]);
    }

    private static final Object dispatchFunction1$lambda$23(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.transpose(x[0]);
    }

    private static final Object dispatchFunction1$lambda$24(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.inverse(x[0]);
    }

    private static final Object dispatchFunction1$lambda$25(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function1Kt.normalize(x[0]);
    }

    private static final Object dispatchFunction1$lambda$27$lambda$26(Function1 $it, Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return $it.invoke(x[0]);
    }
}

