/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fcurve;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.expressions.CompiledFunctionsKt;
import org.openrndr.extra.expressions.FunctionExtensions;
import org.openrndr.extra.fcurve.EFCurveKt;
import org.openrndr.extra.fcurve.FCurveKt;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"modifyFCurve", "", "fcurve", "modifiers", "constants", "", "", "functions", "Lorg/openrndr/extra/expressions/FunctionExtensions;", "main", "", "orx-fcurve"})
public final class FCurveModifierKt {
    @NotNull
    public static final String modifyFCurve(@NotNull String fcurve, @NotNull String modifiers, @NotNull Map<String, Double> constants, @NotNull FunctionExtensions functions) {
        String yModifierExpression;
        String xModifierExpression;
        Intrinsics.checkNotNullParameter(fcurve, "fcurve");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        Intrinsics.checkNotNullParameter(constants, "constants");
        Intrinsics.checkNotNullParameter(functions, "functions");
        List<String> parts = FCurveKt.fCurveCommands(fcurve);
        List<String> mparts = CollectionsKt.toMutableList(CollectionsKt.reversed((Iterable)parts));
        Regex modifier = new Regex("([xy])=\\{([^{}]+)\\}");
        Map modifierExpressions = MapsKt.toMap(SequencesKt.map(Regex.findAll$default(modifier, modifiers, 0, 2, null), FCurveModifierKt::modifyFCurve$lambda$0));
        String string = xModifierExpression = (String)modifierExpressions.get("x");
        Function1 xModifier = string != null ? CompiledFunctionsKt.compileFunction1$default(string, "x", constants, functions, null, 16, null) : FCurveModifierKt::modifyFCurve$lambda$1;
        String string2 = yModifierExpression = (String)modifierExpressions.get("y");
        Function1 yModifier = string2 != null ? CompiledFunctionsKt.compileFunction1$default(string2, "y", constants, functions, null, 16, null) : FCurveModifierKt::modifyFCurve$lambda$2;
        Ref.ObjectRef<Vector2> cursor = new Ref.ObjectRef<Vector2>();
        cursor.element = Vector2.Companion.getZERO();
        Ref.ObjectRef<String> modified = new Ref.ObjectRef<String>();
        modified.element = "";
        block25: while (!((Collection)mparts).isEmpty()) {
            String command2;
            switch (command2 = (String)CollectionsKt.removeLast(mparts)) {
                case "m": 
                case "M": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    double rf = relative ? 1.0 : 0.0;
                    double y = FCurveModifierKt.modifyFCurve$popNumber(mparts) + rf * ((Vector2)cursor.element).y();
                    double[] dArray = new double[]{((Number)yModifier.invoke(y)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, "M", dArray, false, 0.0, y);
                    continue block25;
                }
                case "l": 
                case "L": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    double rf = relative ? 1.0 : 0.0;
                    double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double y = FCurveModifierKt.modifyFCurve$popNumber(mparts) + rf * ((Vector2)cursor.element).y();
                    double[] dArray = new double[]{((Number)xModifier.invoke(x)).doubleValue(), ((Number)yModifier.invoke(y)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, "L", dArray, false, x, y);
                    continue block25;
                }
                case "c": 
                case "C": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    double rf = relative ? 1.0 : 0.0;
                    String tcx0 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    String tcy0 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    String tcx1 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    String tcy1 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double y = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double ay = y + ((Vector2)cursor.element).y() * rf;
                    double x0 = FCurveModifierKt.modifyFCurve$numberOrPercentageOf(tcx0, () -> FCurveModifierKt.modifyFCurve$lambda$4(x));
                    double y0 = FCurveModifierKt.modifyFCurve$numberOrFactorOf(tcy0, arg_0 -> FCurveModifierKt.modifyFCurve$lambda$5(relative, y, cursor, arg_0)) + ((Vector2)cursor.element).y() * rf;
                    double x1 = FCurveModifierKt.modifyFCurve$numberOrPercentageOf(tcx1, () -> FCurveModifierKt.modifyFCurve$lambda$6(x));
                    double y1 = FCurveModifierKt.modifyFCurve$numberOrFactorOf(tcy1, arg_0 -> FCurveModifierKt.modifyFCurve$lambda$7(relative, y, cursor, arg_0)) + ((Vector2)cursor.element).y() * rf;
                    double[] dArray = new double[]{((Number)xModifier.invoke(x0)).doubleValue(), ((Number)yModifier.invoke(y0)).doubleValue(), ((Number)xModifier.invoke(x1)).doubleValue(), ((Number)yModifier.invoke(y1)).doubleValue(), ((Number)xModifier.invoke(x)).doubleValue(), ((Number)xModifier.invoke(ay)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, "C", dArray, false, x, ay);
                    continue block25;
                }
                case "q": 
                case "Q": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    double rf = relative ? 1.0 : 0.0;
                    String tcx0 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    String tcy0 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double y = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double ay = y + ((Vector2)cursor.element).y() * rf;
                    double x0 = FCurveModifierKt.modifyFCurve$numberOrPercentageOf(tcx0, () -> FCurveModifierKt.modifyFCurve$lambda$8(x));
                    double y0 = FCurveModifierKt.modifyFCurve$numberOrFactorOf(tcy0, arg_0 -> FCurveModifierKt.modifyFCurve$lambda$9(relative, y, cursor, arg_0)) + rf * ((Vector2)cursor.element).y();
                    double[] dArray = new double[]{((Number)xModifier.invoke(x0)).doubleValue(), ((Number)yModifier.invoke(y0)).doubleValue(), ((Number)xModifier.invoke(x)).doubleValue(), ((Number)yModifier.invoke(ay)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, "Q", dArray, false, x, ay);
                    continue block25;
                }
                case "h": 
                case "H": {
                    double[] dArray;
                    if (Intrinsics.areEqual(command2, "H")) {
                        double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                        dArray = new double[]{((Number)xModifier.invoke(x)).doubleValue()};
                        FCurveModifierKt.modifyFCurve$emit(modified, cursor, command2, dArray, false, x, ((Vector2)cursor.element).y());
                        cursor.element = new Vector2(x, ((Vector2)cursor.element).y());
                        continue block25;
                    }
                    double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    dArray = new double[]{((Number)xModifier.invoke(x)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, command2, dArray, false, x, ((Vector2)cursor.element).y());
                    continue block25;
                }
                case "s": 
                case "S": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    double rf = relative ? 1.0 : 0.0;
                    String tcx0 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    String tcy0 = FCurveModifierKt.modifyFCurve$popToken(mparts);
                    double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double y = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double ay = y + ((Vector2)cursor.element).y() * rf;
                    double x1 = FCurveModifierKt.modifyFCurve$numberOrPercentageOf(tcx0, () -> FCurveModifierKt.modifyFCurve$lambda$10(x));
                    double y1 = FCurveModifierKt.modifyFCurve$numberOrFactorOf(tcy0, arg_0 -> FCurveModifierKt.modifyFCurve$lambda$11(relative, y, cursor, arg_0)) + rf * ((Vector2)cursor.element).y();
                    double[] dArray = new double[]{((Number)xModifier.invoke(x1)).doubleValue(), ((Number)yModifier.invoke(y1)).doubleValue(), ((Number)xModifier.invoke(x)).doubleValue(), ((Number)yModifier.invoke(ay)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, "S", dArray, false, x, ay);
                    continue block25;
                }
                case "t": 
                case "T": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    double rf = relative ? 1.0 : 0.0;
                    double x = FCurveModifierKt.modifyFCurve$popNumber(mparts);
                    double y = FCurveModifierKt.modifyFCurve$popNumber(mparts) + ((Vector2)cursor.element).y() * rf;
                    double[] dArray = new double[]{((Number)xModifier.invoke(x)).doubleValue(), ((Number)yModifier.invoke(y)).doubleValue()};
                    FCurveModifierKt.modifyFCurve$emit(modified, cursor, "T", dArray, false, x, y);
                    continue block25;
                }
            }
            throw new IllegalStateException(("unknown command: " + command2 + " in " + parts).toString());
        }
        return (String)modified.element;
    }

    public static /* synthetic */ String modifyFCurve$default(String string, String string2, Map map2, FunctionExtensions functionExtensions, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            functionExtensions = FunctionExtensions.Companion.getEMPTY();
        }
        return FCurveModifierKt.modifyFCurve(string, string2, map2, functionExtensions);
    }

    public static final void main() {
        String f = "l 10 10 h 4 t 20.0 20.0 s 5% 50% 30.0 30.0";
        System.out.println((Object)FCurveModifierKt.modifyFCurve$default(f, "x={sqrt(x)} y={y * 2.0}", null, null, 12, null));
        String mf = "l 10 10 h 4 t 20.0 20.0 s 5% 50% 30.0 30.0 | x={2.0 * x} y={-3.0 * y}";
        String f2 = EFCurveKt.mfcurve$default(mf, null, null, 6, null);
        System.out.println((Object)f2);
    }

    public static /* synthetic */ void main(String[] args) {
        FCurveModifierKt.main();
    }

    private static final Pair modifyFCurve$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it.getGroupValues().get(1), it.getGroupValues().get(2));
    }

    private static final double modifyFCurve$lambda$1(double x) {
        return x;
    }

    private static final double modifyFCurve$lambda$2(double y) {
        return y;
    }

    private static final String modifyFCurve$popToken(List<String> mparts) {
        return CollectionsKt.removeLast(mparts);
    }

    private static final double modifyFCurve$popNumber(List<String> mparts) {
        Double d = StringsKt.toDoubleOrNull(CollectionsKt.removeLast(mparts));
        if (d == null) {
            throw new IllegalStateException("not a number".toString());
        }
        return d;
    }

    private static final double modifyFCurve$numberOrFactorOf(String $this$modifyFCurve_u24numberOrFactorOf, Function1<? super Double, Double> percentageOf) {
        double d;
        if (StringsKt.endsWith$default($this$modifyFCurve_u24numberOrFactorOf, "%", false, 2, null)) {
            Double d2 = StringsKt.toDoubleOrNull(StringsKt.dropLast($this$modifyFCurve_u24numberOrFactorOf, 1));
            if (d2 == null) {
                throw new IllegalStateException(("'" + $this$modifyFCurve_u24numberOrFactorOf + "' is not a percentage").toString());
            }
            double f = d2 / 100.0;
            d = ((Number)percentageOf.invoke((Double)f)).doubleValue();
        } else {
            Double d3 = StringsKt.toDoubleOrNull($this$modifyFCurve_u24numberOrFactorOf);
            if (d3 != null) {
                d = d3;
            } else {
                throw new IllegalStateException(("'" + $this$modifyFCurve_u24numberOrFactorOf + "' is not a number").toString());
            }
        }
        return d;
    }

    private static final double modifyFCurve$numberOrPercentageOf$lambda$3(Function0 $percentageOf, double f) {
        return f * ((Number)$percentageOf.invoke()).doubleValue();
    }

    private static final double modifyFCurve$numberOrPercentageOf(String $this$modifyFCurve_u24numberOrPercentageOf, Function0<Double> percentageOf) {
        return FCurveModifierKt.modifyFCurve$numberOrFactorOf($this$modifyFCurve_u24numberOrPercentageOf, arg_0 -> FCurveModifierKt.modifyFCurve$numberOrPercentageOf$lambda$3(percentageOf, arg_0));
    }

    private static final void modifyFCurve$emit(Ref.ObjectRef<String> modified, Ref.ObjectRef<Vector2> cursor, String command2, double[] ops, boolean relative, double x, double y) {
        modified.element = modified.element + " " + command2 + " " + ArraysKt.joinToString$default(ops, (CharSequence)" ", null, null, 0, null, null, 62, null);
        cursor.element = relative ? new Vector2(x + ((Vector2)cursor.element).x(), y + ((Vector2)cursor.element).y()) : new Vector2(x + ((Vector2)cursor.element).x(), y);
    }

    private static final double modifyFCurve$lambda$4(double $x) {
        return $x;
    }

    private static final double modifyFCurve$lambda$5(boolean $relative, double $y, Ref.ObjectRef $cursor, double factor) {
        return $relative ? $y * factor : ((Vector2)$cursor.element).y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }

    private static final double modifyFCurve$lambda$6(double $x) {
        return $x;
    }

    private static final double modifyFCurve$lambda$7(boolean $relative, double $y, Ref.ObjectRef $cursor, double factor) {
        return $relative ? $y * factor : ((Vector2)$cursor.element).y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }

    private static final double modifyFCurve$lambda$8(double $x) {
        return $x;
    }

    private static final double modifyFCurve$lambda$9(boolean $relative, double $y, Ref.ObjectRef $cursor, double factor) {
        return $relative ? $y * factor : ((Vector2)$cursor.element).y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }

    private static final double modifyFCurve$lambda$10(double $x) {
        return $x;
    }

    private static final double modifyFCurve$lambda$11(boolean $relative, double $y, Ref.ObjectRef $cursor, double factor) {
        return $relative ? $y * factor : ((Vector2)$cursor.element).y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }
}

