/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.ColorBufferDescription;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.parameters.IntParameter;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Description(title="Approximate Gaussian blur")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0'2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+R1\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\f\u0010\r\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR1\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0015\u0010\r\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R1\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001a\u0010\r\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R1\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001f\u0010\r\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/openrndr/extra/fx/blur/ApproximateGaussianBlur;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "window", "getWindow$annotations", "getWindow", "()I", "setWindow", "(I)V", "window$delegate", "Ljava/util/Map;", "", "spread", "getSpread$annotations", "getSpread", "()D", "setSpread", "(D)V", "spread$delegate", "sigma", "getSigma$annotations", "getSigma", "setSigma", "sigma$delegate", "gain", "getGain$annotations", "getGain", "setGain", "gain$delegate", "intermediateCache", "", "Lorg/openrndr/extra/fx/ColorBufferDescription;", "Lorg/openrndr/draw/ColorBuffer;", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-fx"})
@SourceDebugExtension(value={"SMAP\nApproximateGaussianBlur.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApproximateGaussianBlur.kt\norg/openrndr/extra/fx/blur/ApproximateGaussianBlur\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,68:1\n381#2,7:69\n*S KotlinDebug\n*F\n+ 1 ApproximateGaussianBlur.kt\norg/openrndr/extra/fx/blur/ApproximateGaussianBlur\n*L\n56#1:69,7\n*E\n"})
public final class ApproximateGaussianBlur
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map window$delegate = this.getParameters();
    @NotNull
    private final Map spread$delegate = this.getParameters();
    @NotNull
    private final Map sigma$delegate = this.getParameters();
    @NotNull
    private final Map gain$delegate = this.getParameters();
    @NotNull
    private Map<ColorBufferDescription, ColorBuffer> intermediateCache = new LinkedHashMap();

    public ApproximateGaussianBlur() {
        super(FilterToolsKt.mppFilterShader("in vec2 v_texCoord0;\nuniform sampler2D tex0;\nuniform vec2 blurDirection;\n\nuniform int window;\nuniform float sigma;\nuniform float spread;\nuniform float gain;\n\nuniform int sourceLevel;\n\nout vec4 o_color;\nvoid main() {\n    vec2 s = 1.0 / vec2(textureSize(tex0, sourceLevel).xy);\n    int w = window;\n\n    vec4 sum = vec4(0.0);\n    float weight = 0.0;\n    for (int x = -w; x <= w; ++x) {\n        float lw = exp( float(-(x*x)) / (2.0 * sigma * sigma) ) ;\n        vec2 tc = v_texCoord0 + float(x) * blurDirection * s;// * spread;\n        sum += texture(tex0, tc) * lw;\n        weight += lw;\n    }\n    o_color = (sum / weight) * gain;\n}", "approximate gaussian blur"), null, 2, null);
        this.setWindow(5);
        this.setSpread(1.0);
        this.setGain(1.0);
        this.setSigma(1.0);
    }

    public final int getWindow() {
        Map map2 = this.window$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).intValue();
    }

    public final void setWindow(int n) {
        Map map2 = this.window$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="window size", low=1, high=25)
    public static /* synthetic */ void getWindow$annotations() {
    }

    public final double getSpread() {
        Map map2 = this.spread$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setSpread(double d) {
        Map map2 = this.spread$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="kernel spread", low=1.0, high=4.0)
    public static /* synthetic */ void getSpread$annotations() {
    }

    public final double getSigma() {
        Map map2 = this.sigma$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setSigma(double d) {
        Map map2 = this.sigma$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="kernel sigma", low=0.0, high=25.0)
    public static /* synthetic */ void getSigma$annotations() {
    }

    public final double getGain() {
        Map map2 = this.gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setGain(double d) {
        Map map2 = this.gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gain", low=0.0, high=4.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        ColorBuffer intermediate;
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        ColorBufferDescription intermediateDescription = new ColorBufferDescription(target2[0].getWidth(), target2[0].getHeight(), target2[0].getContentScale(), target2[0].getFormat(), target2[0].getType());
        Map<ColorBufferDescription, ColorBuffer> $this$getOrPut$iv = this.intermediateCache;
        boolean $i$f$getOrPut = false;
        ColorBuffer value$iv = $this$getOrPut$iv.get(intermediateDescription);
        if (value$iv == null) {
            boolean bl = false;
            ColorBuffer answer$iv = ColorBufferKt.colorBuffer$default(target2[0].getWidth(), target2[0].getHeight(), target2[0].getContentScale(), target2[0].getFormat(), target2[0].getType(), null, 0, null, 224, null);
            $this$getOrPut$iv.put(intermediateDescription, answer$iv);
            colorBuffer = answer$iv;
        } else {
            colorBuffer = value$iv;
        }
        ColorBuffer it = intermediate = colorBuffer;
        boolean bl = false;
        this.getParameters().put("blurDirection", new Vector2(1.0, 0.0));
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{it};
        super.apply(source, colorBufferArray, clip);
        this.getParameters().put("blurDirection", new Vector2(0.0, 1.0));
        colorBufferArray = new ColorBuffer[]{it};
        super.apply(colorBufferArray, target2, clip);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(ApproximateGaussianBlur.class, "window", "getWindow()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ApproximateGaussianBlur.class, "spread", "getSpread()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ApproximateGaussianBlur.class, "sigma", "getSigma()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ApproximateGaussianBlur.class, "gain", "getGain()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

