/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.parameters.IntParameter;

@Description(title="Gaussian blur")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0012\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R1\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\f\u0010\r\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR1\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0015\u0010\r\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R1\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001a\u0010\r\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R1\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001f\u0010\r\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/openrndr/extra/fx/blur/GaussianBlur;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "window", "getWindow$annotations", "getWindow", "()I", "setWindow", "(I)V", "window$delegate", "Ljava/util/Map;", "", "spread", "getSpread$annotations", "getSpread", "()D", "setSpread", "(D)V", "spread$delegate", "sigma", "getSigma$annotations", "getSigma", "setSigma", "sigma$delegate", "gain", "getGain$annotations", "getGain", "setGain", "gain$delegate", "orx-fx"})
public final class GaussianBlur
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map window$delegate = this.getParameters();
    @NotNull
    private final Map spread$delegate = this.getParameters();
    @NotNull
    private final Map sigma$delegate = this.getParameters();
    @NotNull
    private final Map gain$delegate = this.getParameters();

    public GaussianBlur() {
        super(FilterToolsKt.mppFilterShader("in vec2 v_texCoord0;\nuniform sampler2D tex0;\n\nuniform int window;\nuniform float sigma;\nuniform float spread;\nuniform float gain;\n\nout vec4 o_color;\nvoid main() {\n    vec2 s = vec2(textureSize(tex0, 0).xy);\n    s = vec2(1.0 / s.x, 1.0 / s.y);\n    int w = window;\n\n    vec4 sum = vec4(0.0, 0.0, 0.0, 0.0);\n    float weight = 0.0;\n    for (int y = -w; y <= w; ++y) {\n        for (int x = -w; x <= w; ++x) {\n            float lw = exp(-float(x * x + y * y) / (2.0 * sigma * sigma));\n            sum += texture(tex0, v_texCoord0 + vec2(x, y) * s * 1.0) * lw;\n            weight += lw;\n        }\n    }\n    o_color = (sum / weight) * gain;\n}", "gaussian-blur"), null, 2, null);
        this.setWindow(5);
        this.setSpread(1.0);
        this.setSigma(1.0);
        this.setGain(1.0);
    }

    public final int getWindow() {
        Map map2 = this.window$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).intValue();
    }

    public final void setWindow(int n) {
        Map map2 = this.window$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="window size", low=1, high=25)
    public static /* synthetic */ void getWindow$annotations() {
    }

    public final double getSpread() {
        Map map2 = this.spread$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setSpread(double d) {
        Map map2 = this.spread$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="kernel spread", low=1.0, high=4.0)
    public static /* synthetic */ void getSpread$annotations() {
    }

    public final double getSigma() {
        Map map2 = this.sigma$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setSigma(double d) {
        Map map2 = this.sigma$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="kernel sigma", low=0.0, high=25.0)
    public static /* synthetic */ void getSigma$annotations() {
    }

    public final double getGain() {
        Map map2 = this.gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setGain(double d) {
        Map map2 = this.gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gain", low=0.0, high=4.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(GaussianBlur.class, "window", "getWindow()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(GaussianBlur.class, "spread", "getSpread()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(GaussianBlur.class, "sigma", "getSigma()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(GaussianBlur.class, "gain", "getGain()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

