/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.distort;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Filter1to1;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.BooleanParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.parameters.IntParameter;
import org.openrndr.extra.parameters.Vector2Parameter;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Description(title="Perturb")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b \n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0V2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020W0V2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0002\u0010[R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR1\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R1\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0019\u0010\f\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R1\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001e\u0010\f\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\u0011\"\u0004\b\u001d\u0010\u0013R1\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b#\u0010\f\u0012\u0004\b \u0010\u0003\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R1\u0010$\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b(\u0010\f\u0012\u0004\b%\u0010\u0003\u001a\u0004\b&\u0010\u0011\"\u0004\b'\u0010\u0013R1\u0010)\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b-\u0010\f\u0012\u0004\b*\u0010\u0003\u001a\u0004\b+\u0010\u0011\"\u0004\b,\u0010\u0013R1\u0010/\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020.8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b5\u0010\f\u0012\u0004\b0\u0010\u0003\u001a\u0004\b1\u00102\"\u0004\b3\u00104R1\u00106\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020.8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b:\u0010\f\u0012\u0004\b7\u0010\u0003\u001a\u0004\b8\u00102\"\u0004\b9\u00104R1\u0010;\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020.8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b?\u0010\f\u0012\u0004\b<\u0010\u0003\u001a\u0004\b=\u00102\"\u0004\b>\u00104R1\u0010A\u001a\u00020@2\u0006\u0010\u0004\u001a\u00020@8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bG\u0010\f\u0012\u0004\bB\u0010\u0003\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR1\u0010I\u001a\u00020H2\u0006\u0010\u0004\u001a\u00020H8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bO\u0010\f\u0012\u0004\bJ\u0010\u0003\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010P\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010D\"\u0004\bR\u0010F\u00a8\u0006\\"}, d2={"Lorg/openrndr/extra/fx/distort/Perturb;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "Lorg/openrndr/math/Vector3;", "seed", "getSeed", "()Lorg/openrndr/math/Vector3;", "setSeed", "(Lorg/openrndr/math/Vector3;)V", "seed$delegate", "Ljava/util/Map;", "", "scale", "getScale$annotations", "getScale", "()D", "setScale", "(D)V", "scale$delegate", "phase", "getPhase$annotations", "getPhase", "setPhase", "phase$delegate", "radius", "getRadius$annotations", "getRadius", "setRadius", "radius$delegate", "lacunarity", "getLacunarity$annotations", "getLacunarity", "setLacunarity", "lacunarity$delegate", "gain", "getGain$annotations", "getGain", "setGain", "gain$delegate", "decay", "getDecay$annotations", "getDecay", "setDecay", "decay$delegate", "", "octaves", "getOctaves$annotations", "getOctaves", "()I", "setOctaves", "(I)V", "octaves$delegate", "xSegments", "getXSegments$annotations", "getXSegments", "setXSegments", "xSegments$delegate", "ySegments", "getYSegments$annotations", "getYSegments", "setYSegments", "ySegments$delegate", "", "outputUV", "getOutputUV$annotations", "getOutputUV", "()Z", "setOutputUV", "(Z)V", "outputUV$delegate", "Lorg/openrndr/math/Vector2;", "offset", "getOffset$annotations", "getOffset", "()Lorg/openrndr/math/Vector2;", "setOffset", "(Lorg/openrndr/math/Vector2;)V", "offset$delegate", "bicubicFiltering", "getBicubicFiltering", "setBicubicFiltering", "apply", "", "source", "", "Lorg/openrndr/draw/ColorBuffer;", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-fx"})
public final class Perturb
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map seed$delegate = this.getParameters();
    @NotNull
    private final Map scale$delegate = this.getParameters();
    @NotNull
    private final Map phase$delegate = this.getParameters();
    @NotNull
    private final Map radius$delegate = this.getParameters();
    @NotNull
    private final Map lacunarity$delegate = this.getParameters();
    @NotNull
    private final Map gain$delegate = this.getParameters();
    @NotNull
    private final Map decay$delegate = this.getParameters();
    @NotNull
    private final Map octaves$delegate = this.getParameters();
    @NotNull
    private final Map xSegments$delegate = this.getParameters();
    @NotNull
    private final Map ySegments$delegate = this.getParameters();
    @NotNull
    private final Map outputUV$delegate = this.getParameters();
    @NotNull
    private final Map offset$delegate = this.getParameters();
    private boolean bicubicFiltering;

    public Perturb() {
        super(FilterToolsKt.mppFilterShader("// uniforms\nuniform float gain;\nuniform vec3 seed;\nuniform float phase;\nuniform float radius;\nuniform float scale;\n\nuniform float lacunarity;\nuniform float decay;\n\nuniform int octaves;\nuniform sampler2D tex0;\n\nuniform int xSegments;\nuniform int ySegments;\n\nuniform bool outputUV;\nuniform vec2 offset;\n\n// varyings\nin vec2 v_texCoord0;\n\n// outputs\nout vec4 o_output;\n\n// Simplex Noise 3D Implementation\n// Description : Array and textureless GLSL 2D/3D/4D simplex\n//               noise functions.\n//      Author : Ian McEwan, Ashima Arts.\n//  Maintainer : ijm\n//     Lastmod : 20110822 (ijm)\n//     License : Copyright (C) 2011 Ashima Arts. All rights reserved.\n//               Distributed under the MIT License. See LICENSE file.\n//               https://github.com/ashima/webgl-noise\n//               https://github.com/stegu/webgl-noise\n//\n//\nvec3 mod289(vec3 x) {\n    return x - floor(x * (1.0 / 289.0)) * 289.0;\n}\n\nvec4 mod289(vec4 x) {\n    return x - floor(x * (1.0 / 289.0)) * 289.0;\n}\n\nvec4 permute(vec4 x) {\n    return mod289(((x*34.0)+1.0)*x);\n}\n\nvec4 taylorInvSqrt(vec4 r)\n{\n    return 1.79284291400159 - 0.85373472095314 * r;\n}\n\nfloat snoise(vec3 v)\n{\n    const vec2  C = vec2(1.0/6.0, 1.0/3.0) ;\n    const vec4  D = vec4(0.0, 0.5, 1.0, 2.0);\n\n    // First corner\n    vec3 i  = floor(v + dot(v, C.yyy) );\n    vec3 x0 =   v - i + dot(i, C.xxx) ;\n\n    // Other corners\n    vec3 g = step(x0.yzx, x0.xyz);\n    vec3 l = 1.0 - g;\n    vec3 i1 = min( g.xyz, l.zxy );\n    vec3 i2 = max( g.xyz, l.zxy );\n\n    //   x0 = x0 - 0.0 + 0.0 * C.xxx;\n    //   x1 = x0 - i1  + 1.0 * C.xxx;\n    //   x2 = x0 - i2  + 2.0 * C.xxx;\n    //   x3 = x0 - 1.0 + 3.0 * C.xxx;\n    vec3 x1 = x0 - i1 + C.xxx;\n    vec3 x2 = x0 - i2 + C.yyy; // 2.0*C.x = 1/3 = C.y\n    vec3 x3 = x0 - D.yyy;      // -1.0+3.0*C.x = -0.5 = -D.y\n\n    // Permutations\n    i = mod289(i);\n    vec4 p = permute( permute( permute(\n    i.z + vec4(0.0, i1.z, i2.z, 1.0 ))\n    + i.y + vec4(0.0, i1.y, i2.y, 1.0 ))\n    + i.x + vec4(0.0, i1.x, i2.x, 1.0 ));\n\n    // Gradients: 7x7 points over a square, mapped onto an octahedron.\n    // The ring size 17*17 = 289 is close to a multiple of 49 (49*6 = 294)\n    float n_ = 0.142857142857; // 1.0/7.0\n    vec3  ns = n_ * D.wyz - D.xzx;\n\n    vec4 j = p - 49.0 * floor(p * ns.z * ns.z);  //  mod(p,7*7)\n\n    vec4 x_ = floor(j * ns.z);\n    vec4 y_ = floor(j - 7.0 * x_ );    // mod(j,N)\n\n    vec4 x = x_ *ns.x + ns.yyyy;\n    vec4 y = y_ *ns.x + ns.yyyy;\n    vec4 h = 1.0 - abs(x) - abs(y);\n\n    vec4 b0 = vec4( x.xy, y.xy );\n    vec4 b1 = vec4( x.zw, y.zw );\n\n    //vec4 s0 = vec4(lessThan(b0,0.0))*2.0 - 1.0;\n    //vec4 s1 = vec4(lessThan(b1,0.0))*2.0 - 1.0;\n    vec4 s0 = floor(b0)*2.0 + 1.0;\n    vec4 s1 = floor(b1)*2.0 + 1.0;\n    vec4 sh = -step(h, vec4(0.0));\n\n    vec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;\n    vec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;\n\n    vec3 p0 = vec3(a0.xy,h.x);\n    vec3 p1 = vec3(a0.zw,h.y);\n    vec3 p2 = vec3(a1.xy,h.z);\n    vec3 p3 = vec3(a1.zw,h.w);\n\n    //Normalise gradients\n    vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));\n    p0 *= norm.x;\n    p1 *= norm.y;\n    p2 *= norm.z;\n    p3 *= norm.w;\n\n    // Mix final noise value\n    vec4 m = max(0.6 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);\n    m = m * m;\n    return 42.0 * dot( m*m, vec4( dot(p0,x0), dot(p1,x1),\n    dot(p2,x2), dot(p3,x3) ) );\n}\n\nvec3 segment(vec3 t, int x, int y) {\n    float sx = x == 0? t.x : floor(t.x * float(x)) / float(x);\n    float sy = y == 0? t.y : floor(t.y * float(y)) / float(y);\n    return vec3(sx,sy, t.z);\n}\n\nvoid main() {\n    float tx = 0.0;\n    float ty = 0.0;\n\n    float _gain = gain;\n    float shift = 100.0;\n\n    vec3 xseed = vec3(seed.xy, seed.z+radius*cos(phase*3.1415926535));\n    vec3 yseed = vec3(seed.yx, seed.z+radius*sin(phase*3.1415926535));\n\n    vec3 uv = vec3(v_texCoord0 + offset, 1.0) * 2.0 - 1.0;\n    vec3 px = ((segment(uv, xSegments, ySegments) + xseed) * scale);\n    vec3 py = ((segment(uv, xSegments, ySegments) + yseed + vec3(100.37, 40.51, 9.43)) * scale);\n\n    for (int o = 0; o < octaves; ++o) {\n        tx += snoise(px) * _gain;\n        ty += snoise(py) * _gain;\n        px = px * lacunarity + shift;\n        py = py * lacunarity + shift;\n        _gain *= decay;\n    }\n\n    vec2 distCoord = v_texCoord0 + vec2(tx, ty);\n\n    if (!outputUV) {\n        if (distCoord.x >= 0.0 && distCoord.y >= 0.0 && distCoord.x < 1.0 && distCoord.y < 1.0) {\n            if (xSegments == 0 && ySegments == 0) {\n                o_output = texture(tex0, distCoord);\n            } else {\n                o_output = textureLod(tex0, distCoord, 0.0);\n            }\n        } else {\n            o_output = vec4(0.0);\n        }\n    } else {\n        o_output = vec4(distCoord, 0.0, 1.0);\n    }\n}\n", "perturb"), null, 2, null);
        this.setSeed(Vector3.Companion.getZERO());
        this.setScale(1.0);
        this.setLacunarity(2.0);
        this.setGain(0.5);
        this.setDecay(0.5);
        this.setOctaves(4);
        this.setPhase(0.0);
        this.setXSegments(0);
        this.setYSegments(0);
        this.setOutputUV(false);
        this.setOffset(Vector2.Companion.getZERO());
        this.setRadius(1.0);
        this.bicubicFiltering = true;
    }

    @NotNull
    public final Vector3 getSeed() {
        Map map2 = this.seed$delegate;
        return (Vector3)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName());
    }

    public final void setSeed(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        Map map2 = this.seed$delegate;
        map2.put($$delegatedProperties[0].getName(), vector3);
    }

    public final double getScale() {
        Map map2 = this.scale$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setScale(double d) {
        Map map2 = this.scale$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="scale", low=0.01, high=8.0, order=0)
    public static /* synthetic */ void getScale$annotations() {
    }

    public final double getPhase() {
        Map map2 = this.phase$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setPhase(double d) {
        Map map2 = this.phase$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="phase", low=-2.0, high=2.0, order=1)
    public static /* synthetic */ void getPhase$annotations() {
    }

    public final double getRadius() {
        Map map2 = this.radius$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setRadius(double d) {
        Map map2 = this.radius$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="radius", low=0.0, high=2.0, order=1)
    public static /* synthetic */ void getRadius$annotations() {
    }

    public final double getLacunarity() {
        Map map2 = this.lacunarity$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[4].getName())).doubleValue();
    }

    public final void setLacunarity(double d) {
        Map map2 = this.lacunarity$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[4];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="lacunarity", low=0.0, high=1.0, order=2)
    public static /* synthetic */ void getLacunarity$annotations() {
    }

    public final double getGain() {
        Map map2 = this.gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[5].getName())).doubleValue();
    }

    public final void setGain(double d) {
        Map map2 = this.gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[5];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gain", low=0.0, high=1.0, order=3)
    public static /* synthetic */ void getGain$annotations() {
    }

    public final double getDecay() {
        Map map2 = this.decay$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[6].getName())).doubleValue();
    }

    public final void setDecay(double d) {
        Map map2 = this.decay$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[6];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="decay", low=0.0, high=1.0, order=4)
    public static /* synthetic */ void getDecay$annotations() {
    }

    public final int getOctaves() {
        Map map2 = this.octaves$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[7].getName())).intValue();
    }

    public final void setOctaves(int n) {
        Map map2 = this.octaves$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[7];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="octaves", low=1, high=10, order=5)
    public static /* synthetic */ void getOctaves$annotations() {
    }

    public final int getXSegments() {
        Map map2 = this.xSegments$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[8].getName())).intValue();
    }

    public final void setXSegments(int n) {
        Map map2 = this.xSegments$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[8];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="x segments", low=0, high=256, order=6)
    public static /* synthetic */ void getXSegments$annotations() {
    }

    public final int getYSegments() {
        Map map2 = this.ySegments$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[9].getName())).intValue();
    }

    public final void setYSegments(int n) {
        Map map2 = this.ySegments$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[9];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="y segments", low=0, high=256, order=7)
    public static /* synthetic */ void getYSegments$annotations() {
    }

    public final boolean getOutputUV() {
        Map map2 = this.outputUV$delegate;
        return (Boolean)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[10].getName());
    }

    public final void setOutputUV(boolean bl) {
        Map map2 = this.outputUV$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[10];
        Boolean bl2 = bl;
        map2.put(kProperty.getName(), bl2);
    }

    @BooleanParameter(label="output UV", order=8)
    public static /* synthetic */ void getOutputUV$annotations() {
    }

    @NotNull
    public final Vector2 getOffset() {
        Map map2 = this.offset$delegate;
        return (Vector2)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[11].getName());
    }

    public final void setOffset(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        Map map2 = this.offset$delegate;
        map2.put($$delegatedProperties[11].getName(), vector2);
    }

    @Vector2Parameter(label="offset", min=-1.0, max=1.0, order=9)
    public static /* synthetic */ void getOffset$annotations() {
    }

    public final boolean getBicubicFiltering() {
        return this.bicubicFiltering;
    }

    public final void setBicubicFiltering(boolean bl) {
        this.bicubicFiltering = bl;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        if (this.bicubicFiltering && !(source.length == 0)) {
            source[0].generateMipmaps();
            source[0].filter(MinifyingFilter.LINEAR_MIPMAP_LINEAR, MagnifyingFilter.LINEAR);
        }
        super.apply(source, target2, clip);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "seed", "getSeed()Lorg/openrndr/math/Vector3;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "scale", "getScale()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "phase", "getPhase()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "radius", "getRadius()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "lacunarity", "getLacunarity()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "gain", "getGain()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "decay", "getDecay()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "octaves", "getOctaves()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "xSegments", "getXSegments()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "ySegments", "getYSegments()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "outputUV", "getOutputUV()Z", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Perturb.class, "offset", "getOffset()Lorg/openrndr/math/Vector2;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

