/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.meshgenerators;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.meshgenerators.MeshGeneratorsKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aP\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\b\u001a.\u0010\u0010\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a.\u0010\u0011\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a\u00a1\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2O\u0010\u0014\u001aK\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00130\u0015j\u0002`\u001c\u00a8\u0006\u001d"}, d2={"planeMesh", "Lorg/openrndr/draw/VertexBuffer;", "center", "Lorg/openrndr/math/Vector3;", "right", "forward", "up", "width", "", "height", "widthSegments", "", "heightSegments", "toMesh", "Lorg/openrndr/shape/Rectangle;", "resolution", "groundPlaneMesh", "wallPlaneMesh", "generatePlane", "", "writer", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "position", "normal", "Lorg/openrndr/math/Vector2;", "texCoord", "Lorg/openrndr/extra/meshgenerators/VertexWriter;", "orx-mesh-generators"})
public final class PlaneKt {
    @NotNull
    public static final VertexBuffer planeMesh(@NotNull Vector3 center, @NotNull Vector3 right, @NotNull Vector3 forward, @NotNull Vector3 up, double width, double height, int widthSegments, int heightSegments) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(right, "right");
        Intrinsics.checkNotNullParameter(forward, "forward");
        Intrinsics.checkNotNullParameter(up, "up");
        int vertexCount = widthSegments * heightSegments * 6;
        VertexBuffer vb = MeshGeneratorsKt.meshVertexBuffer(vertexCount);
        VertexBuffer.put$default(vb, 0, arg_0 -> PlaneKt.planeMesh$lambda$0(center, right, forward, up, width, height, widthSegments, heightSegments, arg_0), 1, null);
        return vb;
    }

    public static /* synthetic */ VertexBuffer planeMesh$default(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, double d, double d2, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            vector34 = (Vector3)vector33.cross(vector32).getNormalized();
        }
        if ((n3 & 0x10) != 0) {
            d = 1.0;
        }
        if ((n3 & 0x20) != 0) {
            d2 = 1.0;
        }
        if ((n3 & 0x40) != 0) {
            n = 1;
        }
        if ((n3 & 0x80) != 0) {
            n2 = 1;
        }
        return PlaneKt.planeMesh(vector3, vector32, vector33, vector34, d, d2, n, n2);
    }

    @NotNull
    public static final VertexBuffer toMesh(@NotNull Rectangle $this$toMesh, double resolution) {
        Intrinsics.checkNotNullParameter($this$toMesh, "<this>");
        return PlaneKt.planeMesh($this$toMesh.center().xy0(), Vector3.Companion.getUNIT_X(), Vector3.Companion.getUNIT_Y(), Vector3.Companion.getUNIT_Z(), $this$toMesh.width(), $this$toMesh.height(), (int)($this$toMesh.width() / resolution), (int)($this$toMesh.height() / resolution));
    }

    public static /* synthetic */ VertexBuffer toMesh$default(Rectangle rectangle, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 2.0;
        }
        return PlaneKt.toMesh(rectangle, d);
    }

    @NotNull
    public static final VertexBuffer groundPlaneMesh(double width, double height, int widthSegments, int heightSegments) {
        return PlaneKt.planeMesh(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_X(), Vector3.Companion.getUNIT_Z(), Vector3.Companion.getUNIT_Y(), width, height, widthSegments, heightSegments);
    }

    public static /* synthetic */ VertexBuffer groundPlaneMesh$default(double d, double d2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            d = 1.0;
        }
        if ((n3 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n3 & 4) != 0) {
            n = 1;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        return PlaneKt.groundPlaneMesh(d, d2, n, n2);
    }

    @NotNull
    public static final VertexBuffer wallPlaneMesh(double width, double height, int widthSegments, int heightSegments) {
        return PlaneKt.planeMesh(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_X(), Vector3.Companion.getUNIT_Y(), Vector3.Companion.getUNIT_Z(), width, height, widthSegments, heightSegments);
    }

    public static /* synthetic */ VertexBuffer wallPlaneMesh$default(double d, double d2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            d = 1.0;
        }
        if ((n3 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n3 & 4) != 0) {
            n = 1;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        return PlaneKt.wallPlaneMesh(d, d2, n, n2);
    }

    public static final void generatePlane(@NotNull Vector3 center, @NotNull Vector3 right, @NotNull Vector3 forward, @NotNull Vector3 up, double width, double height, int widthSegments, int heightSegments, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(right, "right");
        Intrinsics.checkNotNullParameter(forward, "forward");
        Intrinsics.checkNotNullParameter(up, "up");
        Intrinsics.checkNotNullParameter(writer, "writer");
        Vector3 forwardStep = ((Vector3)forward.getNormalized()).times(height / (double)heightSegments);
        Vector3 rightStep = ((Vector3)right.getNormalized()).times(width / (double)widthSegments);
        Vector3 corner = center.minus(((Vector3)forward.getNormalized()).times(height * 0.5)).minus(((Vector3)right.getNormalized()).times(width * 0.5));
        Vector2 step = new Vector2(1.0 / (double)widthSegments, 1.0 / (double)heightSegments);
        for (int v = 0; v < heightSegments; ++v) {
            for (int u = 0; u < widthSegments; ++u) {
                Vector2 uv00 = new Vector2((double)u + 0.0, (double)v + 0.0).times(step);
                Vector2 uv01 = new Vector2((double)u + 0.0, (double)v + 1.0).times(step);
                Vector2 uv10 = new Vector2((double)u + 1.0, (double)v + 0.0).times(step);
                Vector2 uv11 = new Vector2((double)u + 1.0, (double)v + 1.0).times(step);
                Vector3 c00 = corner.plus(forwardStep.times(v)).plus(rightStep.times(u));
                Vector3 c01 = corner.plus(forwardStep.times(v + 1)).plus(rightStep.times(u));
                Vector3 c10 = corner.plus(forwardStep.times(v)).plus(rightStep.times(u + 1));
                Vector3 c11 = corner.plus(forwardStep.times(v + 1)).plus(rightStep.times(u + 1));
                writer.invoke(c11, up, uv00);
                writer.invoke(c10, up, uv10);
                writer.invoke(c00, up, uv11);
                writer.invoke(c00, up, uv11);
                writer.invoke(c01, up, uv01);
                writer.invoke(c11, up, uv00);
            }
        }
    }

    public static /* synthetic */ void generatePlane$default(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, double d, double d2, int n, int n2, Function3 function3, int n3, Object object) {
        if ((n3 & 8) != 0) {
            vector34 = (Vector3)vector33.cross(vector32).getNormalized();
        }
        if ((n3 & 0x10) != 0) {
            d = 1.0;
        }
        if ((n3 & 0x20) != 0) {
            d2 = 1.0;
        }
        if ((n3 & 0x40) != 0) {
            n = 1;
        }
        if ((n3 & 0x80) != 0) {
            n2 = 1;
        }
        PlaneKt.generatePlane(vector3, vector32, vector33, vector34, d, d2, n, n2, function3);
    }

    private static final Unit planeMesh$lambda$0(Vector3 $center, Vector3 $right, Vector3 $forward, Vector3 $up, double $width, double $height, int $widthSegments, int $heightSegments, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        PlaneKt.generatePlane($center, $right, $forward, $up, $width, $height, $widthSegments, $heightSegments, MeshGeneratorsKt.bufferWriter($this$put));
        return Unit.INSTANCE;
    }
}

