/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.meshgenerators;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.meshgenerators.MeshGeneratorsKt;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a{\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2O\u0010\u000b\u001aK\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\n0\fj\u0002`\u0014\u001a{\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2O\u0010\u000b\u001aK\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\n0\fj\u0002`\u0014\u00a8\u0006\u0016"}, d2={"sphereMesh", "Lorg/openrndr/draw/VertexBuffer;", "sides", "", "segments", "radius", "", "flipNormals", "", "generateSphere", "", "writer", "Lkotlin/Function3;", "Lorg/openrndr/math/Vector3;", "Lkotlin/ParameterName;", "name", "position", "normal", "Lorg/openrndr/math/Vector2;", "texCoord", "Lorg/openrndr/extra/meshgenerators/VertexWriter;", "generateHemisphere", "orx-mesh-generators"})
public final class SphereKt {
    @NotNull
    public static final VertexBuffer sphereMesh(int sides, int segments, double radius, boolean flipNormals) {
        int vertexCount = 2 * sides * 3 + Math.max(0, segments - 2) * sides * 6;
        VertexBuffer vb = MeshGeneratorsKt.meshVertexBuffer(vertexCount);
        VertexBuffer.put$default(vb, 0, arg_0 -> SphereKt.sphereMesh$lambda$0(sides, segments, radius, flipNormals, arg_0), 1, null);
        return vb;
    }

    public static /* synthetic */ VertexBuffer sphereMesh$default(int n, int n2, double d, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 16;
        }
        if ((n3 & 2) != 0) {
            n2 = 16;
        }
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return SphereKt.sphereMesh(n, n2, d, bl);
    }

    public static final void generateSphere(int sides, int segments, double radius, boolean flipNormals, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        double invertFactor = flipNormals ? -1.0 : 1.0;
        for (int t = 0; t < segments; ++t) {
            for (int s = 0; s < sides; ++s) {
                Spherical st00 = new Spherical((double)s * 180.0 * 2.0 / (double)sides, (double)t * 180.0 / (double)segments, radius);
                Spherical st01 = new Spherical((double)s * 180.0 * 2.0 / (double)sides, (double)(t + 1) * 180.0 / (double)segments, radius);
                Spherical st10 = new Spherical((double)(s + 1) * 180.0 * 2.0 / (double)sides, (double)t * 180.0 / (double)segments, radius);
                Spherical st11 = new Spherical((double)(s + 1) * 180.0 * 2.0 / (double)sides, (double)(t + 1) * 180.0 / (double)segments, radius);
                double thetaMax = 360.0;
                double phiMax = 180.0;
                int n = t;
                if (n == 0) {
                    writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax, 1.0 - st00.phi() / phiMax));
                    writer.invoke(st01.cartesian(), ((Vector3)st01.cartesian().getNormalized()).times(invertFactor), new Vector2(st01.theta() / thetaMax, 1.0 - st01.phi() / phiMax));
                    writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax, 1.0 - st11.phi() / phiMax));
                    continue;
                }
                if (n == segments - 1) {
                    writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax, 1.0 - st11.phi() / phiMax));
                    writer.invoke(st10.cartesian(), ((Vector3)st10.cartesian().getNormalized()).times(invertFactor), new Vector2(st10.theta() / thetaMax, 1.0 - st10.phi() / phiMax));
                    writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax, 1.0 - st00.phi() / phiMax));
                    continue;
                }
                writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax, 1.0 - st00.phi() / phiMax));
                writer.invoke(st01.cartesian(), ((Vector3)st01.cartesian().getNormalized()).times(invertFactor), new Vector2(st01.theta() / thetaMax, 1.0 - st01.phi() / phiMax));
                writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax, 1.0 - st11.phi() / phiMax));
                writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax, 1.0 - st11.phi() / phiMax));
                writer.invoke(st10.cartesian(), ((Vector3)st10.cartesian().getNormalized()).times(invertFactor), new Vector2(st10.theta() / thetaMax, 1.0 - st10.phi() / phiMax));
                writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax, 1.0 - st00.phi() / phiMax));
            }
        }
    }

    public static /* synthetic */ void generateSphere$default(int n, int n2, double d, boolean bl, Function3 function3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        SphereKt.generateSphere(n, n2, d, bl, function3);
    }

    public static final void generateHemisphere(int sides, int segments, double radius, boolean flipNormals, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        double invertFactor = flipNormals ? -1.0 : 1.0;
        for (int t = 0; t < segments; ++t) {
            for (int s = 0; s < sides; ++s) {
                Spherical st00 = new Spherical((double)s * 180.0 * 2.0 / (double)sides, (double)t * 180.0 / (double)segments, radius);
                Spherical st01 = new Spherical((double)s * 180.0 * 2.0 / (double)sides, (double)(t + 1) * 180.0 / (double)segments, radius);
                Spherical st10 = new Spherical((double)(s + 1) * 180.0 * 2.0 / (double)sides, (double)t * 180.0 / (double)segments, radius);
                Spherical st11 = new Spherical((double)(s + 1) * 180.0 * 2.0 / (double)sides, (double)(t + 1) * 180.0 / (double)segments, radius);
                double thetaMax = 360.0;
                double phiMax = 90.0;
                if (t == 0) {
                    writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax + 0.5, 1.0 - st00.phi() / phiMax));
                    writer.invoke(st01.cartesian(), ((Vector3)st01.cartesian().getNormalized()).times(invertFactor), new Vector2(st01.theta() / thetaMax + 0.5, 1.0 - st01.phi() / phiMax));
                    writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax + 0.5, 1.0 - st11.phi() / phiMax));
                    continue;
                }
                writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax + 0.5, 1.0 - st00.phi() / phiMax));
                writer.invoke(st01.cartesian(), ((Vector3)st01.cartesian().getNormalized()).times(invertFactor), new Vector2(st01.theta() / thetaMax + 0.5, 1.0 - st01.phi() / phiMax));
                writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax + 0.5, 1.0 - st11.phi() / phiMax));
                writer.invoke(st11.cartesian(), ((Vector3)st11.cartesian().getNormalized()).times(invertFactor), new Vector2(st11.theta() / thetaMax + 0.5, 1.0 - st11.phi() / phiMax));
                writer.invoke(st10.cartesian(), ((Vector3)st10.cartesian().getNormalized()).times(invertFactor), new Vector2(st10.theta() / thetaMax + 0.5, 1.0 - st10.phi() / phiMax));
                writer.invoke(st00.cartesian(), ((Vector3)st00.cartesian().getNormalized()).times(invertFactor), new Vector2(st00.theta() / thetaMax + 0.5, 1.0 - st00.phi() / phiMax));
            }
        }
    }

    public static /* synthetic */ void generateHemisphere$default(int n, int n2, double d, boolean bl, Function3 function3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        SphereKt.generateHemisphere(n, n2, d, bl, function3);
    }

    private static final Unit sphereMesh$lambda$0(int $sides, int $segments, double $radius, boolean $flipNormals, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        SphereKt.generateSphere($sides, $segments, $radius, $flipNormals, MeshGeneratorsKt.bufferWriter($this$put));
        return Unit.INSTANCE;
    }
}

