/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ImageFileDetails;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.internal.CubemapImageData;
import org.openrndr.internal.DdsImageSaveConfiguration;
import org.openrndr.internal.ExrImageSaveConfiguration;
import org.openrndr.internal.HdrImageSaveConfiguration;
import org.openrndr.internal.ImageData;
import org.openrndr.internal.ImageSaveConfiguration;
import org.openrndr.internal.ImageSaveContext;
import org.openrndr.internal.JpegImageSaveConfiguration;
import org.openrndr.internal.PngImageSaveConfiguration;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cJ\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH&J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH&J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H&J1\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\u0002\b\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH&J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/internal/ImageDriver;", "", "probeImage", "Lorg/openrndr/draw/ImageFileDetails;", "fileOrUrl", "", "buffer", "Lorg/openrndr/utils/buffer/MPPBuffer;", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "loadImage", "Lorg/openrndr/internal/ImageData;", "allowSRGB", "", "name", "saveImage", "", "imageData", "filename", "configuration", "Lorg/openrndr/internal/ImageSaveConfiguration;", "saveContext", "Lkotlin/Function1;", "Lorg/openrndr/internal/ImageSaveContext;", "Lkotlin/ExtensionFunctionType;", "imageToDataUrl", "loadCubemapImage", "Lorg/openrndr/internal/CubemapImageData;", "Companion", "openrndr-draw"})
public interface ImageDriver {
    @NotNull
    public static final Companion Companion = org.openrndr.internal.ImageDriver$Companion.$$INSTANCE;

    @Nullable
    public ImageFileDetails probeImage(@NotNull String var1);

    @Nullable
    public ImageFileDetails probeImage(@NotNull MPPBuffer var1, @Nullable ImageFileFormat var2);

    @NotNull
    public ImageData loadImage(@NotNull String var1, @Nullable ImageFileFormat var2, boolean var3);

    @NotNull
    public ImageData loadImage(@NotNull MPPBuffer var1, @Nullable String var2, @Nullable ImageFileFormat var3, boolean var4);

    public void saveImage(@NotNull ImageData var1, @NotNull String var2, @Nullable ImageFileFormat var3);

    public void saveImage(@NotNull ImageData var1, @NotNull String var2, @NotNull ImageSaveConfiguration var3);

    public void saveImage(@NotNull ImageData var1, @NotNull String var2, @NotNull Function1<? super ImageSaveContext, ? extends ImageSaveConfiguration> var3);

    @NotNull
    public String imageToDataUrl(@NotNull ImageData var1, @Nullable ImageFileFormat var2);

    @NotNull
    public CubemapImageData loadCubemapImage(@NotNull String var1, @Nullable ImageFileFormat var2);

    @NotNull
    public CubemapImageData loadCubemapImage(@NotNull MPPBuffer var1, @Nullable String var2, @Nullable ImageFileFormat var3);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/openrndr/internal/ImageDriver$Companion;", "", "<init>", "()V", "driver", "Lorg/openrndr/internal/ImageDriver;", "getDriver", "()Lorg/openrndr/internal/ImageDriver;", "setDriver", "(Lorg/openrndr/internal/ImageDriver;)V", "instance", "getInstance", "openrndr-draw"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Nullable
        private static ImageDriver driver;

        private Companion() {
        }

        @Nullable
        public final ImageDriver getDriver() {
            return driver;
        }

        public final void setDriver(@Nullable ImageDriver imageDriver) {
            driver = imageDriver;
        }

        @NotNull
        public final ImageDriver getInstance() {
            ImageDriver imageDriver = driver;
            if (imageDriver == null) {
                throw new IllegalStateException("ImageDriver not initialized".toString());
            }
            return imageDriver;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void saveImage(@NotNull ImageDriver $this, @NotNull ImageData imageData, @NotNull String filename, @Nullable ImageFileFormat formatHint) {
            Intrinsics.checkNotNullParameter(imageData, "imageData");
            Intrinsics.checkNotNullParameter(filename, "filename");
            ImageFileFormat imageFileFormat = formatHint;
            if (imageFileFormat == null) {
                imageFileFormat = ImageFileFormat.PNG;
            }
            ImageFileFormat assumedFormat = imageFileFormat;
            ImageSaveConfiguration config = switch (WhenMappings.$EnumSwitchMapping$0[assumedFormat.ordinal()]) {
                case 1 -> new JpegImageSaveConfiguration(0, 1, null);
                case 2 -> new ExrImageSaveConfiguration(0, 1, null);
                case 3 -> new PngImageSaveConfiguration();
                case 4 -> new DdsImageSaveConfiguration();
                case 5 -> new HdrImageSaveConfiguration();
                default -> throw new NoWhenBranchMatchedException();
            };
            $this.saveImage(imageData, filename, config);
        }

        public static void saveImage(@NotNull ImageDriver $this, @NotNull ImageData imageData, @NotNull String filename, @NotNull Function1<? super ImageSaveContext, ? extends ImageSaveConfiguration> saveContext) {
            Intrinsics.checkNotNullParameter(imageData, "imageData");
            Intrinsics.checkNotNullParameter(filename, "filename");
            Intrinsics.checkNotNullParameter(saveContext, "saveContext");
            ImageSaveContext context = new ImageSaveContext();
            ImageSaveConfiguration config = saveContext.invoke(context);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageFileFormat.values().length];
            try {
                nArray[ImageFileFormat.JPG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.EXR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.PNG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.DDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.HDR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

