/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.lwjgl.system.MemoryStack;
import org.openrndr.ApplicationWindow;
import org.openrndr.CharacterEvent;
import org.openrndr.CursorType;
import org.openrndr.DropEvent;
import org.openrndr.Extension;
import org.openrndr.KeyEvent;
import org.openrndr.KeyEventType;
import org.openrndr.KeyModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseCursorHideMode;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEventType;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.WindowEvent;
import org.openrndr.WindowEventType;
import org.openrndr.WindowMultisample;
import org.openrndr.events.Event;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGLFWGL3;
import org.openrndr.internal.gl3.ApplicationGlfwConfiguration;
import org.openrndr.internal.gl3.ApplicationWindowGLFWKt;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u001eJ\b\u0010Z\u001a\u00020\u001eH\u0016J\u0006\u0010^\u001a\u00020\u001eJ\u000e\u0010_\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010`\u001a\u00020\u001eH\u0002J\b\u0010a\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010/\u001a\u00020.2\u0006\u0010)\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0010\u00104\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020.2\u0006\u0010)\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00101\"\u0004\b7\u00103R\u001a\u00108\u001a\u00020.X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00101\"\u0004\b:\u00103R$\u0010;\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0016\"\u0004\b=\u0010>R$\u0010@\u001a\u00020?2\u0006\u0010)\u001a\u00020?@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR'\u0010E\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020\u00050F8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bH\u0010IR$\u0010L\u001a\u00020G2\u0006\u0010)\u001a\u00020G@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u0016\"\u0004\bS\u0010>R\u001a\u0010T\u001a\u00020UX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010[\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0016\"\u0004\b]\u0010>\u00a8\u0006b"}, d2={"Lorg/openrndr/internal/gl3/ApplicationWindowGLFW;", "Lorg/openrndr/ApplicationWindow;", "application", "Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "window", "", "windowTitle", "", "windowResizable", "", "windowMultisample", "Lorg/openrndr/WindowMultisample;", "windowClosable", "program", "Lorg/openrndr/Program;", "<init>", "(Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;JLjava/lang/String;ZLorg/openrndr/WindowMultisample;ZLorg/openrndr/Program;)V", "getApplication", "()Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "getWindow", "()J", "getWindowResizable", "()Z", "getWindowMultisample", "()Lorg/openrndr/WindowMultisample;", "getWindowClosable", "defaultRenderTargetGL3", "Lorg/openrndr/internal/gl3/ProgramRenderTargetGL3;", "drawRequested", "updateSize", "", "updateSize$openrndr_gl3", "setupRenderTarget", "update", "_", "", "windowContentScale", "getWindowContentScale", "()D", "setWindowContentScale", "(D)V", "value", "getWindowTitle", "()Ljava/lang/String;", "setWindowTitle", "(Ljava/lang/String;)V", "Lorg/openrndr/math/Vector2;", "windowPosition", "getWindowPosition", "()Lorg/openrndr/math/Vector2;", "setWindowPosition", "(Lorg/openrndr/math/Vector2;)V", "_windowSize", "windowSize", "getWindowSize", "setWindowSize", "cursorPosition", "getCursorPosition", "setCursorPosition", "cursorVisible", "getCursorVisible", "setCursorVisible", "(Z)V", "Lorg/openrndr/MouseCursorHideMode;", "cursorHideMode", "getCursorHideMode", "()Lorg/openrndr/MouseCursorHideMode;", "setCursorHideMode", "(Lorg/openrndr/MouseCursorHideMode;)V", "cursorCache", "", "Lorg/openrndr/CursorType;", "getCursorCache", "()Ljava/util/Map;", "cursorCache$delegate", "Lkotlin/Lazy;", "cursorType", "getCursorType", "()Lorg/openrndr/CursorType;", "setCursorType", "(Lorg/openrndr/CursorType;)V", "cursorInWindow", "getCursorInWindow", "setCursorInWindow", "presentationMode", "Lorg/openrndr/PresentationMode;", "getPresentationMode", "()Lorg/openrndr/PresentationMode;", "setPresentationMode", "(Lorg/openrndr/PresentationMode;)V", "requestDraw", "windowFocused", "getWindowFocused", "setWindowFocused", "setDefaultIcon", "setupGlfwEvents", "deliverEvents", "destroy", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nApplicationWindowGLFW.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationWindowGLFW.kt\norg/openrndr/internal/gl3/ApplicationWindowGLFW\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,621:1\n117#2,3:622\n381#3,7:625\n1557#4:632\n1628#4,3:633\n1557#4:636\n1628#4,3:637\n*S KotlinDebug\n*F\n+ 1 ApplicationWindowGLFW.kt\norg/openrndr/internal/gl3/ApplicationWindowGLFW\n*L\n47#1:622,3\n167#1:625,7\n311#1:632\n311#1:633,3\n314#1:636\n314#1:637,3\n*E\n"})
public final class ApplicationWindowGLFW
extends ApplicationWindow {
    @NotNull
    private final ApplicationGLFWGL3 application;
    private final long window;
    private final boolean windowResizable;
    @NotNull
    private final WindowMultisample windowMultisample;
    private final boolean windowClosable;
    @Nullable
    private ProgramRenderTargetGL3 defaultRenderTargetGL3;
    private boolean drawRequested;
    @NotNull
    private String windowTitle;
    @Nullable
    private Vector2 _windowSize;
    @NotNull
    private Vector2 cursorPosition;
    private boolean cursorVisible;
    @NotNull
    private MouseCursorHideMode cursorHideMode;
    @NotNull
    private final Lazy cursorCache$delegate;
    @NotNull
    private CursorType cursorType;
    private boolean cursorInWindow;
    @NotNull
    private PresentationMode presentationMode;
    private boolean windowFocused;

    public ApplicationWindowGLFW(@NotNull ApplicationGLFWGL3 application, long window2, @NotNull String windowTitle, boolean windowResizable, @NotNull WindowMultisample windowMultisample, boolean windowClosable, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(application, "application");
        Intrinsics.checkNotNullParameter(windowTitle, "windowTitle");
        Intrinsics.checkNotNullParameter(windowMultisample, "windowMultisample");
        Intrinsics.checkNotNullParameter(program2, "program");
        super(program2);
        this.application = application;
        this.window = window2;
        this.windowResizable = windowResizable;
        this.windowMultisample = windowMultisample;
        this.windowClosable = windowClosable;
        this.drawRequested = true;
        this.windowTitle = windowTitle;
        this.cursorPosition = Vector2.Companion.getZERO();
        this.cursorVisible = true;
        this.cursorHideMode = MouseCursorHideMode.HIDE;
        this.cursorCache$delegate = LazyKt.lazy(ApplicationWindowGLFW::cursorCache_delegate$lambda$4);
        this.cursorType = CursorType.ARROW_CURSOR;
        this.presentationMode = PresentationMode.AUTOMATIC;
    }

    @NotNull
    public final ApplicationGLFWGL3 getApplication() {
        return this.application;
    }

    public final long getWindow() {
        return this.window;
    }

    @Override
    public boolean getWindowResizable() {
        return this.windowResizable;
    }

    @Override
    @NotNull
    public WindowMultisample getWindowMultisample() {
        return this.windowMultisample;
    }

    @Override
    public boolean getWindowClosable() {
        return this.windowClosable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void updateSize$openrndr_gl3() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            FloatBuffer floatBuffer = stack.mallocFloat(1);
            Intrinsics.checkNotNullExpressionValue(floatBuffer, "mallocFloat(...)");
            FloatBuffer wcsx = floatBuffer;
            FloatBuffer floatBuffer2 = stack.mallocFloat(1);
            Intrinsics.checkNotNullExpressionValue(floatBuffer2, "mallocFloat(...)");
            FloatBuffer wcsy = floatBuffer2;
            GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
            this.getProgram().getWindow().setContentScale(wcsx.get(0));
            IntBuffer intBuffer = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer fbw = intBuffer;
            IntBuffer intBuffer2 = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer2, "mallocInt(...)");
            IntBuffer fbh = intBuffer2;
            GLFW.glfwGetFramebufferSize(this.window, fbw, fbh);
            boolean bl2 = false;
            boolean bl3 = false;
            int n = fbw.get(0);
            int h$iv = fbh.get(0);
            boolean $i$f$glViewport = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void w$iv;
                    void y$iv;
                    void x$iv;
                    GL45C.glViewport((int)x$iv, (int)y$iv, (int)w$iv, h$iv);
                    break;
                }
                case 2: {
                    void w$iv;
                    void y$iv;
                    void x$iv;
                    GLES32.glViewport((int)x$iv, (int)y$iv, (int)w$iv, h$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.getProgram().setWidth((int)Math.ceil((double)fbw.get(0) / this.getProgram().getWindow().getContentScale()));
            this.getProgram().setHeight((int)Math.ceil((double)fbh.get(0) / this.getProgram().getWindow().getContentScale()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public final void setupRenderTarget() {
        GLFW.glfwMakeContextCurrent(this.window);
        if (this.defaultRenderTargetGL3 == null) {
            ApplicationWindowGLFWKt.access$getLogger$p().debug(ApplicationWindowGLFW::setupRenderTarget$lambda$1);
            ProgramRenderTargetGL3 programRenderTargetGL3 = this.defaultRenderTargetGL3 = new ProgramRenderTargetGL3(this.getProgram());
            Intrinsics.checkNotNull(programRenderTargetGL3);
            programRenderTargetGL3.bind();
        }
    }

    public final void update() {
        this.deliverEvents();
        if (this.getPresentationMode() == PresentationMode.AUTOMATIC || this.drawRequested || this.getProgram().getDispatcher().getShouldExecute()) {
            this.setupRenderTarget();
            this.updateSize$openrndr_gl3();
            this.getProgram().getDrawer().reset();
            this.getProgram().getDrawer().ortho();
            ProgramRenderTargetGL3 programRenderTargetGL3 = this.defaultRenderTargetGL3;
            Intrinsics.checkNotNull(programRenderTargetGL3);
            programRenderTargetGL3.bindTarget();
            this.getProgram().getDispatcher().execute();
        }
        if (this.getPresentationMode() == PresentationMode.AUTOMATIC || this.drawRequested) {
            this.getProgram().drawImpl();
            GLFW.glfwSwapBuffers(this.window);
        }
    }

    @Override
    public double getWindowContentScale() {
        float[] wcsx = new float[1];
        float[] wcsy = new float[1];
        GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
        return wcsx[0];
    }

    @Override
    public void setWindowContentScale(double d) {
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return this.windowTitle;
    }

    @Override
    public void setWindowTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.windowTitle = value;
        GLFW.glfwSetWindowTitle(this.window, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = it.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer x = intBuffer;
            IntBuffer intBuffer2 = it.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer2, "mallocInt(...)");
            IntBuffer y = intBuffer2;
            GLFW.glfwGetWindowPos(this.window, x, y);
            Vector2 vector2 = new Vector2(ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)x.get(0) / this.getProgram().getWindow().getContentScale() : (double)x.get(0), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)y.get(0) / this.getProgram().getWindow().getContentScale() : (double)y.get(0));
            return vector2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value) {
        Intrinsics.checkNotNullParameter(value, "value");
        GLFW.glfwSetWindowPos(this.window, ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value.x() * this.getProgram().getWindow().getContentScale()) : (int)value.x(), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value.y() * this.getProgram().getWindow().getContentScale()) : (int)value.y());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Vector2 getWindowSize() {
        if (this._windowSize == null) {
            AutoCloseable autoCloseable = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                MemoryStack it = (MemoryStack)autoCloseable;
                boolean bl = false;
                IntBuffer intBuffer = it.mallocInt(1);
                Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
                IntBuffer w = intBuffer;
                IntBuffer intBuffer2 = it.mallocInt(1);
                Intrinsics.checkNotNullExpressionValue(intBuffer2, "mallocInt(...)");
                IntBuffer h = intBuffer2;
                GLFW.glfwGetWindowSize(this.window, w, h);
                this._windowSize = new Vector2(ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)w.get(0) / this.getProgram().getWindow().getContentScale() : (double)w.get(0), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)h.get(0) / this.getProgram().getWindow().getContentScale() : (double)h.get(0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        Vector2 vector2 = this._windowSize;
        if (vector2 == null) {
            throw new IllegalStateException("window size unknown".toString());
        }
        return vector2;
    }

    @Override
    public void setWindowSize(@NotNull Vector2 value) {
        Intrinsics.checkNotNullParameter(value, "value");
        GLFW.glfwSetWindowSize(this.window, ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value.x() * this.getProgram().getWindow().getContentScale()) : (int)value.x(), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value.y() * this.getProgram().getWindow().getContentScale()) : (int)value.y());
        this._windowSize = null;
    }

    @Override
    @NotNull
    public Vector2 getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void setCursorPosition(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.cursorPosition = vector2;
    }

    @Override
    public boolean getCursorVisible() {
        return this.cursorVisible;
    }

    @Override
    public void setCursorVisible(boolean value) {
        this.cursorVisible = value;
        if (value) {
            GLFW.glfwSetInputMode(this.window, 208897, 212993);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getCursorHideMode().ordinal()]) {
                case 1: {
                    GLFW.glfwSetInputMode(this.window, 208897, 212994);
                    break;
                }
                case 2: {
                    GLFW.glfwSetInputMode(this.window, 208897, 212995);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    @NotNull
    public MouseCursorHideMode getCursorHideMode() {
        return this.cursorHideMode;
    }

    @Override
    public void setCursorHideMode(@NotNull MouseCursorHideMode value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        this.cursorHideMode = value;
        this.setCursorVisible(this.getCursorVisible());
    }

    private final Map<CursorType, Long> getCursorCache() {
        Lazy lazy = this.cursorCache$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Override
    public void setCursorType(@NotNull CursorType value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        if (value != this.cursorType) {
            Long l;
            Map<CursorType, Long> $this$getOrPut$iv = this.getCursorCache();
            boolean $i$f$getOrPut = false;
            Long value$iv = $this$getOrPut$iv.get((Object)value);
            if (value$iv == null) {
                boolean bl = false;
                int glfwCursor = switch (WhenMappings.$EnumSwitchMapping$1[value.ordinal()]) {
                    case 1 -> 221185;
                    case 2 -> 221186;
                    case 3 -> 221188;
                    case 4 -> 221187;
                    case 5 -> 221189;
                    case 6 -> 221190;
                    default -> throw new NoWhenBranchMatchedException();
                };
                Long answer$iv = GLFW.glfwCreateStandardCursor(glfwCursor);
                $this$getOrPut$iv.put(value, answer$iv);
                l = answer$iv;
            } else {
                l = value$iv;
            }
            long cursor = ((Number)l).longValue();
            GLFW.glfwSetCursor(this.window, cursor);
            this.cursorType = value;
        }
    }

    @Override
    public boolean getCursorInWindow() {
        return this.cursorInWindow;
    }

    public void setCursorInWindow(boolean bl) {
        this.cursorInWindow = bl;
    }

    @Override
    @NotNull
    public PresentationMode getPresentationMode() {
        return this.presentationMode;
    }

    @Override
    public void setPresentationMode(@NotNull PresentationMode presentationMode) {
        Intrinsics.checkNotNullParameter((Object)presentationMode, "<set-?>");
        this.presentationMode = presentationMode;
    }

    @Override
    public void requestDraw() {
        this.drawRequested = true;
    }

    @Override
    public boolean getWindowFocused() {
        return this.windowFocused;
    }

    public void setWindowFocused(boolean bl) {
        this.windowFocused = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDefaultIcon() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(65536);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "createByteBuffer(...)");
        ByteBuffer buf = byteBuffer;
        ((Buffer)buf).rewind();
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                buf.putInt(-4142081);
            }
        }
        ((Buffer)buf).flip();
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            GLFW.glfwSetWindowIcon(this.window, GLFWImage.malloc(1, it).width(128).height(128).pixels(buf));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public final void setupGlfwEvents(@NotNull ApplicationGLFWGL3 application) {
        Intrinsics.checkNotNullParameter(application, "application");
        Set modifiers = new LinkedHashSet();
        Ref.BooleanRef down = new Ref.BooleanRef();
        Ref.ObjectRef lastDragPosition = new Ref.ObjectRef();
        lastDragPosition.element = Vector2.Companion.getZERO();
        Ref.ObjectRef lastMouseButtonDown = new Ref.ObjectRef();
        lastMouseButtonDown.element = MouseButton.NONE;
        Ref.IntRef readyFrames = new Ref.IntRef();
        GLFW.glfwSetKeyCallback(this.window, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$7(modifiers, this, arg_0, arg_1, arg_2, arg_3, arg_4));
        GLFW.glfwSetCharCallback(this.window, (arg_0, arg_1) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$8(this, arg_0, arg_1));
        GLFW.glfwSetDropCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$12(this, arg_0, arg_1, arg_2));
        GLFW.glfwSetFramebufferSizeCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$14(this, readyFrames, arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowPosCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$16(this, arg_0, arg_1, arg_2));
        GLFW.glfwSetScrollCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$17(this, modifiers, arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowIconifyCallback(this.window, (arg_0, arg_1) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$18(this, arg_0, arg_1));
        GLFW.glfwSetWindowFocusCallback(this.window, (arg_0, arg_1) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$20(this, arg_0, arg_1));
        GLFW.glfwSetWindowCloseCallback(this.window, arg_0 -> ApplicationWindowGLFW.setupGlfwEvents$lambda$22(this, arg_0));
        GLFW.glfwSetCursorEnterCallback(this.window, (arg_0, arg_1) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$23(this, arg_0, arg_1));
        GLFW.glfwSetMouseButtonCallback(this.window, (arg_0, arg_1, arg_2, arg_3) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$24(down, lastDragPosition, this, lastMouseButtonDown, modifiers, arg_0, arg_1, arg_2, arg_3));
        GLFW.glfwSetCursorPosCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationWindowGLFW.setupGlfwEvents$lambda$26(this, modifiers, down, lastDragPosition, lastMouseButtonDown, arg_0, arg_1, arg_2));
    }

    private final void deliverEvents() {
        GLFW.glfwMakeContextCurrent(this.window);
        this.getProgram().getWindow().getDrop().deliver();
        this.getProgram().getWindow().getSized().deliver();
        this.getProgram().getWindow().getUnfocused().deliver();
        this.getProgram().getWindow().getFocused().deliver();
        this.getProgram().getWindow().getMinimized().deliver();
        this.getProgram().getWindow().getRestored().deliver();
        this.getProgram().getKeyboard().getKeyDown().deliver();
        this.getProgram().getKeyboard().getKeyUp().deliver();
        this.getProgram().getKeyboard().getKeyRepeat().deliver();
        this.getProgram().getKeyboard().getCharacter().deliver();
        this.getProgram().getMouse().getMoved().deliver();
        this.getProgram().getMouse().getScrolled().deliver();
        this.getProgram().getMouse().getButtonDown().deliver();
        this.getProgram().getMouse().getButtonUp().deliver();
        this.getProgram().getMouse().getDragged().deliver();
        this.getProgram().getMouse().getEntered().deliver();
        this.getProgram().getMouse().getExited().deliver();
    }

    @Override
    public void destroy() {
        ApplicationWindowGLFWKt.access$getLogger$p().debug(() -> ApplicationWindowGLFW.destroy$lambda$27(this));
        for (Extension extension : this.getProgram().getExtensions()) {
            extension.shutdown(this.getProgram());
        }
        Driver.Companion.getInstance().destroyContext(this.window);
        GLFW.glfwDestroyWindow(this.window);
        this.application.getWindows$openrndr_gl3().remove(this);
    }

    private static final Object setupRenderTarget$lambda$1() {
        return "creating default render target for context " + Driver.Companion.getInstance().getContextID();
    }

    private static final Map cursorCache_delegate$lambda$4() {
        return new LinkedHashMap();
    }

    private static final void setupGlfwEvents$lambda$7(Set $modifiers, ApplicationWindowGLFW this$0, long l, int key, int scancode, int action, int n) {
        String string;
        switch (key) {
            case 32: {
                string = "space";
                break;
            }
            case 257: {
                string = "enter";
                break;
            }
            case 258: {
                string = "tab";
                break;
            }
            case 256: {
                string = "escape";
                break;
            }
            case 265: {
                string = "arrow-up";
                break;
            }
            case 264: {
                string = "arrow-down";
                break;
            }
            case 263: {
                string = "arrow-left";
                break;
            }
            case 262: {
                string = "arrow-right";
                break;
            }
            case 283: {
                string = "print-screen";
                break;
            }
            case 267: {
                string = "page-down";
                break;
            }
            case 266: {
                string = "page-up";
                break;
            }
            case 268: {
                string = "home";
                break;
            }
            case 269: {
                string = "end";
                break;
            }
            case 259: {
                string = "backspace";
                break;
            }
            case 342: {
                string = "left-alt";
                break;
            }
            case 346: {
                string = "right-alt";
                break;
            }
            case 341: {
                string = "left-control";
                break;
            }
            case 345: {
                string = "right-control";
                break;
            }
            case 260: {
                string = "insert";
                break;
            }
            case 261: {
                string = "delete";
                break;
            }
            case 340: {
                string = "left-shift";
                break;
            }
            case 344: {
                string = "right-shift";
                break;
            }
            case 343: {
                string = "left-super";
                break;
            }
            case 347: {
                string = "right-super";
                break;
            }
            case 290: {
                string = "f1";
                break;
            }
            case 291: {
                string = "f2";
                break;
            }
            case 292: {
                string = "f3";
                break;
            }
            case 293: {
                string = "f4";
                break;
            }
            case 294: {
                string = "f5";
                break;
            }
            case 295: {
                string = "f6";
                break;
            }
            case 296: {
                string = "f7";
                break;
            }
            case 297: {
                string = "f8";
                break;
            }
            case 298: {
                string = "f9";
                break;
            }
            case 299: {
                string = "f10";
                break;
            }
            case 300: {
                string = "f11";
                break;
            }
            case 301: {
                string = "f12";
                break;
            }
            case 280: {
                string = "caps-lock";
                break;
            }
            default: {
                string = GLFW.glfwGetKeyName(key, scancode);
                if (string != null) break;
                string = "<null>";
            }
        }
        String name = string;
        switch (action) {
            case 1: {
                switch (key) {
                    case 342: 
                    case 346: {
                        ((Collection)$modifiers).add(KeyModifier.ALT);
                    }
                }
                switch (key) {
                    case 341: 
                    case 345: {
                        ((Collection)$modifiers).add(KeyModifier.CTRL);
                    }
                }
                switch (key) {
                    case 340: 
                    case 344: {
                        ((Collection)$modifiers).add(KeyModifier.SHIFT);
                    }
                }
                switch (key) {
                    case 343: 
                    case 347: {
                        ((Collection)$modifiers).add(KeyModifier.SUPER);
                    }
                }
                this$0.getProgram().getKeyboard().getKeyDown().trigger(new KeyEvent(KeyEventType.KEY_DOWN, key, name, $modifiers));
                break;
            }
            case 0: {
                switch (key) {
                    case 342: 
                    case 346: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.ALT);
                    }
                }
                switch (key) {
                    case 341: 
                    case 345: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.CTRL);
                    }
                }
                switch (key) {
                    case 340: 
                    case 344: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.SHIFT);
                    }
                }
                switch (key) {
                    case 343: 
                    case 347: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.SUPER);
                    }
                }
                this$0.getProgram().getKeyboard().getKeyUp().trigger(new KeyEvent(KeyEventType.KEY_UP, key, name, $modifiers));
                break;
            }
            case 2: {
                this$0.getProgram().getKeyboard().getKeyRepeat().trigger(new KeyEvent(KeyEventType.KEY_REPEAT, key, name, $modifiers));
            }
        }
    }

    private static final void setupGlfwEvents$lambda$8(ApplicationWindowGLFW this$0, long l, int codepoint) {
        this$0.getProgram().getKeyboard().getCharacter().trigger(new CharacterEvent((char)codepoint, SetsKt.emptySet()));
    }

    private static final Object setupGlfwEvents$lambda$12$lambda$9(int $count) {
        return $count + " file(s) have been dropped";
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupGlfwEvents$lambda$12(ApplicationWindowGLFW this$0, long l, int count2, long names) {
        Collection<String> collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        ApplicationWindowGLFWKt.access$getLogger$p().debug(() -> ApplicationWindowGLFW.setupGlfwEvents$lambda$12$lambda$9(count2));
        PointerBuffer pointerBuffer = PointerBuffer.create(names, count2);
        Intrinsics.checkNotNullExpressionValue(pointerBuffer, "create(...)");
        PointerBuffer pointers = pointerBuffer;
        Iterable $this$map$iv = RangesKt.until(0, count2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new File(pointers.getStringUTF8((int)it)));
        }
        List files = (List)destination$iv$iv;
        $this$map$iv = files;
        Vector2 vector2 = this$0.getProgram().getMouse().getPosition();
        object = this$0.getProgram().getWindow().getDrop();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Vector2 vector22 = vector2;
        ((Event)object).trigger(new DropEvent(vector22, list));
    }

    private static final Object setupGlfwEvents$lambda$14$lambda$13(long $window, int $width, int $height) {
        return "resizing window (" + $window + ") to " + $width + "x" + $height + " ";
    }

    private static final void setupGlfwEvents$lambda$14(ApplicationWindowGLFW this$0, Ref.IntRef $readyFrames, long window2, int width, int height) {
        ApplicationWindowGLFWKt.access$getLogger$p().trace(() -> ApplicationWindowGLFW.setupGlfwEvents$lambda$14$lambda$13(window2, width, height));
        this$0._windowSize = null;
        if ($readyFrames.element > 0) {
            this$0.updateSize$openrndr_gl3();
            this$0.getProgram().getWindow().getSized().trigger(new WindowEvent(WindowEventType.RESIZED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        }
        int n = $readyFrames.element;
        $readyFrames.element = n + 1;
    }

    private static final Object setupGlfwEvents$lambda$16$lambda$15(ApplicationWindowGLFW this$0, int $x, int $y) {
        return "window (" + this$0.window + ") has moved to " + $x + " " + $y;
    }

    private static final void setupGlfwEvents$lambda$16(ApplicationWindowGLFW this$0, long l, int x, int y) {
        ApplicationWindowGLFWKt.access$getLogger$p().trace(() -> ApplicationWindowGLFW.setupGlfwEvents$lambda$16$lambda$15(this$0, x, y));
        this$0.getProgram().getWindow().getMoved().trigger(new WindowEvent(WindowEventType.MOVED, new Vector2(x, y), new Vector2(0.0, 0.0), true));
    }

    private static final void setupGlfwEvents$lambda$17(ApplicationWindowGLFW this$0, Set $modifiers, long l, double xoffset, double yoffset) {
        this$0.getProgram().getMouse().getScrolled().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), new Vector2(xoffset, yoffset), Vector2.Companion.getZERO(), MouseEventType.SCROLLED, MouseButton.NONE, $modifiers));
    }

    private static final void setupGlfwEvents$lambda$18(ApplicationWindowGLFW this$0, long l, boolean iconified) {
        if (iconified) {
            this$0.getProgram().getWindow().getMinimized().trigger(new WindowEvent(WindowEventType.MINIMIZED, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), false));
        } else {
            this$0.getProgram().getWindow().getRestored().trigger(new WindowEvent(WindowEventType.RESTORED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        }
    }

    private static final Object setupGlfwEvents$lambda$20$lambda$19(ApplicationWindowGLFW this$0, boolean $focused) {
        return "window (" + this$0.window + ") focus has changed; focused=" + $focused;
    }

    private static final void setupGlfwEvents$lambda$20(ApplicationWindowGLFW this$0, long l, boolean focused) {
        ApplicationWindowGLFWKt.access$getLogger$p().trace(() -> ApplicationWindowGLFW.setupGlfwEvents$lambda$20$lambda$19(this$0, focused));
        this$0.setWindowFocused(focused);
        if (focused) {
            this$0.getProgram().getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        } else {
            this$0.getProgram().getWindow().getUnfocused().trigger(new WindowEvent(WindowEventType.FOCUSED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), false));
        }
    }

    private static final Object setupGlfwEvents$lambda$22$lambda$21(ApplicationWindowGLFW this$0) {
        return "window " + this$0.window + " closed";
    }

    private static final void setupGlfwEvents$lambda$22(ApplicationWindowGLFW this$0, long it) {
        if (this$0.getWindowClosable()) {
            ApplicationWindowGLFWKt.access$getLogger$p().debug(() -> ApplicationWindowGLFW.setupGlfwEvents$lambda$22$lambda$21(this$0));
            this$0.getProgram().getWindow().getClosed().setPostpone(false);
            this$0.getProgram().getWindow().getClosed().trigger(new WindowEvent(WindowEventType.CLOSED, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), false));
            this$0.destroy();
        }
    }

    private static final void setupGlfwEvents$lambda$23(ApplicationWindowGLFW this$0, long l, boolean entered) {
        this$0.setCursorInWindow(entered);
        if (entered) {
            this$0.getProgram().getMouse().getEntered().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.ENTERED, MouseButton.NONE, SetsKt.emptySet()));
        } else {
            this$0.getProgram().getMouse().getExited().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.EXITED, MouseButton.NONE, SetsKt.emptySet()));
        }
    }

    private static final void setupGlfwEvents$lambda$24(Ref.BooleanRef $down, Ref.ObjectRef $lastDragPosition, ApplicationWindowGLFW this$0, Ref.ObjectRef $lastMouseButtonDown, Set $modifiers, long l, int button, int action, int n) {
        MouseButton mouseButton = switch (button) {
            case 0 -> MouseButton.LEFT;
            case 1 -> MouseButton.RIGHT;
            case 2 -> MouseButton.CENTER;
            default -> MouseButton.NONE;
        };
        BitSet buttonsDown = new BitSet();
        switch (action) {
            case 1: {
                $down.element = true;
                $lastDragPosition.element = this$0.getProgram().getMouse().getPosition();
                $lastMouseButtonDown.element = mouseButton;
                this$0.getProgram().getMouse().getButtonDown().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_DOWN, mouseButton, $modifiers));
                buttonsDown.set(button, true);
                break;
            }
            case 0: {
                $down.element = false;
                this$0.getProgram().getMouse().getButtonUp().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_UP, mouseButton, $modifiers));
                buttonsDown.set(button, false);
            }
        }
    }

    private static final Object setupGlfwEvents$lambda$26$lambda$25(double $xpos, double $ypos, Vector2 $position) {
        return "mouse moved " + $xpos + " " + $ypos + " -- " + $position;
    }

    private static final void setupGlfwEvents$lambda$26(ApplicationWindowGLFW this$0, Set $modifiers, Ref.BooleanRef $down, Ref.ObjectRef $lastDragPosition, Ref.ObjectRef $lastMouseButtonDown, long l, double xpos, double ypos) {
        Vector2 position = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? new Vector2(xpos, ypos).div(this$0.getProgram().getWindow().getContentScale()) : new Vector2(xpos, ypos);
        this$0.setCursorPosition(position);
        ApplicationWindowGLFWKt.access$getLogger$p().trace(() -> ApplicationWindowGLFW.setupGlfwEvents$lambda$26$lambda$25(xpos, ypos, position));
        this$0.getProgram().getMouse().getMoved().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.MOVED, MouseButton.NONE, $modifiers));
        if ($down.element) {
            this$0.getProgram().getMouse().getDragged().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), position.minus((Vector2)$lastDragPosition.element), MouseEventType.DRAGGED, (MouseButton)((Object)$lastMouseButtonDown.element), $modifiers));
            $lastDragPosition.element = position;
        }
    }

    private static final Object destroy$lambda$27(ApplicationWindowGLFW this$0) {
        return "destroying window " + this$0.window;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MouseCursorHideMode.values().length];
            try {
                nArray[MouseCursorHideMode.HIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseCursorHideMode.DISABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CursorType.values().length];
            try {
                nArray[CursorType.ARROW_CURSOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.IBEAM_CURSOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.HAND_CURSOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.CROSSHAIR_CURSOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.HRESIZE_CURSOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.VRESIZE_CURSOR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

