/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferAlignment;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;
import org.openrndr.internal.gl3.BufferWriterGL3Kt;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J!\u0010\u001d\u001a\u00020\u00162\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020#H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020%H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020&H\u0016J \u0010\u001d\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020+H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020,H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020-H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020.H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020/H\u0016J \u0010\u001d\u001a\u00020\u00162\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/H\u0016J(\u0010\u001d\u001a\u00020\u00162\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020/H\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u000204H\u0016J\b\u0010=\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u00106\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0010\"\u0004\b8\u00109R$\u0010:\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0010\"\u0004\b<\u00109\u00a8\u0006>"}, d2={"Lorg/openrndr/internal/gl3/BufferWriterGL3;", "Lorg/openrndr/draw/BufferWriter;", "buffer", "Ljava/nio/ByteBuffer;", "elementSize", "", "alignment", "Lorg/openrndr/draw/BufferAlignment;", "elementIterator", "", "Lorg/openrndr/draw/ShaderStorageElement;", "<init>", "(Ljava/nio/ByteBuffer;ILorg/openrndr/draw/BufferAlignment;Ljava/util/Iterator;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getElementSize", "()I", "getAlignment", "()Lorg/openrndr/draw/BufferAlignment;", "getElementIterator", "()Ljava/util/Iterator;", "next", "", "type", "Lorg/openrndr/draw/BufferPrimitiveType;", "copyBuffer", "sourceBuffer", "sourceOffset", "sourceSizeInBytes", "write", "v", "", "Lorg/openrndr/math/Vector3;", "([Lorg/openrndr/math/Vector3;)V", "", "", "Lorg/openrndr/math/IntVector2;", "Lorg/openrndr/math/IntVector3;", "Lorg/openrndr/math/IntVector4;", "a", "", "offset", "size", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector4;", "Lorg/openrndr/math/Matrix33;", "Lorg/openrndr/math/Matrix44;", "", "x", "y", "z", "w", "Lorg/openrndr/color/ColorRGBa;", "value", "position", "getPosition", "setPosition", "(I)V", "positionElements", "getPositionElements", "setPositionElements", "rewind", "openrndr-gl3"})
public final class BufferWriterGL3
extends BufferWriter {
    @NotNull
    private final ByteBuffer buffer;
    private final int elementSize;
    @NotNull
    private final BufferAlignment alignment;
    @Nullable
    private final Iterator<ShaderStorageElement> elementIterator;

    public BufferWriterGL3(@NotNull ByteBuffer buffer, int elementSize, @NotNull BufferAlignment alignment, @Nullable Iterator<? extends ShaderStorageElement> elementIterator) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter((Object)alignment, "alignment");
        this.buffer = buffer;
        this.elementSize = elementSize;
        this.alignment = alignment;
        this.elementIterator = elementIterator;
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public /* synthetic */ BufferWriterGL3(ByteBuffer byteBuffer, int n, BufferAlignment bufferAlignment, Iterator iterator2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(byteBuffer, n, bufferAlignment, iterator2);
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    @NotNull
    public final BufferAlignment getAlignment() {
        return this.alignment;
    }

    @Nullable
    public final Iterator<ShaderStorageElement> getElementIterator() {
        return this.elementIterator;
    }

    private final void next(BufferPrimitiveType type) {
        if (this.elementIterator != null) {
            ShaderStorageElement element = this.elementIterator.next();
            ShaderStorageElement shaderStorageElement = element;
            if (shaderStorageElement instanceof ShaderStoragePrimitive) {
                if (!(((ShaderStoragePrimitive)element).getType() == type)) {
                    boolean bl = false;
                    String string = "Type mismatch in ShaderStoragePrimitive: expected '" + ((ShaderStoragePrimitive)element).getType() + "', but received '" + type + "'.";
                    throw new IllegalArgumentException(string.toString());
                }
            } else if (shaderStorageElement instanceof ShaderStorageStruct) {
                int n;
                int n2 = this.buffer.position();
                int n3 = n2 % (n = ((ShaderStorageStruct)element).alignmentInBytes());
                if (n3 + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) != 0) {
                    n2 = this.buffer.position();
                    n = ((ShaderStorageStruct)element).alignmentInBytes();
                    n3 = n2 % n;
                    this.buffer.position(this.buffer.position() + ((ShaderStorageStruct)element).alignmentInBytes() - (n3 + (n & ((n3 ^ n) & (n3 | -n3)) >> 31)));
                }
                this.next(type);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void copyBuffer(@NotNull ByteBuffer sourceBuffer, int sourceOffset, int sourceSizeInBytes) {
        Intrinsics.checkNotNullParameter(sourceBuffer, "sourceBuffer");
        if (!sourceBuffer.isDirect()) {
            boolean bl = false;
            String string = "can only copy from direct buffers";
            throw new IllegalArgumentException(string.toString());
        }
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
        ((Buffer)sourceBuffer).position(sourceOffset);
        ((Buffer)sourceBuffer).limit(sourceOffset + sourceSizeInBytes);
        this.buffer.put(sourceBuffer);
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
    }

    @Override
    public void write(Vector3 ... v) {
        Intrinsics.checkNotNullParameter(v, "v");
        for (Vector3 i : v) {
            this.next(BufferPrimitiveType.VECTOR3_FLOAT32);
            this.write(i);
        }
    }

    @Override
    public void write(byte v) {
        if (!(this.alignment == BufferAlignment.NONE && this.elementIterator == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.buffer.put(v);
    }

    @Override
    public void write(short v) {
        if (!(this.alignment == BufferAlignment.NONE && this.elementIterator == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.buffer.putShort(v);
    }

    @Override
    public void write(int v) {
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 4);
        }
        this.next(BufferPrimitiveType.INT32);
        this.buffer.putInt(v);
    }

    @Override
    public void write(@NotNull IntVector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 8);
        }
        this.next(BufferPrimitiveType.VECTOR2_INT32);
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
    }

    @Override
    public void write(@NotNull IntVector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR3_INT32);
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.buffer.putInt(v.z());
    }

    @Override
    public void write(@NotNull IntVector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_INT32);
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.buffer.putInt(v.z());
        this.buffer.putInt(v.w());
    }

    @Override
    public void write(@NotNull float[] a, int offset, int size) {
        Intrinsics.checkNotNullParameter(a, "a");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 4);
        }
        this.buffer.asFloatBuffer().put(a, offset, size);
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(this.buffer.position() + size * 4);
    }

    @Override
    public void write(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR3_FLOAT32);
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.buffer.putFloat((float)v.z());
    }

    @Override
    public void write(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 8);
        }
        this.next(BufferPrimitiveType.VECTOR2_FLOAT32);
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
    }

    @Override
    public void write(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_FLOAT32);
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.buffer.putFloat((float)v.z());
        this.buffer.putFloat((float)v.w());
    }

    @Override
    public void write(@NotNull Matrix33 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.MATRIX33_FLOAT32);
        this.buffer.putFloat((float)v.c0r0());
        this.buffer.putFloat((float)v.c0r1());
        this.buffer.putFloat((float)v.c0r2());
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.buffer.putFloat((float)v.c1r0());
        this.buffer.putFloat((float)v.c1r1());
        this.buffer.putFloat((float)v.c1r2());
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.buffer.putFloat((float)v.c2r0());
        this.buffer.putFloat((float)v.c2r1());
        this.buffer.putFloat((float)v.c2r2());
    }

    @Override
    public void write(@NotNull Matrix44 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.MATRIX44_FLOAT32);
        this.buffer.putFloat((float)v.c0r0());
        this.buffer.putFloat((float)v.c0r1());
        this.buffer.putFloat((float)v.c0r2());
        this.buffer.putFloat((float)v.c0r3());
        this.buffer.putFloat((float)v.c1r0());
        this.buffer.putFloat((float)v.c1r1());
        this.buffer.putFloat((float)v.c1r2());
        this.buffer.putFloat((float)v.c1r3());
        this.buffer.putFloat((float)v.c2r0());
        this.buffer.putFloat((float)v.c2r1());
        this.buffer.putFloat((float)v.c2r2());
        this.buffer.putFloat((float)v.c2r3());
        this.buffer.putFloat((float)v.c3r0());
        this.buffer.putFloat((float)v.c3r1());
        this.buffer.putFloat((float)v.c3r2());
        this.buffer.putFloat((float)v.c3r3());
    }

    @Override
    public void write(float v) {
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 4);
        }
        this.next(BufferPrimitiveType.FLOAT32);
        this.buffer.putFloat(v);
    }

    @Override
    public void write(float x, float y, float z) {
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR3_FLOAT32);
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
    }

    @Override
    public void write(float x, float y, float z, float w) {
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_FLOAT32);
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.buffer.putFloat(w);
    }

    @Override
    public void write(float x, float y) {
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 8);
        }
        this.next(BufferPrimitiveType.VECTOR2_FLOAT32);
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
    }

    @Override
    public void write(@NotNull ColorRGBa v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.alignment == BufferAlignment.STD430) {
            BufferWriterGL3Kt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_FLOAT32);
        this.buffer.putFloat((float)v.getR());
        this.buffer.putFloat((float)v.getG());
        this.buffer.putFloat((float)v.getB());
        this.buffer.putFloat((float)v.getAlpha());
    }

    @Override
    public int getPosition() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position();
    }

    @Override
    public void setPosition(int value) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(value);
    }

    @Override
    public int getPositionElements() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position() / this.elementSize;
    }

    @Override
    public void setPositionElements(int value) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(value * this.elementSize);
    }

    @Override
    public void rewind() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).rewind();
    }
}

