/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.IndexType;
import org.openrndr.draw.StencilOperation;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexElementType;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\b\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u000fH\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0003*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0012H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0003*\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0018\u001a\u00020\u0004*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0015\u0010\u0006\u001a\u00020\u001c*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0015\u0010\u001f\u001a\u00020 *\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "require", "", "Lorg/openrndr/internal/gl3/DriverVersionGL;", "minimum", "glType", "", "Lorg/openrndr/draw/IndexType;", "glStencilTest", "test", "Lorg/openrndr/draw/StencilTest;", "glStencilOp", "op", "Lorg/openrndr/draw/StencilOperation;", "Lorg/openrndr/draw/DrawPrimitive;", "Lorg/openrndr/draw/VertexElementType;", "put", "Lorg/openrndr/math/Matrix44;", "fb", "Ljava/nio/FloatBuffer;", "toFloatArray", "", "Lorg/openrndr/math/Matrix33;", "glVersion", "Lorg/openrndr/internal/Driver$Companion;", "getGlVersion", "(Lorg/openrndr/internal/Driver$Companion;)Lorg/openrndr/internal/gl3/DriverVersionGL;", "Lorg/openrndr/internal/gl3/DriverTypeGL;", "getGlType", "(Lorg/openrndr/internal/Driver$Companion;)Lorg/openrndr/internal/gl3/DriverTypeGL;", "capabilities", "Lorg/openrndr/internal/gl3/DriverGL3$Capabilities;", "getCapabilities", "(Lorg/openrndr/internal/Driver$Companion;)Lorg/openrndr/internal/gl3/DriverGL3$Capabilities;", "openrndr-gl3"})
public final class DriverGL3Kt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(DriverGL3Kt::logger$lambda$0);

    public static final void require(@NotNull DriverVersionGL $this$require, @NotNull DriverVersionGL minimum) {
        Intrinsics.checkNotNullParameter((Object)$this$require, "<this>");
        Intrinsics.checkNotNullParameter((Object)minimum, "minimum");
        boolean $i$f$require = false;
        if (!($this$require.ordinal() >= minimum.ordinal())) {
            boolean bl = false;
            String string = "Feature is not supported on current OpenGL configuration (configuration: " + $this$require.getVersionString() + ", required: " + minimum.getVersionString() + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final int glType(IndexType $this$glType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$glType.ordinal()]) {
            case 1 -> 5123;
            case 2 -> 5125;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final int glStencilTest(@NotNull StencilTest test) {
        Intrinsics.checkNotNullParameter((Object)test, "test");
        return switch (WhenMappings.$EnumSwitchMapping$1[test.ordinal()]) {
            case 1 -> 512;
            case 2 -> 519;
            case 3 -> 513;
            case 4 -> 515;
            case 5 -> 516;
            case 6 -> 518;
            case 7 -> 514;
            case 8 -> 517;
            default -> throw new RuntimeException("unsupported test: " + test);
        };
    }

    public static final int glStencilOp(@NotNull StencilOperation op) {
        Intrinsics.checkNotNullParameter((Object)op, "op");
        return switch (WhenMappings.$EnumSwitchMapping$2[op.ordinal()]) {
            case 1 -> 7680;
            case 2 -> 7683;
            case 3 -> 34056;
            case 4 -> 7682;
            case 5 -> 34055;
            case 6 -> 0;
            case 7 -> 5386;
            case 8 -> 7681;
            default -> throw new RuntimeException("unsupported op");
        };
    }

    private static final int glType(DrawPrimitive $this$glType) {
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$glType.ordinal()]) {
            case 1 -> 4;
            case 2 -> 6;
            case 3 -> 0;
            case 4 -> 1;
            case 5 -> 3;
            case 6 -> 2;
            case 7 -> 5;
            case 8 -> 14;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final int glType(VertexElementType $this$glType) {
        return switch (WhenMappings.$EnumSwitchMapping$4[$this$glType.ordinal()]) {
            case 1, 2, 3, 4 -> 5121;
            case 5, 6, 7, 8 -> 5123;
            case 9, 10, 11, 12 -> 5125;
            case 13, 14, 15, 16 -> 5120;
            case 17, 18, 19, 20 -> 5122;
            case 21, 22, 23, 24 -> 5124;
            case 25 -> 5126;
            case 26 -> 5126;
            case 27 -> 5126;
            case 28 -> 5126;
            case 29 -> 5126;
            case 30 -> 5126;
            case 31 -> 5126;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final void put(@NotNull Matrix44 $this$put, @NotNull FloatBuffer fb) {
        Intrinsics.checkNotNullParameter($this$put, "<this>");
        Intrinsics.checkNotNullParameter(fb, "fb");
        fb.put((float)$this$put.c0r0());
        fb.put((float)$this$put.c0r1());
        fb.put((float)$this$put.c0r2());
        fb.put((float)$this$put.c0r3());
        fb.put((float)$this$put.c1r0());
        fb.put((float)$this$put.c1r1());
        fb.put((float)$this$put.c1r2());
        fb.put((float)$this$put.c1r3());
        fb.put((float)$this$put.c2r0());
        fb.put((float)$this$put.c2r1());
        fb.put((float)$this$put.c2r2());
        fb.put((float)$this$put.c2r3());
        fb.put((float)$this$put.c3r0());
        fb.put((float)$this$put.c3r1());
        fb.put((float)$this$put.c3r2());
        fb.put((float)$this$put.c3r3());
    }

    @NotNull
    public static final float[] toFloatArray(@NotNull Matrix44 $this$toFloatArray) {
        Intrinsics.checkNotNullParameter($this$toFloatArray, "<this>");
        float[] fArray = new float[]{(float)$this$toFloatArray.c0r0(), (float)$this$toFloatArray.c0r1(), (float)$this$toFloatArray.c0r2(), (float)$this$toFloatArray.c0r3(), (float)$this$toFloatArray.c1r0(), (float)$this$toFloatArray.c1r1(), (float)$this$toFloatArray.c1r2(), (float)$this$toFloatArray.c1r3(), (float)$this$toFloatArray.c2r0(), (float)$this$toFloatArray.c2r1(), (float)$this$toFloatArray.c2r2(), (float)$this$toFloatArray.c2r3(), (float)$this$toFloatArray.c3r0(), (float)$this$toFloatArray.c3r1(), (float)$this$toFloatArray.c3r2(), (float)$this$toFloatArray.c3r3()};
        return fArray;
    }

    public static final void put(@NotNull Matrix33 $this$put, @NotNull FloatBuffer fb) {
        Intrinsics.checkNotNullParameter($this$put, "<this>");
        Intrinsics.checkNotNullParameter(fb, "fb");
        fb.put((float)$this$put.c0r0());
        fb.put((float)$this$put.c0r1());
        fb.put((float)$this$put.c0r2());
        fb.put((float)$this$put.c1r0());
        fb.put((float)$this$put.c1r1());
        fb.put((float)$this$put.c1r2());
        fb.put((float)$this$put.c2r0());
        fb.put((float)$this$put.c2r1());
        fb.put((float)$this$put.c2r2());
    }

    @NotNull
    public static final float[] toFloatArray(@NotNull Matrix33 $this$toFloatArray) {
        Intrinsics.checkNotNullParameter($this$toFloatArray, "<this>");
        float[] fArray = new float[]{(float)$this$toFloatArray.c0r0(), (float)$this$toFloatArray.c0r1(), (float)$this$toFloatArray.c0r2(), (float)$this$toFloatArray.c1r0(), (float)$this$toFloatArray.c1r1(), (float)$this$toFloatArray.c1r2(), (float)$this$toFloatArray.c2r0(), (float)$this$toFloatArray.c2r1(), (float)$this$toFloatArray.c2r2()};
        return fArray;
    }

    @NotNull
    public static final DriverVersionGL getGlVersion(@NotNull Driver.Companion $this$glVersion) {
        Intrinsics.checkNotNullParameter($this$glVersion, "<this>");
        Driver driver = $this$glVersion.getInstance();
        Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
        return ((DriverGL3)driver).getVersion();
    }

    @NotNull
    public static final DriverTypeGL getGlType(@NotNull Driver.Companion $this$glType) {
        Intrinsics.checkNotNullParameter($this$glType, "<this>");
        Driver driver = $this$glType.getInstance();
        Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
        return ((DriverGL3)driver).getVersion().getType();
    }

    @NotNull
    public static final DriverGL3.Capabilities getCapabilities(@NotNull Driver.Companion $this$capabilities) {
        Intrinsics.checkNotNullParameter($this$capabilities, "<this>");
        Driver driver = $this$capabilities.getInstance();
        Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
        return ((DriverGL3)driver).getCapabilities();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ int access$glType(DrawPrimitive $receiver) {
        return DriverGL3Kt.glType($receiver);
    }

    public static final /* synthetic */ int access$glType(IndexType $receiver) {
        return DriverGL3Kt.glType($receiver);
    }

    public static final /* synthetic */ int access$glType(VertexElementType $receiver) {
        return DriverGL3Kt.glType($receiver);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[IndexType.values().length];
            try {
                nArray[IndexType.INT16.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndexType.INT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StencilTest.values().length];
            try {
                nArray[StencilTest.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.LESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.LESS_OR_EQUAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.GREATER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.GREATER_OR_EQUAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.EQUAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilTest.NOT_EQUAL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[StencilOperation.values().length];
            try {
                nArray[StencilOperation.KEEP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.DECREASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.DECREASE_WRAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.INCREASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.INCREASE_WRAP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.ZERO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.INVERT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StencilOperation.REPLACE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[DrawPrimitive.values().length];
            try {
                nArray[DrawPrimitive.TRIANGLES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.TRIANGLE_FAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.POINTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.LINES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.LINE_STRIP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.LINE_LOOP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.TRIANGLE_STRIP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DrawPrimitive.PATCHES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[VertexElementType.values().length];
            try {
                nArray[VertexElementType.UINT8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT8.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT8.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT16.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT16.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT16.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT16.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT32.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT32.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT32.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT8.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT8.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT8.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT8.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT16.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT16.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT16.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT16.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT32.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT32.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT32.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT32.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.FLOAT32.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX22_FLOAT32.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX33_FLOAT32.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX44_FLOAT32.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_FLOAT32.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_FLOAT32.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_FLOAT32.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

