/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.MSG;
import org.lwjgl.system.windows.User32;
import org.lwjgl.system.windows.WNDCLASSEX;
import org.openrndr.Pointer;
import org.openrndr.internal.gl3.ApplicationGLFWGL3;
import org.openrndr.internal.gl3.PointerInputManager;
import org.openrndr.internal.gl3.PointerInputManagerKt;
import org.openrndr.internal.gl3.PointerLParam;
import org.openrndr.internal.gl3.PointerWParam;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\"\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lorg/openrndr/internal/gl3/PointerInputManagerWin32;", "Lorg/openrndr/internal/gl3/PointerInputManager;", "window", "", "application", "Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "<init>", "(JLorg/openrndr/internal/gl3/ApplicationGLFWGL3;)V", "getWindow", "()J", "getApplication", "()Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "hwnd", "getHwnd", "msg", "Lorg/lwjgl/system/windows/MSG;", "getMsg", "()Lorg/lwjgl/system/windows/MSG;", "setMsg", "(Lorg/lwjgl/system/windows/MSG;)V", "touchHwnd", "getTouchHwnd", "setTouchHwnd", "(J)V", "createOverlayWindow", "", "nidReady", "", "pointers", "", "", "Lorg/openrndr/Pointer;", "getPointers", "()Ljava/util/Map;", "pollEvents", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nPointerInputManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointerInputManager.kt\norg/openrndr/internal/gl3/PointerInputManagerWin32\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class PointerInputManagerWin32
extends PointerInputManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long window;
    @NotNull
    private final ApplicationGLFWGL3 application;
    private final long hwnd;
    @NotNull
    private MSG msg;
    private long touchHwnd;
    private final boolean nidReady;
    @NotNull
    private final Map<Integer, Pointer> pointers;
    public static final int POINTER_FLAG_NONE = 0;
    public static final int POINTER_FLAG_NEW = 1;
    public static final int POINTER_FLAG_INRANGE = 2;
    public static final int POINTER_FLAG_INCONTACT = 4;
    public static final int POINTER_FLAG_FIRSTBUTTON = 16;
    public static final int POINTER_FLAG_SECONDBUTTON = 32;
    public static final int POINTER_FLAG_THIRDBUTTON = 64;
    public static final int POINTER_FLAG_FOURTHBUTTON = 128;
    public static final int POINTER_FLAG_FIFTHBUTTON = 256;
    public static final int POINTER_FLAG_PRIMARY = 8192;
    public static final int POINTER_FLAG_CONFIDENCE = 16384;
    public static final int POINTER_FLAG_CANCELED = 32768;
    public static final int POINTER_FLAG_DOWN = 65536;
    public static final int POINTER_FLAG_UPDATE = 131072;
    public static final int POINTER_FLAG_UP = 262144;
    public static final int POINTER_FLAG_WHEEL = 524288;
    public static final int POINTER_FLAG_HWHEEL = 0x100000;
    public static final int POINTER_FLAG_CAPTURECHANGED = 0x200000;
    public static final int POINTER_FLAG_HASTRANSFORM = 0x400000;
    public static final int WM_POINTERUPDATE = 581;
    public static final int WM_POINTERDOWN = 582;
    public static final int WM_POINTERUP = 583;
    public static final int WM_POINTERENTER = 585;
    public static final int WM_POINTERLEAVE = 586;
    public static final int WM_POINTERACTIVATE = 587;
    public static final int WM_POINTERCAPTURECHANGED = 588;
    public static final int WM_TOUCHHITTESTING = 589;
    public static final int WM_POINTERWHEEL = 590;
    public static final int WM_POINTERHWHEEL = 591;
    public static final int NID_MULTI_INPUT = 64;
    public static final int NID_READY = 128;

    public PointerInputManagerWin32(long window2, @NotNull ApplicationGLFWGL3 application) {
        Intrinsics.checkNotNullParameter(application, "application");
        this.window = window2;
        this.application = application;
        this.hwnd = GLFWNativeWin32.glfwGetWin32Window(this.window);
        MSG mSG = MSG.calloc();
        Intrinsics.checkNotNullExpressionValue(mSG, "calloc(...)");
        this.msg = mSG;
        int value = User32.GetSystemMetrics(94);
        this.nidReady = (value & 0x80) != 0;
        this.createOverlayWindow();
        this.pointers = new LinkedHashMap();
    }

    public final long getWindow() {
        return this.window;
    }

    @NotNull
    public final ApplicationGLFWGL3 getApplication() {
        return this.application;
    }

    public final long getHwnd() {
        return this.hwnd;
    }

    @NotNull
    public final MSG getMsg() {
        return this.msg;
    }

    public final void setMsg(@NotNull MSG mSG) {
        Intrinsics.checkNotNullParameter(mSG, "<set-?>");
        this.msg = mSG;
    }

    public final long getTouchHwnd() {
        return this.touchHwnd;
    }

    public final void setTouchHwnd(long l) {
        this.touchHwnd = l;
    }

    public final void createOverlayWindow() {
        WNDCLASSEX wNDCLASSEX = WNDCLASSEX.calloc();
        Intrinsics.checkNotNullExpressionValue(wNDCLASSEX, "calloc(...)");
        WNDCLASSEX windowClass = wNDCLASSEX;
        windowClass.cbSize(WNDCLASSEX.SIZEOF);
        windowClass.lpfnWndProc((arg_0, arg_1, arg_2, arg_3) -> PointerInputManagerWin32.createOverlayWindow$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
        windowClass.hbrBackground(0L);
        windowClass.lpszClassName(MemoryUtil.memUTF16("touchs", true));
        windowClass.hIcon(0L);
        short res = User32.RegisterClassEx(null, windowClass);
        if (!(res != 0)) {
            boolean $i$a$-require-PointerInputManagerWin32$createOverlayWindow$32 = false;
            String $i$a$-require-PointerInputManagerWin32$createOverlayWindow$32 = "RegisterClassEx failed";
            throw new IllegalArgumentException($i$a$-require-PointerInputManagerWin32$createOverlayWindow$32.toString());
        }
        PointerInputManagerKt.access$getLogger$p().info(() -> PointerInputManagerWin32.createOverlayWindow$lambda$2(this));
        this.touchHwnd = User32.CreateWindowEx(null, 0, "touchs", "touch", 0x40000000, 0, 0, 0, 0, this.hwnd, 0L, 0L, 0L);
        if (!(this.touchHwnd != 0L)) {
            boolean bl = false;
            String string = "CreateWindowEx failed";
            throw new IllegalArgumentException(string.toString());
        }
        long windowStyle = User32.GetWindowLongPtr(null, this.hwnd, -16);
        User32.SetWindowLongPtr(null, this.hwnd, -16, windowStyle ^ 0x2000000L);
        PointerInputManagerKt.access$getLogger$p().info(() -> PointerInputManagerWin32.createOverlayWindow$lambda$4(this));
        User32.RegisterTouchWindow(null, this.touchHwnd, 0);
        User32.ShowWindow(this.touchHwnd, 5);
        if (!User32.MoveWindow(null, this.touchHwnd, 0, 0, 8192, 8192, false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Map<Integer, Pointer> getPointers() {
        return this.pointers;
    }

    @Override
    public void pollEvents() {
        if (!this.nidReady) {
            return;
        }
        boolean changed = false;
        double contentScale = this.application.getWindowContentScale();
        Vector2 windowPosition = this.application.getWindowPosition();
        long ts = System.currentTimeMillis();
        while (User32.PeekMessage(this.msg, this.touchHwnd, 581, 591, 1)) {
            long w = PointerWParam.constructor-impl(this.msg.wParam());
            long l = PointerLParam.constructor-impl(this.msg.lParam());
            Vector2 position = new Vector2((double)PointerLParam.getX-impl(l) / contentScale - windowPosition.x(), (double)PointerLParam.getY-impl(l) / contentScale - windowPosition.y());
            switch (this.msg.message()) {
                case 582: {
                    break;
                }
                case 585: {
                    this.pointers.put(PointerWParam.getId-impl(w), new Pointer(position, PointerWParam.getPrimary-impl(w), ts));
                    changed = true;
                    break;
                }
                case 583: {
                    break;
                }
                case 581: {
                    this.pointers.put(PointerWParam.getId-impl(w), new Pointer(position, PointerWParam.getPrimary-impl(w), ts));
                    changed = true;
                    break;
                }
                case 586: {
                    this.pointers.remove(PointerWParam.getId-impl(w));
                    changed = true;
                    User32.GetMessageExtraInfo();
                }
            }
            User32.TranslateMessage(this.msg);
            User32.DispatchMessage(this.msg);
        }
        Object object = this.pointers.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<Integer, Pointer> pointer = object.next();
            if (ts - pointer.getValue().timestamp() <= 500L) continue;
            this.pointers.remove(pointer.getKey());
            changed = true;
            break;
        }
        if (changed) {
            List<Pointer> list = this.application.getPointers();
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.openrndr.Pointer>");
            Object $this$pollEvents_u24lambda_u245 = object = TypeIntrinsics.asMutableList(list);
            boolean bl = false;
            $this$pollEvents_u24lambda_u245.clear();
            $this$pollEvents_u24lambda_u245.addAll(this.pointers.values());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final long createOverlayWindow$lambda$0(PointerInputManagerWin32 this$0, long hwnd, int uMsg, long wParam, long lParam) {
        block4: {
            block3: {
                int n = uMsg;
                if (512 <= n ? n < 523 : false) break block3;
                boolean bl = 256 <= n ? n < 266 : false;
                if (!bl) break block4;
            }
            User32.SendMessage(null, this$0.hwnd, uMsg, wParam, lParam);
            return 0L;
        }
        long l = User32.DefWindowProc(hwnd, uMsg, wParam, lParam);
        return l;
    }

    private static final Object createOverlayWindow$lambda$2(PointerInputManagerWin32 this$0) {
        return "parent window " + this$0.hwnd;
    }

    private static final Object createOverlayWindow$lambda$4(PointerInputManagerWin32 this$0) {
        return "created touch window window " + this$0.touchHwnd;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b!\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/openrndr/internal/gl3/PointerInputManagerWin32$Companion;", "", "<init>", "()V", "HIWORD", "", "x", "", "LOWORD", "POINTER_FLAG_NONE", "POINTER_FLAG_NEW", "POINTER_FLAG_INRANGE", "POINTER_FLAG_INCONTACT", "POINTER_FLAG_FIRSTBUTTON", "POINTER_FLAG_SECONDBUTTON", "POINTER_FLAG_THIRDBUTTON", "POINTER_FLAG_FOURTHBUTTON", "POINTER_FLAG_FIFTHBUTTON", "POINTER_FLAG_PRIMARY", "POINTER_FLAG_CONFIDENCE", "POINTER_FLAG_CANCELED", "POINTER_FLAG_DOWN", "POINTER_FLAG_UPDATE", "POINTER_FLAG_UP", "POINTER_FLAG_WHEEL", "POINTER_FLAG_HWHEEL", "POINTER_FLAG_CAPTURECHANGED", "POINTER_FLAG_HASTRANSFORM", "WM_POINTERUPDATE", "WM_POINTERDOWN", "WM_POINTERUP", "WM_POINTERENTER", "WM_POINTERLEAVE", "WM_POINTERACTIVATE", "WM_POINTERCAPTURECHANGED", "WM_TOUCHHITTESTING", "WM_POINTERWHEEL", "WM_POINTERHWHEEL", "NID_MULTI_INPUT", "NID_READY", "openrndr-gl3"})
    public static final class Companion {
        private Companion() {
        }

        public final int HIWORD(long x) {
            return (int)(x >> 16 & 0xFFFFL);
        }

        public final int LOWORD(long x) {
            return (int)(x & 0xFFFFL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

