/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.ShaderGL3Kt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;", "", "shaderObject", "", "name", "", "<init>", "(ILjava/lang/String;)V", "getShaderObject", "()I", "getName", "()Ljava/lang/String;", "Companion", "openrndr-gl3"})
public final class TessellationControlShaderGL3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int shaderObject;
    @NotNull
    private final String name;

    public TessellationControlShaderGL3(int shaderObject, @NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.shaderObject = shaderObject;
        this.name = name;
    }

    public final int getShaderObject() {
        return this.shaderObject;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/openrndr/internal/gl3/TessellationControlShaderGL3$Companion;", "", "<init>", "()V", "fromString", "Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;", "code", "", "name", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nGeometryShaderGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometryShaderGL3.kt\norg/openrndr/internal/gl3/TessellationControlShaderGL3$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,67:1\n221#2,3:68\n231#2,3:71\n240#2,3:74\n*S KotlinDebug\n*F\n+ 1 GeometryShaderGL3.kt\norg/openrndr/internal/gl3/TessellationControlShaderGL3$Companion\n*L\n34#1:68,3\n35#1:71,3\n36#1:74,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TessellationControlShaderGL3 fromString(@NotNull String code, @NotNull String name) {
            Intrinsics.checkNotNullParameter(code, "code");
            Intrinsics.checkNotNullParameter(name, "name");
            if (!(DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GL)) {
                boolean $i$a$-require-TessellationControlShaderGL3$Companion$fromString$22 = false;
                String $i$a$-require-TessellationControlShaderGL3$Companion$fromString$22 = "Tessellation control shaders are not supported by " + DriverGL3Kt.getGlType(Driver.Companion);
                throw new IllegalArgumentException($i$a$-require-TessellationControlShaderGL3$Companion$fromString$22.toString());
            }
            int type$iv = 36488;
            boolean $i$f$glCreateShader = false;
            int shaderObject = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glCreateShader(type$iv);
                case 2 -> GLES32.glCreateShader(type$iv);
                default -> throw new NoWhenBranchMatchedException();
            };
            boolean $i$f$glShaderSource = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glShaderSource(shaderObject, (CharSequence)code);
                    break;
                }
                case 2: {
                    GLES32.glShaderSource(shaderObject, (CharSequence)code);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean $i$f$glCompileShader = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glCompileShader(shaderObject);
                    break;
                }
                case 2: {
                    GLES32.glCompileShader(shaderObject);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int[] compileStatus = new int[1];
            GLGLESKt.glGetShaderiv(shaderObject, 35713, compileStatus);
            if (compileStatus[0] != 1) {
                ShaderGL3Kt.checkShaderInfoLog(shaderObject, code, name);
                throw new Exception("could not compile tessellation control shader");
            }
            return new TessellationControlShaderGL3(shaderObject, name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

