/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Curve2;
import org.openrndr.kartifex.Interval;
import org.openrndr.kartifex.Line2;
import org.openrndr.kartifex.Matrix3;
import org.openrndr.kartifex.OperatorsKt;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.utils.EquationsKt;
import org.openrndr.kartifex.utils.ScalarsKt;
import utils.DoubleAccumulator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u001e\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J&\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002JI\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0015\u001a\u0002H\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007\u00a8\u0006 "}, d2={"Lorg/openrndr/kartifex/Bezier2;", "", "<init>", "()V", "curve", "Lorg/openrndr/kartifex/Line2;", "p0", "Lorg/openrndr/kartifex/Vec2;", "p1", "Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;", "p2", "Lorg/openrndr/kartifex/Curve2;", "p3", "sign", "", "n", "subdivide", "", "V", "result", "", "c", "error", "Lkotlin/Function1;", "maxError", "(Ljava/util/List;Lorg/openrndr/kartifex/Curve2;Lkotlin/jvm/functions/Function1;D)V", "signedDistance", "p", "a", "b", "QuadraticBezier2", "CubicBezier2", "openrndr-kartifex"})
public final class Bezier2 {
    @NotNull
    public static final Bezier2 INSTANCE = new Bezier2();

    private Bezier2() {
    }

    @NotNull
    public final Line2 curve(@NotNull Vec2 p0, @NotNull Vec2 p1) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        return Line2.Companion.line(p0, p1);
    }

    @NotNull
    public final QuadraticBezier2 curve(@NotNull Vec2 p0, @NotNull Vec2 p1, @NotNull Vec2 p2) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        return new QuadraticBezier2(p0, p1, p2);
    }

    @NotNull
    public final Curve2 curve(@NotNull Vec2 p0, @NotNull Vec2 p1, @NotNull Vec2 p2, @NotNull Vec2 p3) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        return new CubicBezier2(p0, p1, p2, p3);
    }

    private final double sign(double n) {
        double s = OperatorsKt.signum(n);
        return s == 0.0 ? -1.0 : s;
    }

    private final <V extends Curve2> void subdivide(List<Vec2> result, V c2, Function1<? super V, Double> error, double maxError) {
        if (((Number)error.invoke(c2)).doubleValue() <= maxError) {
            result.add(c2.start());
        } else {
            Curve2[] split2 = c2.split(0.5);
            Curve2 curve2 = split2[0];
            Intrinsics.checkNotNull(curve2, "null cannot be cast to non-null type V of org.openrndr.kartifex.Bezier2.subdivide");
            this.subdivide(result, curve2, error, maxError);
            Curve2 curve22 = split2[1];
            Intrinsics.checkNotNull(curve22, "null cannot be cast to non-null type V of org.openrndr.kartifex.Bezier2.subdivide");
            this.subdivide(result, curve22, error, maxError);
        }
    }

    public final double signedDistance(@NotNull Vec2 p, @NotNull Vec2 a, @NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Vec2 d = b.sub(a);
        return (Vec2.Companion.cross(p, d) + Vec2.Companion.cross(b, a)) / d.length();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB1\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\"\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0000H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020/H\u0002J\u0019\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001f2\u0006\u0010\"\u001a\u00020\u0015\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u000202H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/openrndr/kartifex/Bezier2$CubicBezier2;", "Lorg/openrndr/kartifex/Curve2;", "p0", "Lorg/openrndr/kartifex/Vec2;", "p1", "p2", "p3", "<init>", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;)V", "noInflections", "", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Z)V", "getP0", "()Lorg/openrndr/kartifex/Vec2;", "getP1", "getP2", "getP3", "bounds", "Lorg/openrndr/kartifex/Box2;", "position", "t", "", "direction", "signedArea", "length", "isFlat", "epsilon", "endpoints", "start", "end", "split", "", "(D)[Lorg/openrndr/kartifex/Curve2;", "subdivide", "error", "(D)[Lorg/openrndr/kartifex/Vec2;", "nearestPoint", "p", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "reverse", "inflections", "", "t0", "t1", "approximate", "Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;", "(D)[Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;", "toString", "", "Companion", "openrndr-kartifex"})
    @SourceDebugExtension(value={"SMAP\nBezier2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier2.kt\norg/openrndr/kartifex/Bezier2$CubicBezier2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,526:1\n1#2:527\n37#3:528\n36#3,3:529\n37#3:532\n36#3,3:533\n*S KotlinDebug\n*F\n+ 1 Bezier2.kt\norg/openrndr/kartifex/Bezier2$CubicBezier2\n*L\n377#1:528\n377#1:529,3\n507#1:532\n507#1:533,3\n*E\n"})
    public static final class CubicBezier2
    implements Curve2 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Vec2 p0;
        @NotNull
        private final Vec2 p1;
        @NotNull
        private final Vec2 p2;
        @NotNull
        private final Vec2 p3;
        private boolean noInflections;
        @Nullable
        private final Box2 bounds;
        private static final int SEARCH_STARTS = 4;
        private static final int SEARCH_STEPS = 8;

        public CubicBezier2(@NotNull Vec2 p0, @NotNull Vec2 p1, @NotNull Vec2 p2, @NotNull Vec2 p3) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            Intrinsics.checkNotNullParameter(p1, "p1");
            Intrinsics.checkNotNullParameter(p2, "p2");
            Intrinsics.checkNotNullParameter(p3, "p3");
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        @NotNull
        public final Vec2 getP0() {
            return this.p0;
        }

        @NotNull
        public final Vec2 getP1() {
            return this.p1;
        }

        @NotNull
        public final Vec2 getP2() {
            return this.p2;
        }

        @NotNull
        public final Vec2 getP3() {
            return this.p3;
        }

        private CubicBezier2(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3, boolean noInflections) {
            this(p0, p1, p2, p3);
            this.noInflections = noInflections;
        }

        @Override
        @NotNull
        public Vec2 position(double t) {
            if (t == 0.0) {
                return this.start();
            }
            if (t == 1.0) {
                return this.end();
            }
            double mt = 1.0 - t;
            double mt2 = mt * mt;
            double t2 = t * t;
            return this.p0.mul(mt2 * mt).add(this.p1.mul((double)3 * mt2 * t)).add(this.p2.mul((double)3 * mt * t2)).add(this.p3.mul(t2 * t));
        }

        @Override
        @NotNull
        public Vec2 direction(double t) {
            double mt = 1.0 - t;
            return this.p1.sub(this.p0).mul((double)3 * mt * mt).add(this.p2.sub(this.p1).mul((double)6 * mt * t)).add(this.p3.sub(this.p2).mul((double)3 * t * t));
        }

        @Override
        public double signedArea() {
            return (this.p3.x() * (-this.p0.y() - (double)3 * this.p1.y() - (double)6 * this.p2.y()) - (double)3 * this.p2.x() * (this.p0.y() + this.p1.y() - (double)2 * this.p3.y()) + (double)3 * this.p1.x() * ((double)-2 * this.p0.y() + this.p2.y() + this.p3.y()) + this.p0.x() * ((double)6 * this.p1.y() + (double)3 * this.p2.y() + this.p3.y())) / (double)20;
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public boolean isFlat(double epsilon) {
            double d2;
            double d1 = INSTANCE.signedDistance(this.p1, this.p0, this.p3);
            double k = d1 * (d2 = INSTANCE.signedDistance(this.p2, this.p0, this.p3)) < 0.0 ? 0.4444444444444444 : 0.75;
            return Math.abs(d1 * k) < epsilon && Math.abs(d2 * k) < epsilon;
        }

        @Override
        @NotNull
        public CubicBezier2 endpoints(@NotNull Vec2 start, @NotNull Vec2 end) {
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(end, "end");
            return new CubicBezier2(start, this.p1.add(start.sub(this.p0)), this.p2.add(end.sub(this.p3)), end, this.noInflections);
        }

        @Override
        @NotNull
        public Vec2 start() {
            return this.p0;
        }

        @Override
        @NotNull
        public Vec2 end() {
            return this.p3;
        }

        @Override
        @NotNull
        public Curve2[] split(double t) {
            if (!(!(t <= 0.0) && !(t >= 1.0))) {
                boolean $i$a$-require-Bezier2$CubicBezier2$split$22 = false;
                String $i$a$-require-Bezier2$CubicBezier2$split$22 = "t must be within (0,1)";
                throw new IllegalArgumentException($i$a$-require-Bezier2$CubicBezier2$split$22.toString());
            }
            Vec2 e = Vec.Companion.lerp(this.p0, this.p1, t);
            Vec2 f = Vec.Companion.lerp(this.p1, this.p2, t);
            Vec2 g = Vec.Companion.lerp(this.p2, this.p3, t);
            Vec2 h = Vec.Companion.lerp(e, f, t);
            Vec2 j = Vec.Companion.lerp(f, g, t);
            Vec2 k = this.position(t);
            Curve2[] curve2Array = new Curve2[]{new CubicBezier2(this.p0, e, h, k, this.noInflections), new CubicBezier2(k, j, g, this.p3, this.noInflections)};
            return curve2Array;
        }

        @Override
        @NotNull
        public Vec2[] subdivide(double error) {
            List points2 = new ArrayList();
            INSTANCE.subdivide(points2, this, CubicBezier2::subdivide$lambda$1, error * error);
            points2.add(this.end());
            Collection $this$toTypedArray$iv = points2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Vec2[0]);
        }

        @Override
        public double nearestPoint(@NotNull Vec2 p) {
            Intrinsics.checkNotNullParameter(p, "p");
            Vec2 qa = this.p0.sub(p);
            Vec2 ab = this.p1.sub(this.p0);
            Vec2 bc = this.p2.sub(this.p1);
            Vec2 cd = this.p3.sub(this.p2);
            Vec2 qd = this.p3.sub(p);
            Vec2 br = bc.sub(ab);
            Vec2 as = cd.sub(bc).sub(br);
            double minDistance = INSTANCE.sign(Vec2.Companion.cross(ab, qa)) * qa.length();
            double param = -Vec.Companion.dot(qa, ab) / Vec.Companion.dot(ab, ab);
            double distance = INSTANCE.sign(Vec2.Companion.cross(cd, qd)) * qd.length();
            if (Math.abs(distance) < Math.abs(minDistance)) {
                minDistance = distance;
                param = Math.max(1.0, Vec.Companion.dot(p.sub(this.p2), cd) / Vec.Companion.dot(cd, cd));
            }
            block0: for (int i = 0; i < 4; ++i) {
                double t = (double)i / (double)3;
                int step = 0;
                while (true) {
                    Vec2 qpt = this.position(t).sub(p);
                    distance = INSTANCE.sign(Vec2.Companion.cross(this.direction(t), qpt)) * qpt.length();
                    if (Math.abs(distance) < Math.abs(minDistance)) {
                        minDistance = distance;
                        param = t;
                    }
                    if (step == 8) continue block0;
                    Vec2 d1 = as.mul((double)3 * t * t).add(br.mul((double)6 * t)).add(ab.mul(3.0));
                    Vec2 d2 = as.mul((double)6 * t).add(br.mul(6.0));
                    double dt = Vec.Companion.dot(qpt, d1) / (Vec.Companion.dot(d1, d1) + Vec.Companion.dot(qpt, d2));
                    if (Math.abs(dt) < 1.0E-14 || (t -= dt) < 0.0 || t > 1.0) continue block0;
                    ++step;
                }
            }
            return param;
        }

        @Override
        @NotNull
        public Curve2 transform(@NotNull Matrix3 m) {
            Intrinsics.checkNotNullParameter(m, "m");
            return new CubicBezier2(this.p0.transform(m), this.p1.transform(m), this.p2.transform(m), this.p3.transform(m));
        }

        @Override
        @NotNull
        public CubicBezier2 reverse() {
            return new CubicBezier2(this.p3, this.p2, this.p1, this.p0, this.noInflections);
        }

        @Override
        @NotNull
        public Box2 bounds() {
            return this.noInflections ? Box.Companion.box(this.p0, this.p3) : Curve2.DefaultImpls.bounds(this);
        }

        @Override
        @NotNull
        public double[] inflections() {
            if (this.noInflections) {
                return new double[0];
            }
            double epsilon = 1.0E-7;
            Vec2 a0 = this.p1.sub(this.p0);
            Vec2 a1 = this.p2.sub(this.p1).sub(a0).mul(2.0);
            Vec2 a2 = this.p3.sub(this.p2.mul(3.0)).add(this.p1.mul(3.0)).sub(this.p0);
            double[] s1 = EquationsKt.solveQuadratic(a2.x(), a1.x(), a0.x());
            double[] s2 = EquationsKt.solveQuadratic(a2.y(), a1.y(), a0.y());
            DoubleAccumulator acc = new DoubleAccumulator();
            for (double n : s1) {
                if (!ScalarsKt.inside(epsilon, n, 1.0 - epsilon)) continue;
                acc.add(n);
            }
            for (double n : s2) {
                if (!ScalarsKt.inside(epsilon, n, 1.0 - epsilon)) continue;
                acc.add(n);
            }
            this.noInflections = acc.size() == 0;
            return acc.toArray();
        }

        private final double error() {
            return this.p3.sub(this.p2.mul(3.0)).add(this.p2.mul(3.0)).sub(this.p0).lengthSquared() / (double)4;
        }

        private final CubicBezier2 subdivide(double t0, double t1) {
            Vec2 p0 = this.position(t0);
            Vec2 p3 = this.position(t1);
            Vec2 p1 = p0.add(this.direction(t0));
            Vec2 p2 = p3.sub(this.direction(t1));
            return new CubicBezier2(p0, p1, p2, p3);
        }

        private final QuadraticBezier2 approximate() {
            return new QuadraticBezier2(this.p0, this.p1.mul(0.75).add(this.p2.mul(0.75)).sub(this.p0.mul(-0.25)).sub(this.p3.mul(-0.25)), this.p3);
        }

        @NotNull
        public final QuadraticBezier2[] approximate(double error) {
            ArrayDeque<Vec2> arrayDeque;
            double threshold = error * error;
            ArrayDeque<QuadraticBezier2> result = new ArrayDeque<QuadraticBezier2>();
            ArrayDeque<Vec2> $this$approximate_u24lambda_u242 = arrayDeque = new ArrayDeque<Vec2>();
            boolean bl = false;
            $this$approximate_u24lambda_u242.addLast(new Vec2(0.0, 1.0));
            ArrayDeque<Vec2> intervals = arrayDeque;
            while (intervals.size() > 0) {
                ArrayDeque<Vec2> arrayDeque2;
                Vec2 i = (Vec2)intervals.removeLast();
                CubicBezier2 c2 = this.subdivide(i.x(), i.y());
                if (c2.error() <= threshold) {
                    result.addLast(c2.approximate());
                    continue;
                }
                double midpoint = (i.x() + i.y()) / (double)2;
                ArrayDeque<Vec2> $this$approximate_u24lambda_u243 = arrayDeque2 = intervals;
                boolean bl2 = false;
                $this$approximate_u24lambda_u243.addLast(new Vec2(i.x(), midpoint));
                $this$approximate_u24lambda_u243.addLast(new Vec2(midpoint, i.y()));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new QuadraticBezier2[0]);
        }

        @NotNull
        public String toString() {
            return "CubicBezier2(p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + ", p3=" + this.p3 + ")";
        }

        @Override
        @NotNull
        public Curve2[] split(@NotNull double[] unsafeTs) {
            return Curve2.DefaultImpls.split(this, unsafeTs);
        }

        @Override
        @NotNull
        public Curve2 range(@NotNull Interval interval) {
            return Curve2.DefaultImpls.range(this, interval);
        }

        @Override
        @NotNull
        public Curve2 range(double tMin, double tMax) {
            return Curve2.DefaultImpls.range(this, tMin, tMax);
        }

        @Override
        @NotNull
        public Vec2[] intersections(@NotNull Curve2 c2) {
            return Curve2.DefaultImpls.intersections(this, c2);
        }

        private static final double subdivide$lambda$1(CubicBezier2 b) {
            Intrinsics.checkNotNullParameter(b, "b");
            return Math.max(Vec.Companion.lerp(b.p0, b.p3, 0.3333333333333333).sub(b.p1).lengthSquared(), Vec.Companion.lerp(b.p0, b.p3, 0.6666666666666666).sub(b.p2).lengthSquared());
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/kartifex/Bezier2$CubicBezier2$Companion;", "", "<init>", "()V", "SEARCH_STARTS", "", "SEARCH_STEPS", "openrndr-kartifex"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0000H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;", "Lorg/openrndr/kartifex/Curve2;", "p0", "Lorg/openrndr/kartifex/Vec2;", "p1", "p2", "<init>", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;)V", "noInflections", "", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Z)V", "getP0", "()Lorg/openrndr/kartifex/Vec2;", "getP1", "getP2", "start", "end", "isFlat", "epsilon", "", "length", "signedArea", "position", "t", "direction", "endpoints", "split", "", "(D)[Lorg/openrndr/kartifex/Curve2;", "subdivide", "error", "(D)[Lorg/openrndr/kartifex/Vec2;", "nearestPoint", "p", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "reverse", "bounds", "Lorg/openrndr/kartifex/Box2;", "inflections", "", "toString", "", "openrndr-kartifex"})
    @SourceDebugExtension(value={"SMAP\nBezier2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier2.kt\norg/openrndr/kartifex/Bezier2$QuadraticBezier2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,526:1\n1#2:527\n37#3:528\n36#3,3:529\n*S KotlinDebug\n*F\n+ 1 Bezier2.kt\norg/openrndr/kartifex/Bezier2$QuadraticBezier2\n*L\n182#1:528\n182#1:529,3\n*E\n"})
    public static final class QuadraticBezier2
    implements Curve2 {
        @NotNull
        private final Vec2 p0;
        @NotNull
        private final Vec2 p1;
        @NotNull
        private final Vec2 p2;
        private boolean noInflections;

        public QuadraticBezier2(@NotNull Vec2 p0, @NotNull Vec2 p1, @NotNull Vec2 p2) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            Intrinsics.checkNotNullParameter(p1, "p1");
            Intrinsics.checkNotNullParameter(p2, "p2");
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
        }

        @NotNull
        public final Vec2 getP0() {
            return this.p0;
        }

        @NotNull
        public final Vec2 getP1() {
            return this.p1;
        }

        @NotNull
        public final Vec2 getP2() {
            return this.p2;
        }

        private QuadraticBezier2(Vec2 p0, Vec2 p1, Vec2 p2, boolean noInflections) {
            this(p0, p1, p2);
            this.noInflections = noInflections;
        }

        @Override
        @NotNull
        public Vec2 start() {
            return this.p0;
        }

        @Override
        @NotNull
        public Vec2 end() {
            return this.p2;
        }

        @Override
        public boolean isFlat(double epsilon) {
            return Math.abs(INSTANCE.signedDistance(this.p1, this.p0, this.p2) / (double)2) < epsilon;
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public double signedArea() {
            return (this.p2.x() * (this.p0.y() - (double)2 * this.p1.y()) + (double)2 * this.p1.x() * (this.p2.y() - this.p0.y()) + this.p0.x() * ((double)2 * this.p1.y() + this.p2.y())) / (double)6;
        }

        @Override
        @NotNull
        public Vec2 position(double t) {
            if (t == 0.0) {
                return this.start();
            }
            if (t == 1.0) {
                return this.end();
            }
            double mt = 1.0 - t;
            return this.p0.mul(mt * mt).add(this.p1.mul((double)2 * t * mt)).add(this.p2.mul(t * t));
        }

        @Override
        @NotNull
        public Vec2 direction(double t) {
            double mt = 1.0 - t;
            return this.p1.sub(this.p0).mul((double)2 * mt).add(this.p2.sub(this.p1).mul((double)2 * t));
        }

        @Override
        @NotNull
        public QuadraticBezier2 endpoints(@NotNull Vec2 start, @NotNull Vec2 end) {
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(end, "end");
            Vec2 ad = this.p1.sub(this.p0);
            Vec2 bd = this.p1.sub(this.p2);
            double dx = end.x() - start.x();
            double dy = end.y() - start.y();
            double det = bd.x() * ad.y() - bd.y() * ad.x();
            double u = (dy * bd.x() - dx * bd.y()) / det;
            return new QuadraticBezier2(start, start.add(ad.mul(u)), end, this.noInflections);
        }

        @Override
        @NotNull
        public Curve2[] split(double t) {
            if (!(!(t <= 0.0) && !(t >= 1.0))) {
                boolean $i$a$-require-Bezier2$QuadraticBezier2$split$22 = false;
                String $i$a$-require-Bezier2$QuadraticBezier2$split$22 = "t must be within (0,1)";
                throw new IllegalArgumentException($i$a$-require-Bezier2$QuadraticBezier2$split$22.toString());
            }
            Vec2 e = Vec.Companion.lerp(this.p0, this.p1, t);
            Vec2 f = Vec.Companion.lerp(this.p1, this.p2, t);
            Vec2 g = this.position(t);
            Curve2[] curve2Array = new Curve2[]{new QuadraticBezier2(this.p0, e, g, this.noInflections), new QuadraticBezier2(g, f, this.p2, this.noInflections)};
            return curve2Array;
        }

        @Override
        @NotNull
        public Vec2[] subdivide(double error) {
            ArrayList<Vec2> points2 = new ArrayList<Vec2>();
            INSTANCE.subdivide(points2, this, QuadraticBezier2::subdivide$lambda$1, error * error);
            points2.add(this.end());
            Collection $this$toTypedArray$iv = points2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Vec2[0]);
        }

        @Override
        public double nearestPoint(@NotNull Vec2 p) {
            Intrinsics.checkNotNullParameter(p, "p");
            Vec2 qa = this.p0.sub(p);
            Vec2 ab = this.p1.sub(this.p0);
            Vec2 bc = this.p2.sub(this.p1);
            Vec2 qc = this.p2.sub(p);
            Vec2 ac = this.p2.sub(this.p0);
            Vec2 br = this.p0.add(this.p2).sub(this.p1).sub(this.p1);
            double minDistance = INSTANCE.sign(Vec2.Companion.cross(ab, qa)) * qa.length();
            double param = -Vec.Companion.dot(qa, ab) / Vec.Companion.dot(ab, ab);
            double distance = INSTANCE.sign(Vec2.Companion.cross(bc, qc)) * qc.length();
            if (Math.abs(distance) < Math.abs(minDistance)) {
                minDistance = distance;
                param = Math.max(1.0, Vec.Companion.dot(p.sub(this.p1), bc) / Vec.Companion.dot(bc, bc));
            }
            double a = Vec.Companion.dot(br, br);
            double b = (double)3 * Vec.Companion.dot(ab, br);
            double c2 = (double)2 * Vec.Companion.dot(ab, ab) + Vec.Companion.dot(qa, br);
            double d = Vec.Companion.dot(qa, ab);
            for (double t : EquationsKt.solveCubic(a, b, c2, d)) {
                Vec2 endpoint;
                if (!(t > 0.0) || !(t < 1.0) || !(Math.abs(distance = INSTANCE.sign(Vec2.Companion.cross(ac, (endpoint = this.position(t)).sub(p))) * endpoint.sub(p).length()) < Math.abs(minDistance))) continue;
                minDistance = distance;
                param = t;
            }
            return param;
        }

        @Override
        @NotNull
        public Curve2 transform(@NotNull Matrix3 m) {
            Intrinsics.checkNotNullParameter(m, "m");
            return new QuadraticBezier2(this.p0.transform(m), this.p1.transform(m), this.p2.transform(m));
        }

        @Override
        @NotNull
        public QuadraticBezier2 reverse() {
            return new QuadraticBezier2(this.p2, this.p1, this.p0, this.noInflections);
        }

        @Override
        @NotNull
        public Box2 bounds() {
            return this.noInflections ? Box.Companion.box(this.p0, this.p2) : Curve2.DefaultImpls.bounds(this);
        }

        @Override
        @NotNull
        public double[] inflections() {
            double[] dArray;
            if (this.noInflections) {
                return new double[0];
            }
            double epsilon = 1.0E-10;
            Vec2 div = this.p0.sub(this.p1.mul(2.0)).add(this.p2);
            if (Intrinsics.areEqual(div, Vec2.Companion.getORIGIN())) {
                this.noInflections = true;
                dArray = new double[]{};
            } else {
                Vec2 v = this.p0.sub(this.p1).div(div);
                boolean x = ScalarsKt.inside(epsilon, v.x(), 1.0 - epsilon);
                boolean y = ScalarsKt.inside(epsilon, v.y(), 1.0 - epsilon);
                if (x && y) {
                    double[] dArray2 = new double[]{v.x(), v.y()};
                    dArray = dArray2;
                } else if (x ^ y) {
                    double[] dArray3 = new double[]{x ? v.x() : v.y()};
                    dArray = dArray3;
                } else {
                    this.noInflections = true;
                    dArray = new double[]{};
                }
            }
            return dArray;
        }

        @NotNull
        public String toString() {
            return "QuadraticBezier2(p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + ")";
        }

        @Override
        @NotNull
        public Curve2[] split(@NotNull double[] unsafeTs) {
            return Curve2.DefaultImpls.split(this, unsafeTs);
        }

        @Override
        @NotNull
        public Curve2 range(@NotNull Interval interval) {
            return Curve2.DefaultImpls.range(this, interval);
        }

        @Override
        @NotNull
        public Curve2 range(double tMin, double tMax) {
            return Curve2.DefaultImpls.range(this, tMin, tMax);
        }

        @Override
        @NotNull
        public Vec2[] intersections(@NotNull Curve2 c2) {
            return Curve2.DefaultImpls.intersections(this, c2);
        }

        private static final double subdivide$lambda$1(QuadraticBezier2 b) {
            Intrinsics.checkNotNullParameter(b, "b");
            return Vec.Companion.lerp(b.p0, b.p2, 0.5).sub(b.p1).lengthSquared();
        }
    }
}

