/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils.regions;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Curve2;
import org.openrndr.kartifex.Vec2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/kartifex/utils/regions/VertexUnion;", "", "<init>", "()V", "parent", "", "Lorg/openrndr/kartifex/Vec2;", "roots", "", "join", "", "a", "b", "adjust", "p", "Lorg/openrndr/kartifex/Curve2;", "c", "", "openrndr-kartifex"})
public final class VertexUnion {
    @NotNull
    private final Map<Vec2, Vec2> parent = new LinkedHashMap();
    @NotNull
    private final Set<Vec2> roots = new LinkedHashSet();

    public final void join(@NotNull Vec2 a, @NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Vec2 a2 = a;
        Vec2 b2 = b;
        a2 = this.adjust(a2);
        b2 = this.adjust(b2);
        int cmp = a2.compareTo(b2);
        if (cmp < 0) {
            this.parent.put(b2, a2);
            v0 = this.roots.add(a2);
        } else if (cmp > 0) {
            this.parent.put(a2, b2);
            v0 = this.roots.add(b2);
        } else {
            v0 = this.roots.add(b2);
        }
    }

    @NotNull
    public final Vec2 adjust(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Vec2 curr = p;
        while (true) {
            Vec2 next;
            if ((next = this.parent.get(curr)) == null) {
                if (!Intrinsics.areEqual(curr, p)) {
                    this.parent.put(p, curr);
                }
                return curr;
            }
            curr = next;
        }
    }

    @Nullable
    public final Curve2 adjust(@NotNull Curve2 c2) {
        Intrinsics.checkNotNullParameter(c2, "c");
        Vec2 start = this.adjust(c2.start());
        Vec2 end = this.adjust(c2.end());
        return Intrinsics.areEqual(start, end) ? null : c2.endpoints(start, end);
    }

    @NotNull
    public final Set<Vec2> roots() {
        return SetsKt.minus(this.roots, (Iterable)this.parent.keySet());
    }
}

