/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ktessellation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.ktessellation.GLUface;
import org.openrndr.ktessellation.GLUhalfEdge;
import org.openrndr.ktessellation.GLUmesh;
import org.openrndr.ktessellation.GLUtessellatorImpl;
import org.openrndr.ktessellation.GLUvertex;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/openrndr/ktessellation/Normal;", "", "<init>", "()V", "SLANTED_SWEEP", "", "getSLANTED_SWEEP", "()Z", "setSLANTED_SWEEP", "(Z)V", "S_UNIT_X", "", "getS_UNIT_X", "()D", "setS_UNIT_X", "(D)V", "S_UNIT_Y", "getS_UNIT_Y", "setS_UNIT_Y", "TRUE_PROJECT", "Dot", "u", "", "v", "Normalize", "", "LongAxis", "", "ComputeNormal", "tess", "Lorg/openrndr/ktessellation/GLUtessellatorImpl;", "norm", "CheckOrientation", "__gl_projectPolygon", "openrndr-ktessellation"})
public final class Normal {
    @NotNull
    public static final Normal INSTANCE = new Normal();
    private static boolean SLANTED_SWEEP;
    private static double S_UNIT_X;
    private static double S_UNIT_Y;
    private static final boolean TRUE_PROJECT = false;

    private Normal() {
    }

    public final boolean getSLANTED_SWEEP() {
        return SLANTED_SWEEP;
    }

    public final void setSLANTED_SWEEP(boolean bl) {
        SLANTED_SWEEP = bl;
    }

    public final double getS_UNIT_X() {
        return S_UNIT_X;
    }

    public final void setS_UNIT_X(double d) {
        S_UNIT_X = d;
    }

    public final double getS_UNIT_Y() {
        return S_UNIT_Y;
    }

    public final void setS_UNIT_Y(double d) {
        S_UNIT_Y = d;
    }

    private final double Dot(double[] u, double[] v) {
        return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
    }

    public final void Normalize(@NotNull double[] v) {
        Intrinsics.checkNotNullParameter(v, "v");
        double len = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
        if (!(len > 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        len = Math.sqrt(len);
        v[0] = v[0] / len;
        v[1] = v[1] / len;
        v[2] = v[2] / len;
    }

    public final int LongAxis(@NotNull double[] v) {
        Intrinsics.checkNotNullParameter(v, "v");
        int i = 0;
        if (Math.abs(v[1]) > Math.abs(v[0])) {
            i = 1;
        }
        if (Math.abs(v[2]) > Math.abs(v[i])) {
            i = 2;
        }
        return i;
    }

    public final void ComputeNormal(@NotNull GLUtessellatorImpl tess, @NotNull double[] norm) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(norm, "norm");
        GLUvertex v = null;
        GLUvertex v1 = null;
        GLUvertex v2 = null;
        double c2 = 0.0;
        double tLen2 = 0.0;
        double maxLen2 = 0.0;
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        GLUvertex vHead = gLUmesh.getVHead();
        int i = 0;
        double[] maxVal = new double[3];
        double[] minVal = new double[3];
        GLUvertex[] minVert = new GLUvertex[3];
        GLUvertex[] maxVert = new GLUvertex[3];
        double[] d1 = new double[3];
        double[] d2 = new double[3];
        double[] tNorm = new double[3];
        maxVal[2] = -2.0E150;
        maxVal[1] = maxVal[2];
        maxVal[0] = maxVal[1];
        minVal[2] = 2.0E150;
        minVal[1] = minVal[2];
        minVal[0] = minVal[1];
        GLUvertex gLUvertex = vHead.getNext();
        if (gLUvertex == null) {
            throw new IllegalStateException("vhead next == null".toString());
        }
        v = gLUvertex;
        while (v != vHead) {
            for (i = 0; i < 3; ++i) {
                c2 = v.getCoords()[i];
                if (c2 < minVal[i]) {
                    minVal[i] = c2;
                    minVert[i] = v;
                }
                if (!(c2 > maxVal[i])) continue;
                maxVal[i] = c2;
                maxVert[i] = v;
            }
            if (v.getNext() != null) continue;
            throw new IllegalStateException("v.next == null".toString());
        }
        i = 0;
        if (maxVal[1] - minVal[1] > maxVal[0] - minVal[0]) {
            i = 1;
        }
        if (maxVal[2] - minVal[2] > maxVal[i] - minVal[i]) {
            i = 2;
        }
        if (minVal[i] >= maxVal[i]) {
            norm[0] = 0.0;
            norm[1] = 0.0;
            norm[2] = 1.0;
            return;
        }
        maxLen2 = 0.0;
        GLUvertex gLUvertex2 = minVert[i];
        if (gLUvertex2 == null) {
            throw new IllegalStateException(("minVert[" + i + "] == null").toString());
        }
        v1 = gLUvertex2;
        GLUvertex gLUvertex3 = maxVert[i];
        if (gLUvertex3 == null) {
            throw new IllegalStateException(("maxVert[" + i + "] == null").toString());
        }
        v2 = gLUvertex3;
        d1[0] = v1.getCoords()[0] - v2.getCoords()[0];
        d1[1] = v1.getCoords()[1] - v2.getCoords()[1];
        d1[2] = v1.getCoords()[2] - v2.getCoords()[2];
        GLUvertex gLUvertex4 = vHead.getNext();
        if (gLUvertex4 == null) {
            throw new IllegalStateException("vHead.next == null".toString());
        }
        v = gLUvertex4;
        while (v != vHead) {
            d2[0] = v.getCoords()[0] - v2.getCoords()[0];
            d2[1] = v.getCoords()[1] - v2.getCoords()[1];
            d2[2] = v.getCoords()[2] - v2.getCoords()[2];
            tNorm[0] = d1[1] * d2[2] - d1[2] * d2[1];
            tNorm[1] = d1[2] * d2[0] - d1[0] * d2[2];
            tNorm[2] = d1[0] * d2[1] - d1[1] * d2[0];
            tLen2 = tNorm[0] * tNorm[0] + tNorm[1] * tNorm[1] + tNorm[2] * tNorm[2];
            if (tLen2 > maxLen2) {
                maxLen2 = tLen2;
                norm[0] = tNorm[0];
                norm[1] = tNorm[1];
                norm[2] = tNorm[2];
            }
            if (v.getNext() != null) continue;
            throw new IllegalStateException("v.next == null".toString());
        }
        if (maxLen2 <= 0.0) {
            norm[2] = 0.0;
            norm[1] = norm[2];
            norm[0] = norm[1];
            norm[this.LongAxis((double[])d1)] = 1.0;
        }
    }

    public final void CheckOrientation(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        GLUface f = null;
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        GLUface fHead = gLUmesh.getFHead();
        GLUvertex v = null;
        GLUmesh gLUmesh2 = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh2);
        GLUvertex vHead = gLUmesh2.getVHead();
        GLUhalfEdge e = null;
        double area = 0.0;
        GLUface gLUface = fHead.getNext();
        if (gLUface == null) {
            throw new IllegalStateException("fHead.next == null".toString());
        }
        f = gLUface;
        while (f != fHead) {
            if (f.getAnEdge() == null) {
                throw new IllegalStateException("f.anEdge == null".toString());
            }
            if (e.getWinding() <= 0) {
                if (f.getNext() != null) continue;
                throw new IllegalStateException("f.next == null".toString());
            }
            do {
                GLUvertex gLUvertex = e.getOrg();
                Intrinsics.checkNotNull(gLUvertex);
                double d = gLUvertex.getS();
                GLUhalfEdge gLUhalfEdge = e.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge);
                GLUvertex gLUvertex2 = gLUhalfEdge.getOrg();
                Intrinsics.checkNotNull(gLUvertex2);
                double d2 = d - gLUvertex2.getS();
                GLUvertex gLUvertex3 = e.getOrg();
                Intrinsics.checkNotNull(gLUvertex3);
                double d3 = gLUvertex3.getT();
                GLUhalfEdge gLUhalfEdge2 = e.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge2);
                GLUvertex gLUvertex4 = gLUhalfEdge2.getOrg();
                Intrinsics.checkNotNull(gLUvertex4);
                area += d2 * (d3 + gLUvertex4.getT());
                if (e.getLnext() != null) continue;
                throw new IllegalStateException("e.Lnext == null".toString());
            } while (e != f.getAnEdge());
            if (f.getNext() != null) continue;
            throw new IllegalStateException("f.next == null".toString());
        }
        if (area < 0.0) {
            GLUvertex gLUvertex = vHead.getNext();
            if (gLUvertex == null) {
                throw new IllegalStateException("vHead.next == null".toString());
            }
            v = gLUvertex;
            while (v != vHead) {
                v.setT(-v.getT());
                if (v.getNext() != null) continue;
                throw new IllegalStateException("v.next == null".toString());
            }
            tess.getTUnit()[0] = -tess.getTUnit()[0];
            tess.getTUnit()[1] = -tess.getTUnit()[1];
            tess.getTUnit()[2] = -tess.getTUnit()[2];
        }
    }

    public final void __gl_projectPolygon(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        GLUvertex v = null;
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        GLUvertex vHead = gLUmesh.getVHead();
        double w = 0.0;
        double[] norm = new double[3];
        boolean computedNormal = false;
        norm[0] = tess.getNormal()[0];
        norm[1] = tess.getNormal()[1];
        norm[2] = tess.getNormal()[2];
        if (norm[0] == 0.0 && norm[1] == 0.0 && norm[2] == 0.0) {
            this.ComputeNormal(tess, norm);
            computedNormal = true;
        }
        double[] sUnit = tess.getSUnit();
        double[] tUnit = tess.getTUnit();
        int i = this.LongAxis(norm);
        sUnit[i] = 0.0;
        sUnit[(i + 1) % 3] = S_UNIT_X;
        sUnit[(i + 2) % 3] = S_UNIT_Y;
        tUnit[i] = 0.0;
        tUnit[(i + 1) % 3] = norm[i] > 0.0 ? -S_UNIT_Y : S_UNIT_Y;
        tUnit[(i + 2) % 3] = norm[i] > 0.0 ? S_UNIT_X : -S_UNIT_X;
        GLUvertex gLUvertex = vHead.getNext();
        if (gLUvertex == null) {
            throw new IllegalStateException("vHead.next == null".toString());
        }
        v = gLUvertex;
        while (v != vHead) {
            v.setS(this.Dot(v.getCoords(), sUnit));
            v.setT(this.Dot(v.getCoords(), tUnit));
            if (v.getNext() != null) continue;
            throw new IllegalStateException("v.next == null".toString());
        }
        if (computedNormal) {
            this.CheckOrientation(tess);
        }
    }

    static {
        if (SLANTED_SWEEP) {
            S_UNIT_X = 0.5094153956495538;
            S_UNIT_Y = 0.8605207462201063;
        } else {
            S_UNIT_X = 1.0;
            S_UNIT_Y = 0.0;
        }
    }
}

