/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Ellipse$;
import org.openrndr.shape.Movable;
import org.openrndr.shape.Scalable2D;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContourProvider;
import org.openrndr.shape.ShapeProvider;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002ABB\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fB5\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J(\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J \u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\tH\u0016J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000H\u0086\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\tH\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003J'\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105H\u00d6\u0003J\t\u00106\u001a\u00020\u000eH\u00d6\u0001J\t\u00107\u001a\u000208H\u00d6\u0001J%\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0001\u00a2\u0006\u0002\b@R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010-\u00a8\u0006C"}, d2={"Lorg/openrndr/shape/Ellipse;", "Lorg/openrndr/shape/Movable;", "Lorg/openrndr/shape/Scalable2D;", "Lorg/openrndr/shape/ShapeProvider;", "Lorg/openrndr/shape/ShapeContourProvider;", "Ljava/lang/Record;", "center", "Lorg/openrndr/math/Vector2;", "xRadius", "", "yRadius", "<init>", "(Lorg/openrndr/math/Vector2;DD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector2;DDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()Lorg/openrndr/math/Vector2;", "()D", "corner", "scale", "movedBy", "offset", "movedTo", "position", "scaledBy", "xScale", "yScale", "uAnchor", "vAnchor", "scaledTo", "radius", "times", "div", "plus", "right", "minus", "u", "v", "shape", "Lorg/openrndr/shape/Shape;", "()Lorg/openrndr/shape/Shape;", "contour", "Lorg/openrndr/shape/ShapeContour;", "()Lorg/openrndr/shape/ShapeContour;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
public final class Ellipse
extends Record
implements Movable,
Scalable2D,
ShapeProvider,
ShapeContourProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 center;
    private final double xRadius;
    private final double yRadius;

    public Ellipse(@NotNull Vector2 center, double xRadius, double yRadius) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.xRadius = xRadius;
        this.yRadius = yRadius;
    }

    @NotNull
    public final Vector2 center() {
        return this.center;
    }

    public final double xRadius() {
        return this.xRadius;
    }

    public final double yRadius() {
        return this.yRadius;
    }

    @NotNull
    public final Vector2 corner() {
        return this.center.minus(this.scale());
    }

    @NotNull
    public Vector2 scale() {
        return new Vector2(this.xRadius, this.yRadius);
    }

    @Override
    @NotNull
    public Ellipse movedBy(@NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        return new Ellipse(this.center.plus(offset), this.xRadius, this.yRadius);
    }

    @Override
    @NotNull
    public Ellipse movedTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new Ellipse(position, this.xRadius, this.yRadius);
    }

    @Override
    @NotNull
    public Ellipse scaledBy(double xScale, double yScale, double uAnchor, double vAnchor) {
        Vector2 anchorPosition = this.position(uAnchor, vAnchor);
        return new Ellipse(anchorPosition, this.xRadius * xScale, this.yRadius * yScale);
    }

    @Override
    @NotNull
    public Ellipse scaledBy(double scale, double uAnchor, double vAnchor) {
        return this.scaledBy(scale, scale, uAnchor, vAnchor);
    }

    @Override
    @NotNull
    public Ellipse scaledTo(double xRadius, double yRadius) {
        return new Ellipse(this.center, xRadius, yRadius);
    }

    @Override
    @NotNull
    public Ellipse scaledTo(double radius) {
        return this.scaledTo(radius, radius);
    }

    @NotNull
    public final Ellipse times(double scale) {
        return new Ellipse(this.center.times(scale), this.xRadius * scale, this.yRadius * scale);
    }

    @NotNull
    public final Ellipse div(double scale) {
        return new Ellipse(this.center.div(scale), this.xRadius / scale, this.yRadius / scale);
    }

    @NotNull
    public final Ellipse plus(@NotNull Ellipse right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Ellipse(this.center.plus(right.center), this.xRadius + right.xRadius, this.yRadius + right.yRadius);
    }

    @NotNull
    public final Ellipse minus(@NotNull Ellipse right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Ellipse(this.center.minus(right.center), this.xRadius - right.xRadius, this.yRadius - right.yRadius);
    }

    @Override
    @NotNull
    public Vector2 position(double u, double v) {
        return this.corner().plus(new Vector2(u * (double)2 * this.xRadius, v * (double)2 * this.yRadius));
    }

    @NotNull
    public Shape shape() {
        return new Shape(CollectionsKt.listOf(this.contour()));
    }

    @NotNull
    public ShapeContour contour() {
        double x = this.center.x() - this.xRadius;
        double y = this.center.y() - this.yRadius;
        double width = this.xRadius * 2.0;
        double height = this.yRadius * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        return ShapeBuilderKt.contour(arg_0 -> Ellipse._get_contour_$lambda$0(x, ym, oy, xm, ox, y, xe, ye, arg_0));
    }

    @NotNull
    public final Vector2 component1() {
        return this.center;
    }

    public final double component2() {
        return this.xRadius;
    }

    public final double component3() {
        return this.yRadius;
    }

    @NotNull
    public final Ellipse copy(@NotNull Vector2 center, double xRadius, double yRadius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new Ellipse(center, xRadius, yRadius);
    }

    public static /* synthetic */ Ellipse copy$default(Ellipse ellipse, Vector2 vector2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = ellipse.center;
        }
        if ((n & 2) != 0) {
            d = ellipse.xRadius;
        }
        if ((n & 4) != 0) {
            d2 = ellipse.yRadius;
        }
        return ellipse.copy(vector2, d, d2);
    }

    @Override
    @NotNull
    public String toString() {
        return "Ellipse(center=" + this.center + ", xRadius=" + this.xRadius + ", yRadius=" + this.yRadius + ")";
    }

    @Override
    public int hashCode() {
        int result = this.center.hashCode();
        result = result * 31 + Double.hashCode(this.xRadius);
        result = result * 31 + Double.hashCode(this.yRadius);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ellipse)) {
            return false;
        }
        Ellipse ellipse = (Ellipse)other;
        if (!Intrinsics.areEqual(this.center, ellipse.center)) {
            return false;
        }
        if (Double.compare(this.xRadius, ellipse.xRadius) != 0) {
            return false;
        }
        return Double.compare(this.yRadius, ellipse.yRadius) == 0;
    }

    @Override
    @NotNull
    public Vector2 position(@NotNull Vector2 uv) {
        return Scalable2D.DefaultImpls.position(this, uv);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Ellipse self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector2$.serializer.INSTANCE, self.center);
        output.encodeDoubleElement(serialDesc, 1, self.xRadius);
        output.encodeDoubleElement(serialDesc, 2, self.yRadius);
    }

    public /* synthetic */ Ellipse(int seen0, Vector2 center, double xRadius, double yRadius, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.center = center;
        this.xRadius = xRadius;
        this.yRadius = yRadius;
    }

    private static final Unit _get_contour_$lambda$0(double $x, double $ym, double $oy, double $xm, double $ox, double $y, double $xe, double $ye, ContourBuilder $this$contour) {
        Intrinsics.checkNotNullParameter($this$contour, "$this$contour");
        $this$contour.moveTo(new Vector2($x, $ym));
        $this$contour.curveTo(new Vector2($x, $ym - $oy), new Vector2($xm - $ox, $y), new Vector2($xm, $y));
        $this$contour.curveTo(new Vector2($xm + $ox, $y), new Vector2($xe, $ym - $oy), new Vector2($xe, $ym));
        $this$contour.curveTo(new Vector2($xe, $ym + $oy), new Vector2($xm + $ox, $ye), new Vector2($xm, $ye));
        $this$contour.curveTo(new Vector2($xm - $ox, $ye), new Vector2($x, $ym + $oy), new Vector2($x, $ym));
        $this$contour.close();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/Ellipse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/Ellipse;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Ellipse> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

