/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.openrndr.shape.Path1D$;
import org.openrndr.shape.Segment1D;
import org.openrndr.shape.Segment1D$;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB3\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0013J\"\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00180\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0013J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lorg/openrndr/shape/Path1D;", "", "segments", "", "Lorg/openrndr/shape/Segment1D;", "closed", "", "<init>", "(Ljava/util/List;Z)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSegments", "()Ljava/util/List;", "getClosed", "()Z", "position", "", "ut", "adaptivePositions", "distanceTolerance", "adaptivePositionsWithT", "Lkotlin/Pair;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
public final class Path1D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Segment1D> segments;
    private final boolean closed;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public Path1D(@NotNull List<Segment1D> segments, boolean closed) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        this.segments = segments;
        this.closed = closed;
    }

    @NotNull
    public final List<Segment1D> getSegments() {
        return this.segments;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final double position(double ut) {
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        int segment = (int)(t * (double)this.segments.size());
        double segmentOffset = t * (double)this.segments.size() - (double)segment;
        return this.segments.get(Math.min(this.segments.size() - 1, segment)).position(segmentOffset);
    }

    @NotNull
    public final List<Double> adaptivePositions(double distanceTolerance) {
        List adaptivePoints = new ArrayList();
        Double last2 = null;
        for (Segment1D segment : this.segments) {
            List<Double> samples2 = segment.adaptivePositions(distanceTolerance);
            if (!(!((Collection)samples2).isEmpty())) continue;
            double r = ((Number)samples2.get(0)).doubleValue();
            if (last2 == null || last2 - r > 0.001) {
                adaptivePoints.add(r);
            }
            int n = samples2.size();
            for (int i = 1; i < n; ++i) {
                adaptivePoints.add(samples2.get(i));
                last2 = samples2.get(i);
            }
        }
        return adaptivePoints;
    }

    public static /* synthetic */ List adaptivePositions$default(Path1D path1D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 25.0;
        }
        return path1D.adaptivePositions(d);
    }

    @NotNull
    public final List<Pair<Double, Double>> adaptivePositionsWithT(double distanceTolerance) {
        List adaptivePoints = new ArrayList();
        for (Segment1D segment : this.segments) {
            List<Pair<Double, Double>> samples2 = segment.adaptivePositionsWithT(distanceTolerance);
            if (!(!((Collection)samples2).isEmpty())) continue;
            Pair<Double, Double> r = samples2.get(0);
            adaptivePoints.add(r);
            int n = samples2.size();
            for (int i = 1; i < n; ++i) {
                adaptivePoints.add(samples2.get(i));
            }
        }
        return adaptivePoints;
    }

    public static /* synthetic */ List adaptivePositionsWithT$default(Path1D path1D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 25.0;
        }
        return path1D.adaptivePositionsWithT(d);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Path1D self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.segments);
        output.encodeBooleanElement(serialDesc, 1, self.closed);
    }

    public /* synthetic */ Path1D(int seen0, List segments, boolean closed, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.segments = segments;
        this.closed = closed;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer(Segment1D$.serializer.INSTANCE), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/Path1D$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/Path1D;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Path1D> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

