/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.nodes;

import io.lacuna.bifurcan.utils.Bits;

public class ListNodes {
    private static final int SHIFT_INCREMENT = 5;
    private static final int MAX_BRANCHES = 32;
    private static final int BRANCH_MASK = 31;

    public static Object slice(Object node, Object editor, int start, int end2) {
        if (node instanceof Object[]) {
            Object[] ary = new Object[end2 - start];
            System.arraycopy(node, start, ary, 0, ary.length);
            return ary;
        }
        return ((Node)node).slice(start, end2, editor);
    }

    public static Object[] set(Object[] elements, int idx, Object value2) {
        Object[] ary = (Object[])elements.clone();
        ary[idx] = value2;
        return ary;
    }

    public static Node pushLast(Node a2, Object b, Object editor) {
        if (b instanceof Node) {
            return a2.pushLast((Node)b, editor);
        }
        return a2.pushLast((Object[])b, editor);
    }

    public static class Node {
        public static final Node EMPTY = new Node(new Object(), 5);
        public final byte shift;
        public boolean isStrict;
        public int numNodes;
        Object editor;
        public int[] offsets;
        public Object[] nodes;

        public Node(Object editor, int shift) {
            this.editor = editor;
            this.shift = (byte)shift;
            this.numNodes = 0;
            this.offsets = new int[2];
            this.nodes = new Object[2];
        }

        private Node(int shift) {
            this.shift = (byte)shift;
        }

        private static Node from(Object editor, int shift, Node child) {
            return new Node(editor, shift).pushLast(child, editor);
        }

        private static Node from(Object editor, int shift, Node a2, Node b) {
            return new Node(editor, shift).pushLast(a2, editor).pushLast(b, editor);
        }

        private static Node from(Object editor, Object[] child) {
            return new Node(editor, 5).pushLast(child, editor);
        }

        public Object[] first() {
            if (this.numNodes == 0) {
                return null;
            }
            Node n = this;
            while (n.shift > 5) {
                n = (Node)n.nodes[0];
            }
            return (Object[])n.nodes[0];
        }

        public Object[] last() {
            if (this.numNodes == 0) {
                return null;
            }
            Node n = this;
            while (n.shift > 5) {
                n = (Node)n.nodes[n.numNodes - 1];
            }
            return (Object[])n.nodes[n.numNodes - 1];
        }

        public Object nth(int idx, boolean returnChunk) {
            if (!this.isStrict) {
                return this.relaxedNth(idx, returnChunk);
            }
            Node n = this;
            while (n.shift > 5) {
                int nodeIdx = idx >>> n.shift & 0x1F;
                n = (Node)n.nodes[nodeIdx];
                if (n.isStrict) continue;
                return n.relaxedNth(idx, returnChunk);
            }
            Object[] chunk = (Object[])n.nodes[idx >>> 5 & 0x1F];
            return returnChunk ? chunk : chunk[idx & 0x1F];
        }

        private Object relaxedNth(int idx, boolean returnChunk) {
            int nodeIdx;
            idx &= (int)Bits.maskBelow(this.shift + 5);
            Node n = this;
            while (n.shift > 5) {
                nodeIdx = n.indexOf(idx);
                idx -= n.offset(nodeIdx);
                n = (Node)n.nodes[nodeIdx];
            }
            nodeIdx = n.indexOf(idx);
            Object[] chunk = (Object[])n.nodes[nodeIdx];
            return returnChunk ? chunk : chunk[idx - n.offset(nodeIdx)];
        }

        private int indexOf(int idx) {
            int estimate;
            int n = estimate = this.shift > 60 ? 0 : idx >>> this.shift & 0x1F;
            if (this.isStrict) {
                return estimate;
            }
            for (int i = estimate; i < this.nodes.length; ++i) {
                if (idx >= this.offsets[i]) continue;
                return i;
            }
            return -1;
        }

        int offset(int idx) {
            return idx == 0 ? 0 : this.offsets[idx - 1];
        }

        public Node set(Object editor, int idx, Object value2) {
            if (editor != this.editor) {
                return this.clone(editor).set(editor, idx, value2);
            }
            int nodeIdx = this.indexOf(idx);
            this.nodes[nodeIdx] = this.shift == 5 ? ListNodes.set((Object[])this.nodes[nodeIdx], idx - this.offset(nodeIdx), value2) : ((Node)this.nodes[nodeIdx]).set(editor, idx - this.offset(nodeIdx), value2);
            return this;
        }

        public int size() {
            return this.numNodes == 0 ? 0 : this.offsets[this.numNodes - 1];
        }

        public Node concat(Node node, Object editor) {
            if (this.size() == 0) {
                return node;
            }
            if (node.size() == 0) {
                return this;
            }
            if (this.shift == node.shift) {
                Node newNode = editor == this.editor ? this : this.clone(editor);
                for (int i = 0; i < node.numNodes; ++i) {
                    newNode = ListNodes.pushLast(newNode, node.nodes[i], editor);
                }
                return newNode;
            }
            if (this.shift < node.shift) {
                return node.pushFirst(this, editor);
            }
            return this.pushLast(node, editor);
        }

        public Node slice(int start, int end2, Object editor) {
            if (start == end2) {
                return EMPTY;
            }
            if (start == 0 && end2 == this.size()) {
                return this;
            }
            int startIdx = this.indexOf(start);
            int endIdx = this.indexOf(end2 - 1);
            Node rn = new Node(editor, this.shift);
            if (startIdx == endIdx) {
                int offset2 = this.offset(startIdx);
                Object child = ListNodes.slice(this.nodes[startIdx], editor, start - offset2, end2 - offset2);
                if (this.shift > 5) {
                    return (Node)child;
                }
                rn = ListNodes.pushLast(rn, child, editor);
            } else {
                int sLower = this.offset(startIdx);
                int sUpper = this.offset(startIdx + 1);
                rn = ListNodes.pushLast(rn, ListNodes.slice(this.nodes[startIdx], editor, start - sLower, sUpper - sLower), editor);
                for (int i = startIdx + 1; i < endIdx; ++i) {
                    rn = ListNodes.pushLast(rn, this.nodes[i], editor);
                }
                int eLower = this.offset(endIdx);
                rn = ListNodes.pushLast(rn, ListNodes.slice(this.nodes[endIdx], editor, 0, end2 - eLower), editor);
            }
            return rn;
        }

        public Node pushLast(Object[] chunk, Object editor) {
            int i;
            if (this.size() == 0 && this.shift > 5) {
                return this.pushLast(Node.from(editor, chunk), editor);
            }
            Node[] stack = new Node[this.shift / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[n.numNodes - 1];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.numNodes == 32 ? new Node(editor, this.shift + 5).pushLast(this, editor).pushLast(chunk, editor) : this.pushLast(new Node(editor, 5).pushLast(chunk, editor), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow();
            }
            parent.offsets[parent.numNodes] = parent.size();
            ++parent.numNodes;
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                int lastIdx = n.numNodes - 1;
                n.nodes[lastIdx] = i2 == stack.length - 1 ? chunk : stack[i2 + 1];
                int n2 = lastIdx;
                n.offsets[n2] = n.offsets[n2] + chunk.length;
                n.updateStrict();
            }
            return stack[0];
        }

        public Node pushFirst(Object[] chunk, Object editor) {
            int i;
            if (this.size() == 0 && this.shift > 5) {
                return this.pushLast(chunk, editor);
            }
            Node[] stack = new Node[this.shift / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[0];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.numNodes == 32 ? new Node(editor, this.shift + 5).pushLast(chunk, editor).pushLast(this, editor) : this.pushFirst(new Node(editor, 5).pushLast(chunk, editor), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow();
            }
            System.arraycopy(parent.nodes, 0, parent.nodes, 1, parent.numNodes);
            System.arraycopy(parent.offsets, 0, parent.offsets, 1, parent.numNodes);
            parent.offsets[0] = 0;
            ++parent.numNodes;
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                n.nodes[0] = i2 == stack.length - 1 ? chunk : stack[i2 + 1];
                int j = 0;
                while (j < n.numNodes) {
                    int n2 = j++;
                    n.offsets[n2] = n.offsets[n2] + chunk.length;
                }
                n.updateStrict();
            }
            return stack[0];
        }

        public Node pushLast(Node node, Object editor) {
            int i;
            if (node.size() == 0) {
                return this;
            }
            if (this.shift < node.shift) {
                return node.pushFirst(this, editor);
            }
            if (this.shift == node.shift) {
                return Node.from(editor, this.shift + 5, this, node);
            }
            Node[] stack = new Node[(this.shift - node.shift) / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[n.numNodes - 1];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.pushLast(Node.from(editor, node.shift + 5, node), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow();
            }
            parent.offsets[parent.numNodes] = parent.size();
            ++parent.numNodes;
            int nSize = node.size();
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                int lastIdx = n.numNodes - 1;
                n.nodes[lastIdx] = i2 == stack.length - 1 ? node : stack[i2 + 1];
                int n2 = lastIdx;
                n.offsets[n2] = n.offsets[n2] + nSize;
                n.updateStrict();
            }
            return stack[0];
        }

        public Node pushFirst(Node node, Object editor) {
            int i;
            if (node.size() == 0) {
                return this;
            }
            if (this.shift < node.shift) {
                return node.pushLast(this, editor);
            }
            if (this.shift == node.shift) {
                return Node.from(editor, this.shift + 5, node, this);
            }
            Node[] stack = new Node[(this.shift - node.shift) / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[0];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.pushFirst(Node.from(editor, node.shift + 5, node), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow();
            }
            System.arraycopy(parent.nodes, 0, parent.nodes, 1, parent.numNodes);
            System.arraycopy(parent.offsets, 0, parent.offsets, 1, parent.numNodes);
            ++parent.numNodes;
            parent.offsets[0] = 0;
            int nSize = node.size();
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                n.nodes[0] = i2 == stack.length - 1 ? node : stack[i2 + 1];
                int j = 0;
                while (j < n.numNodes) {
                    int n2 = j++;
                    n.offsets[n2] = n.offsets[n2] + nSize;
                }
                n.updateStrict();
            }
            return stack[0];
        }

        public Node popFirst(Object editor) {
            Node[] stack = new Node[this.shift / 5];
            stack[0] = editor == this.editor ? this : this.clone(editor);
            for (int i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[0];
            }
            Node parent = stack[stack.length - 1];
            Object[] chunk = (Object[])parent.nodes[0];
            for (int i = 0; i < stack.length; ++i) {
                Node n = stack[i];
                int j = 0;
                while (j < n.numNodes) {
                    int n2 = j++;
                    n.offsets[n2] = n.offsets[n2] - chunk.length;
                }
                n.updateStrict();
                if (n.offsets[0] == 0) {
                    --n.numNodes;
                    if (n.numNodes == 1 && n.shift > 5) {
                        return (Node)n.nodes[1];
                    }
                    System.arraycopy(n.nodes, 1, n.nodes, 0, n.numNodes);
                    System.arraycopy(n.offsets, 1, n.offsets, 0, n.numNodes);
                    n.nodes[n.numNodes] = null;
                    n.offsets[n.numNodes] = 0;
                    break;
                }
                if (stack[i + 1].editor != editor) {
                    stack[i + 1] = stack[i + 1].clone(editor);
                }
                n.nodes[0] = stack[i + 1];
            }
            return stack[0];
        }

        public Node popLast(Object editor) {
            Node[] stack = new Node[this.shift / 5];
            stack[0] = editor == this.editor ? this : this.clone(editor);
            for (int i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[n.numNodes - 1];
            }
            Node parent = stack[stack.length - 1];
            Object[] chunk = (Object[])parent.nodes[parent.numNodes - 1];
            for (int i = 0; i < stack.length; ++i) {
                int lastIdx;
                Node n = stack[i];
                int n2 = lastIdx = n.numNodes - 1;
                n.offsets[n2] = n.offsets[n2] - chunk.length;
                if (n.offset(lastIdx + 1) == n.offset(lastIdx)) {
                    --n.numNodes;
                    if (n.numNodes == 1 && n.shift > 5) {
                        return (Node)n.nodes[0];
                    }
                    n.nodes[n.numNodes] = null;
                    n.offsets[n.numNodes] = 0;
                    n.updateStrict();
                    break;
                }
                if (stack[i + 1].editor != editor) {
                    stack[i + 1] = stack[i + 1].clone(editor);
                }
                n.nodes[lastIdx] = stack[i + 1];
                n.updateStrict();
            }
            return stack[0];
        }

        private void grow() {
            int[] o = new int[this.offsets.length << 1];
            System.arraycopy(this.offsets, 0, o, 0, this.offsets.length);
            this.offsets = o;
            Object[] n = new Object[this.nodes.length << 1];
            System.arraycopy(this.nodes, 0, n, 0, this.nodes.length);
            this.nodes = n;
        }

        private void updateStrict() {
            this.isStrict = this.numNodes <= 1 || this.offset(this.numNodes - 1) == (this.numNodes - 1) * (1 << this.shift);
        }

        private Node clone(Object editor) {
            Node n = new Node(this.shift);
            n.editor = editor;
            n.numNodes = this.numNodes;
            n.offsets = (int[])this.offsets.clone();
            n.nodes = (Object[])this.nodes.clone();
            return n;
        }
    }
}

