/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineExceptionHandlerImplKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a%\u0010\u0000\u001a\u00020\u00012\u001a\b\u0004\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u0086\b\u001a$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u001a\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0000\u00a8\u0006\u0010"}, d2={"CoroutineExceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "handler", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext;", "", "", "handleCoroutineException", "context", "exception", "caller", "Lkotlinx/coroutines/Job;", "handleExceptionViaHandler", "handlerException", "originalException", "thrownException", "kotlinx-coroutines-core"})
public final class CoroutineExceptionHandlerKt {
    @InternalCoroutinesApi
    public static final void handleCoroutineException(@NotNull CoroutineContext context, @NotNull Throwable exception, @Nullable Job caller) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        if (exception instanceof CancellationException) {
            return;
        }
        Job job = (Job)context.get(Job.Key);
        if (job != null && job != caller && job.cancel(exception)) {
            return;
        }
        CoroutineExceptionHandlerKt.handleExceptionViaHandler(context, exception);
    }

    @InternalCoroutinesApi
    public static /* synthetic */ void handleCoroutineException$default(CoroutineContext coroutineContext, Throwable throwable, Job job, int n, Object object) {
        if ((n & 4) != 0) {
            job = null;
        }
        CoroutineExceptionHandlerKt.handleCoroutineException(coroutineContext, throwable, job);
    }

    @InternalCoroutinesApi
    public static final void handleExceptionViaHandler(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        try {
            CoroutineExceptionHandler coroutineExceptionHandler = (CoroutineExceptionHandler)context.get(CoroutineExceptionHandler.Key);
            if (coroutineExceptionHandler != null) {
                CoroutineExceptionHandler coroutineExceptionHandler2;
                CoroutineExceptionHandler it = coroutineExceptionHandler2 = coroutineExceptionHandler;
                it.handleException(context, exception);
                return;
            }
        }
        catch (Throwable t2) {
            CoroutineExceptionHandlerImplKt.handleCoroutineExceptionImpl(context, CoroutineExceptionHandlerKt.handlerException(exception, t2));
            return;
        }
        CoroutineExceptionHandlerImplKt.handleCoroutineExceptionImpl(context, exception);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Throwable handlerException(@NotNull Throwable originalException, @NotNull Throwable thrownException) {
        void $receiver$iv;
        RuntimeException runtimeException;
        Intrinsics.checkParameterIsNotNull(originalException, "originalException");
        Intrinsics.checkParameterIsNotNull(thrownException, "thrownException");
        if (originalException == thrownException) {
            return originalException;
        }
        RuntimeException $receiver = runtimeException = new RuntimeException("Exception while trying to handle coroutine exception", thrownException);
        Throwable throwable = $receiver;
        Throwable other$iv = originalException;
        ExceptionsKt.addSuppressed((Throwable)$receiver$iv, other$iv);
        return runtimeException;
    }

    @NotNull
    public static final CoroutineExceptionHandler CoroutineExceptionHandler(@NotNull Function2<? super CoroutineContext, ? super Throwable, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        return new CoroutineExceptionHandler(handler, CoroutineExceptionHandler.Key){
            final /* synthetic */ Function2 $handler;

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Intrinsics.checkParameterIsNotNull(context, "context");
                Intrinsics.checkParameterIsNotNull(exception, "exception");
                this.$handler.invoke(context, exception);
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }
}

