/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.internal.gl3.ColorBufferDataGL3;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.CubemapGL3;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.dds.DDSData;
import org.openrndr.internal.gl3.dds.DDSReaderKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J!\u0010\u0011\u001a\u00020\u000f2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\u0002\b\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/internal/gl3/CubemapGL3;", "Lorg/openrndr/draw/Cubemap;", "texture", "", "width", "sides", "", "Lorg/openrndr/draw/ColorBuffer;", "(IILjava/util/List;)V", "getSides", "()Ljava/util/List;", "getTexture", "()I", "getWidth", "bind", "", "textureUnit", "bound", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "destroy", "filter", "min", "Lorg/openrndr/draw/MinifyingFilter;", "mag", "Lorg/openrndr/draw/MagnifyingFilter;", "generateMipmaps", "side", "Lorg/openrndr/draw/CubemapSide;", "Companion", "openrndr-gl3"})
public final class CubemapGL3
implements Cubemap {
    private final int texture;
    private final int width;
    @NotNull
    private final List<ColorBuffer> sides;
    public static final Companion Companion = new Companion(null);

    @Override
    public void generateMipmaps() {
        this.bound(generateMipmaps.1.INSTANCE);
    }

    @Override
    public void filter(@NotNull MinifyingFilter min, @NotNull MagnifyingFilter mag) {
        Intrinsics.checkParameterIsNotNull((Object)min, "min");
        Intrinsics.checkParameterIsNotNull((Object)mag, "mag");
        this.bound((Function1<? super CubemapGL3, Unit>)new Function1<CubemapGL3, Unit>(min, mag){
            final /* synthetic */ MinifyingFilter $min;
            final /* synthetic */ MagnifyingFilter $mag;

            public final void invoke(@NotNull CubemapGL3 $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                GL33C.glTexParameteri(34067, 10241, ColorBufferGL3Kt.toGLFilter(this.$min));
                GL33C.glTexParameteri(34067, 10240, ColorBufferGL3Kt.toGLFilter(this.$mag));
            }
            {
                this.$min = minifyingFilter;
                this.$mag = magnifyingFilter;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public ColorBuffer side(@NotNull CubemapSide side) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        return this.sides.get(side.ordinal());
    }

    @Override
    public void bind(int textureUnit) {
        GL33C.glActiveTexture(33984 + textureUnit);
        GL33C.glBindTexture(34067, this.texture);
    }

    @Override
    public void destroy() {
        String string = "not implemented";
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void bound(Function1<? super CubemapGL3, Unit> f) {
        GL33C.glActiveTexture(33984);
        int current = GL33C.glGetInteger(34068);
        GL33C.glBindTexture(34067, this.texture);
        f.invoke(this);
        GL33C.glBindTexture(34067, current);
    }

    public final int getTexture() {
        return this.texture;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @NotNull
    public final List<ColorBuffer> getSides() {
        return this.sides;
    }

    public CubemapGL3(int texture, int width, @NotNull List<? extends ColorBuffer> sides) {
        Intrinsics.checkParameterIsNotNull(sides, "sides");
        this.texture = texture;
        this.width = width;
        this.sides = sides;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/internal/gl3/CubemapGL3$Companion;", "", "()V", "create", "Lorg/openrndr/internal/gl3/CubemapGL3;", "width", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "fromUrl", "url", "", "fromUrls", "urls", "", "openrndr-gl3"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CubemapGL3 create(int width, @NotNull ColorFormat format, @NotNull ColorType type) {
            Intrinsics.checkParameterIsNotNull((Object)format, "format");
            Intrinsics.checkParameterIsNotNull((Object)type, "type");
            int[] textures = new int[1];
            GL33C.glGenTextures(textures);
            GL33C.glActiveTexture(33984);
            GL33C.glBindTexture(34067, textures[0]);
            int effectiveWidth = width;
            int effectiveHeight = width;
            int internalFormat = ColorBufferGL3Kt.internalFormat(format, type);
            List sides = new ArrayList();
            int n = 0;
            int n2 = 5;
            while (n <= n2) {
                void i;
                ByteBuffer nullBB = null;
                GL33C.glTexImage2D(34069 + i, 0, internalFormat, effectiveWidth, effectiveHeight, 0, ColorBufferGL3Kt.glFormat(format), ColorBufferGL3Kt.glType(type), nullBB);
                sides.add(new ColorBufferGL3(34069 + i, textures[0], width, width, 1.0, format, type, BufferMultisample.Disabled.INSTANCE));
                ++i;
            }
            return new CubemapGL3(textures[0], width, sides);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CubemapGL3 fromUrl(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull(url, "url");
            GL33C.glEnable(34895);
            if (StringsKt.endsWith$default(url, ".dds", false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv22;
                int[] textures = new int[1];
                GL33C.glGenTextures(textures);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                GL33C.glActiveTexture(33984);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                GL33C.glBindTexture(34067, textures[0]);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                InputStream inputStream = new URL(url).openStream();
                Intrinsics.checkExpressionValueIsNotNull(inputStream, "URL(url).openStream()");
                DDSData data = DDSReaderKt.loadDDS(inputStream);
                int n = 0;
                Iterable iterable = $receiver$iv22 = (Iterable)new IntRange(n, 5);
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv22, 10));
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    ColorBufferGL3 colorBufferGL3 = new ColorBufferGL3(34069 + it, textures[0], data.getWidth(), data.getHeight(), 1.0, ColorFormat.RGB, ColorType.UINT8, BufferMultisample.Disabled.INSTANCE);
                    collection.add(colorBufferGL3);
                }
                List sides = (List)destination$iv$iv;
                int $receiver$iv22 = 0;
                int n3 = data.getMipmaps();
                while ($receiver$iv22 < n3) {
                    int format;
                    void level;
                    double m2 = Math.pow(2.0, (double)(-level) * 1.0);
                    int width = (int)((double)data.getWidth() * m2);
                    int height = (int)((double)data.getHeight() * m2);
                    ByteBuffer byteBuffer = data.sidePX((int)level);
                    if (byteBuffer == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer).rewind();
                    ByteBuffer byteBuffer2 = data.sideNX((int)level);
                    if (byteBuffer2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer2).rewind();
                    ByteBuffer byteBuffer3 = data.sidePY((int)level);
                    if (byteBuffer3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer3).rewind();
                    ByteBuffer byteBuffer4 = data.sideNY((int)level);
                    if (byteBuffer4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer4).rewind();
                    ByteBuffer byteBuffer5 = data.sidePZ((int)level);
                    if (byteBuffer5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer5).rewind();
                    ByteBuffer byteBuffer6 = data.sideNZ((int)level);
                    if (byteBuffer6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer6).rewind();
                    if (data.getType() == ColorType.DXT1 || data.getType() == ColorType.DXT3 || data.getType() == ColorType.DXT5) {
                        format = ColorBufferGL3Kt.internalFormat(data.getFormat(), data.getType());
                        GL33C.glCompressedTexImage2D(34069, (int)level, format, data.getWidth(), data.getHeight(), 0, data.sidePX((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glCompressedTexImage2D(34070, (int)level, format, data.getWidth(), data.getHeight(), 0, data.sideNX((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glCompressedTexImage2D(34071, (int)level, format, data.getWidth(), data.getHeight(), 0, data.sidePY((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glCompressedTexImage2D(34072, (int)level, format, data.getWidth(), data.getHeight(), 0, data.sideNY((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glCompressedTexImage2D(34073, (int)level, format, data.getWidth(), data.getHeight(), 0, data.sidePZ((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glCompressedTexImage2D(34074, (int)level, format, data.getWidth(), data.getHeight(), 0, data.sideNZ((int)level));
                    } else {
                        format = ColorBufferGL3Kt.glFormat(data.getFormat());
                        int type = ColorBufferGL3Kt.glType(data.getType());
                        int internalFormat = ColorBufferGL3Kt.internalFormat(data.getFormat(), data.getType());
                        GL33C.glTexImage2D(34069, (int)level, internalFormat, width, height, 0, format, type, data.sidePX((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glTexImage2D(34070, (int)level, internalFormat, width, height, 0, format, type, data.sideNX((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glTexImage2D(34071, (int)level, internalFormat, width, height, 0, format, type, data.sidePY((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glTexImage2D(34072, (int)level, internalFormat, width, height, 0, format, type, data.sideNY((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glTexImage2D(34073, (int)level, internalFormat, width, height, 0, format, type, data.sidePZ((int)level));
                        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                        GL33C.glTexImage2D(34074, (int)level, internalFormat, width, height, 0, format, type, data.sideNZ((int)level));
                    }
                    ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                    ++level;
                }
                if (data.getMipmaps() == 1) {
                    GL33C.glGenerateMipmap(34067);
                    ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                }
                return new CubemapGL3(textures[0], data.getWidth(), sides);
            }
            throw (Throwable)new RuntimeException("only dds files can be loaded through a single url");
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CubemapGL3 fromUrls(@NotNull List<String> urls) {
            Intrinsics.checkParameterIsNotNull(urls, "urls");
            if (urls.size() != 6) {
                throw (Throwable)new RuntimeException("6 urls are needed for a cubemap");
            }
            int[] textures = new int[1];
            GL33C.glGenTextures(textures);
            GL33C.glActiveTexture(33984);
            GL33C.glBindTexture(34067, textures[0]);
            List sides = new ArrayList();
            Iterable $receiver$iv = urls;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void it;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                String string = (String)item$iv;
                int index = n2;
                ColorBufferDataGL3 data = ColorBufferDataGL3.Companion.fromUrl((String)it);
                int internalFormat = ColorBufferGL3Kt.internalFormat(data.getFormat(), data.getType());
                ByteBuffer nullBB = null;
                GL33C.glTexImage2D(34069 + index, 0, internalFormat, data.getWidth(), data.getHeight(), 0, ColorBufferGL3Kt.glFormat(data.getFormat()), ColorBufferGL3Kt.glType(data.getType()), nullBB);
                sides.add(new ColorBufferGL3(34069 + index, textures[0], data.getWidth(), data.getWidth(), 1.0, data.getFormat(), data.getType(), BufferMultisample.Disabled.INSTANCE));
            }
            return new CubemapGL3(textures[0], ((ColorBufferGL3)sides.get(0)).getWidth(), sides);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

