/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Shader;
import org.openrndr.draw.UniformBlock;
import org.openrndr.draw.UniformBlockLayout;
import org.openrndr.draw.UniformDescription;
import org.openrndr.draw.UniformType;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.FragmentShaderGL3;
import org.openrndr.internal.gl3.ShaderGL3;
import org.openrndr.internal.gl3.ShaderGL3Kt;
import org.openrndr.internal.gl3.UniformBlockGL3;
import org.openrndr.internal.gl3.VertexShaderGL3;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\u00020\u0001:\u0001?B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0005J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0005H\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010(\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J#\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016\u00a2\u0006\u0002\u0010/J#\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u0002000-H\u0016\u00a2\u0006\u0002\u00101J#\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u0002020-H\u0016\u00a2\u0006\u0002\u00103J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0018H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u000204H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u000205H\u0016J \u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000205H\u0016J(\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u0002052\u0006\u00108\u001a\u000205H\u0016J0\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u0002052\u0006\u00108\u001a\u0002052\u0006\u00109\u001a\u000205H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020:H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020;H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020<H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020.H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u000200H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u000202H\u0016J\u0018\u0010=\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00052\b\b\u0002\u0010>\u001a\u00020\u0018R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u000ej\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0003`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006@"}, d2={"Lorg/openrndr/internal/gl3/ShaderGL3;", "Lorg/openrndr/draw/Shader;", "program", "", "name", "", "vertexShader", "Lorg/openrndr/internal/gl3/VertexShaderGL3;", "fragmentShader", "Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "(ILjava/lang/String;Lorg/openrndr/internal/gl3/VertexShaderGL3;Lorg/openrndr/internal/gl3/FragmentShaderGL3;)V", "attributes", "", "blockBindings", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "blocks", "getFragmentShader", "()Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "getName", "()Ljava/lang/String;", "getProgram", "()I", "running", "", "uniforms", "getVertexShader", "()Lorg/openrndr/internal/gl3/VertexShaderGL3;", "attributeIndex", "begin", "", "block", "blockName", "Lorg/openrndr/draw/UniformBlock;", "blockIndex", "blockLayout", "Lorg/openrndr/draw/UniformBlockLayout;", "createBlock", "end", "hasUniform", "postUniformCheck", "index", "value", "", "uniform", "", "Lorg/openrndr/math/Vector2;", "(Ljava/lang/String;[Lorg/openrndr/math/Vector2;)V", "Lorg/openrndr/math/Vector3;", "(Ljava/lang/String;[Lorg/openrndr/math/Vector3;)V", "Lorg/openrndr/math/Vector4;", "(Ljava/lang/String;[Lorg/openrndr/math/Vector4;)V", "", "", "x", "y", "z", "w", "", "Lorg/openrndr/color/ColorRGBa;", "Lorg/openrndr/math/Matrix44;", "uniformIndex", "query", "Companion", "openrndr-gl3"})
public final class ShaderGL3
implements Shader {
    private boolean running;
    private Map<String, Integer> uniforms;
    private Map<String, Integer> attributes;
    private HashMap<String, Integer> blockBindings;
    private final Map<String, Integer> blocks;
    private final int program;
    @NotNull
    private final String name;
    @NotNull
    private final VertexShaderGL3 vertexShader;
    @NotNull
    private final FragmentShaderGL3 fragmentShader;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public UniformBlock createBlock(@NotNull String blockName) {
        Intrinsics.checkParameterIsNotNull(blockName, "blockName");
        UniformBlockLayout layout = this.blockLayout(blockName);
        if (layout != null) {
            return UniformBlockGL3.Companion.create(layout);
        }
        throw (Throwable)new RuntimeException("block does not exists " + blockName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public UniformBlockLayout blockLayout(@NotNull String blockName) {
        ShaderGL3 shaderGL3;
        Intrinsics.checkParameterIsNotNull(blockName, "blockName");
        int blockIndex = GL33C.glGetUniformBlockIndex(this.program, blockName);
        if (blockIndex == -1) {
            return null;
        }
        ShaderGL3 $receiver = shaderGL3 = this;
        IntBuffer blockSizeBuffer = BufferUtils.createIntBuffer(1);
        GL33C.glGetActiveUniformBlockiv($receiver.program, blockIndex, 35392, blockSizeBuffer);
        int blockSize = blockSizeBuffer.get(0);
        if (blockSize != 0) {
            void $receiver$iv$iv;
            Object object;
            int n;
            Object $receiver$iv$iv2;
            ShaderGL3 $receiver2 = $receiver = this;
            Object uniformCountBuffer = BufferUtils.createIntBuffer(1);
            GL33C.glGetActiveUniformBlockiv($receiver2.program, blockIndex, 35394, (IntBuffer)uniformCountBuffer);
            int uniformCount = ((IntBuffer)uniformCountBuffer).get(0);
            IntBuffer uniformIndicesBuffer = BufferUtils.createIntBuffer(uniformCount);
            uniformCountBuffer = this;
            ShaderGL3 $receiver3 = (ShaderGL3)uniformCountBuffer;
            GL33C.glGetActiveUniformBlockiv($receiver3.program, blockIndex, 35395, uniformIndicesBuffer);
            IntBuffer intBuffer = uniformIndicesBuffer;
            if (intBuffer == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)intBuffer).rewind();
            int[] array = new int[uniformCount];
            uniformIndicesBuffer.get(array);
            int[] uniformIndices = array;
            ((Buffer)uniformIndicesBuffer).rewind();
            ShaderGL3 $receiver4 = $receiver3 = this;
            IntBuffer buffer = BufferUtils.createIntBuffer(uniformCount);
            GL33C.glGetActiveUniformsiv($receiver4.program, uniformIndicesBuffer, 35383, buffer);
            IntBuffer intBuffer2 = buffer;
            if (intBuffer2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)intBuffer2).rewind();
            int[] array2 = new int[uniformCount];
            buffer.get(array2);
            int[] uniformTypes = array2;
            ShaderGL3 $receiver5 = $receiver4 = this;
            IntBuffer buffer2 = BufferUtils.createIntBuffer(uniformCount);
            GL33C.glGetActiveUniformsiv($receiver5.program, uniformIndicesBuffer, 35384, buffer2);
            IntBuffer intBuffer3 = buffer2;
            if (intBuffer3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)intBuffer3).rewind();
            int[] array3 = new int[uniformCount];
            buffer2.get(array3);
            int[] uniformSizes = array3;
            ShaderGL3 $receiver6 = $receiver5 = this;
            IntBuffer buffer3 = BufferUtils.createIntBuffer(uniformCount);
            GL33C.glGetActiveUniformsiv($receiver6.program, uniformIndicesBuffer, 35387, buffer3);
            IntBuffer intBuffer4 = buffer3;
            if (intBuffer4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)intBuffer4).rewind();
            int[] array4 = new int[uniformCount];
            buffer3.get(array4);
            int[] uniformOffsets = array4;
            ShaderGL3 $receiver7 = $receiver6 = this;
            Object buffer4 = BufferUtils.createIntBuffer(uniformCount);
            GL33C.glGetActiveUniformsiv($receiver7.program, uniformIndicesBuffer, 35388, (IntBuffer)buffer4);
            IntBuffer intBuffer5 = buffer4;
            if (intBuffer5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)intBuffer5).rewind();
            int[] array5 = new int[uniformCount];
            ((IntBuffer)buffer4).get(array5);
            int[] uniformStrides = array5;
            Object $receiver$iv = uniformIndices;
            buffer4 = $receiver$iv;
            Object destination$iv$iv = new ArrayList(((int[])$receiver$iv).length);
            Iterator $i$a$1$run = $receiver$iv$iv2;
            int n2 = ((void)$i$a$1$run).length;
            for (n = 0; n < n2; ++n) {
                void it2;
                void item$iv$iv;
                void var19_25 = item$iv$iv = $i$a$1$run[n];
                Collection collection = destination$iv$iv;
                String string = GL33C.glGetActiveUniformName(this.program, (int)it2, 128);
                collection.add(string);
            }
            List uniformNames = (List)destination$iv$iv;
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            $receiver$iv = RangesKt.until(0, uniformCount);
            int n3 = blockSize;
            $receiver$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            $i$a$1$run = $receiver$iv$iv2.iterator();
            while ($i$a$1$run.hasNext()) {
                void it;
                int item$iv$iv;
                n = item$iv$iv = ((IntIterator)$i$a$1$run).nextInt();
                object = destination$iv$iv;
                Object e = uniformNames.get((int)it);
                Intrinsics.checkExpressionValueIsNotNull(e, "uniformNames[it]");
                CharSequence charSequence = (CharSequence)e;
                Regex it2 = new Regex("\\[.*\\]");
                String $i$a$1$map = "";
                String string = it2.replace(charSequence, $i$a$1$map);
                int n4 = uniformStrides[it];
                int n5 = uniformOffsets[it];
                int n6 = uniformSizes[it];
                UniformType uniformType = ShaderGL3Kt.access$toUniformType(uniformTypes[it]);
                String string2 = string;
                UniformDescription uniformDescription = new UniformDescription(string2, uniformType, n6, n5, n4);
                object.add(uniformDescription);
            }
            object = (List)destination$iv$iv;
            $receiver$iv = (Iterable)object;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
            destination$iv$iv = $receiver$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                Map map2 = destination$iv$iv2;
                UniformDescription it = (UniformDescription)element$iv$iv;
                Pair<String, UniformDescription> pair = new Pair<String, UniformDescription>(it.getName(), it);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Object object2 = object = destination$iv$iv2;
            int n7 = n3;
            return new UniformBlockLayout(n7, (Map<String, UniformDescription>)object2);
        }
        return null;
    }

    @Override
    public void block(@NotNull String blockName, @NotNull UniformBlock block) {
        Intrinsics.checkParameterIsNotNull(blockName, "blockName");
        Intrinsics.checkParameterIsNotNull(block, "block");
        if (Intrinsics.areEqual(Thread.currentThread(), ((UniformBlockGL3)block).getThread$openrndr_gl3()) ^ true) {
            throw (Throwable)new IllegalStateException("block is created on " + ((UniformBlockGL3)block).getThread$openrndr_gl3() + " and is now used on " + Thread.currentThread());
        }
        if (!this.running) {
            throw (Throwable)new IllegalStateException("use begin() before setting blocks");
        }
        int blockIndex = this.blockIndex(blockName);
        if (blockIndex == -1) {
            throw (Throwable)new IllegalArgumentException("block not found " + blockName);
        }
        Integer n = this.blockBindings.get(blockName);
        int n2 = ((UniformBlockGL3)block).getBlockBinding();
        if (n == null || n != n2) {
            GL33C.glUniformBlockBinding(this.program, blockIndex, ((UniformBlockGL3)block).getBlockBinding());
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            Map map2 = this.blockBindings;
            Integer n3 = ((UniformBlockGL3)block).getBlockBinding();
            map2.put(blockName, n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int blockIndex(@NotNull String block) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(block, "block");
        Map<String, Integer> $receiver$iv = this.blocks;
        Integer value$iv = $receiver$iv.get(block);
        if (value$iv == null) {
            Integer answer$iv = GL33C.glGetUniformBlockIndex(this.program, block);
            $receiver$iv.put(block, answer$iv);
            n = answer$iv;
        } else {
            void var3_3;
            n = var3_3;
        }
        return ((Number)n).intValue();
    }

    public final int uniformIndex(@NotNull String uniform2, boolean query) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(uniform2, "uniform");
        Map<String, Integer> $receiver$iv = this.uniforms;
        Integer value$iv = $receiver$iv.get(uniform2);
        if (value$iv == null) {
            int location = GL33C.glGetUniformLocation(this.program, uniform2);
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            if (location == -1 && !query) {
                ShaderGL3Kt.access$getLogger$p().warn((Function0<? extends Object>)new Function0<String>(this, uniform2, query){
                    final /* synthetic */ ShaderGL3 this$0;
                    final /* synthetic */ String $uniform$inlined;
                    final /* synthetic */ boolean $query$inlined;
                    {
                        this.this$0 = shaderGL3;
                        this.$uniform$inlined = string;
                        this.$query$inlined = bl;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "shader " + this.this$0.getName() + " does not have uniform " + this.$uniform$inlined;
                    }
                });
            }
            Integer answer$iv = location;
            $receiver$iv.put(uniform2, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    public static /* synthetic */ int uniformIndex$default(ShaderGL3 shaderGL3, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return shaderGL3.uniformIndex(string, bl);
    }

    @Override
    public void begin() {
        ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ ShaderGL3 this$0;

            @NotNull
            public final String invoke() {
                return "shader begin " + this.this$0.getName();
            }
            {
                this.this$0 = shaderGL3;
                super(0);
            }
        });
        this.running = true;
        GL33C.glUseProgram(this.program);
        ErrorGL3Kt.debugGLErrors((Function1<? super Integer, String>)new Function1<Integer, String>(this){
            final /* synthetic */ ShaderGL3 this$0;

            @Nullable
            public final String invoke(int it) {
                String string;
                switch (it) {
                    case 1281: {
                        string = "program is neither 0 nor a value generated by OpenGL";
                        break;
                    }
                    case 1282: {
                        string = "program (" + this.this$0.getProgram() + ") is not a program object / program could not be made part of current state / transform feedback mode is active.";
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                return string;
            }
            {
                this.this$0 = shaderGL3;
                super(1);
            }
        });
    }

    @Override
    public void end() {
        ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ ShaderGL3 this$0;

            @NotNull
            public final String invoke() {
                return "shader end " + this.this$0.getName();
            }
            {
                this.this$0 = shaderGL3;
                super(0);
            }
        });
        GL33C.glUseProgram(0);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
        this.running = false;
    }

    @Override
    public boolean hasUniform(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.uniformIndex(name, true) != -1;
    }

    @Override
    public void uniform(@NotNull String name, @NotNull ColorRGBa value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform4f(index, (float)value2.getR(), (float)value2.getG(), (float)value2.getB(), (float)value2.getA());
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector3 value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform3f(index, (float)value2.getX(), (float)value2.getY(), (float)value2.getZ());
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector4 value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform4f(index, (float)value2.getX(), (float)value2.getY(), (float)value2.getZ(), (float)value2.getW());
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, float x, float y, float z, float w) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform4f(index, x, y, z, w);
        }
    }

    @Override
    public void uniform(@NotNull String name, float x, float y, float z) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform3f(index, x, y, z);
        }
    }

    @Override
    public void uniform(@NotNull String name, float x, float y) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform2f(index, x, y);
        }
    }

    @Override
    public void uniform(@NotNull String name, int value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform1i(index, value2);
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, boolean value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform1i(index, value2 ? 1 : 0);
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector2 value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform2f(index, (float)value2.getX(), (float)value2.getY());
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, float value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform1f(index, value2);
            this.postUniformCheck(name, index, Float.valueOf(value2));
        }
    }

    @Override
    public void uniform(@NotNull String name, double value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            GL33C.glUniform1f(index, (float)value2);
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix44 value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(name, value2){
                final /* synthetic */ String $name;
                final /* synthetic */ Matrix44 $value;

                @NotNull
                public final String invoke() {
                    return "Setting uniform '" + this.$name + "' to " + this.$value;
                }
                {
                    this.$name = string;
                    this.$value = matrix44;
                    super(0);
                }
            });
            GL33C.glUniformMatrix4fv(index, false, DriverGL3Kt.toFloatArray(value2));
            this.postUniformCheck(name, index, value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull String name, @NotNull Vector2[] value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(name, value2){
                final /* synthetic */ String $name;
                final /* synthetic */ Vector2[] $value;

                @NotNull
                public final String invoke() {
                    return "Setting uniform '" + this.$name + "' to " + this.$value;
                }
                {
                    this.$name = string;
                    this.$value = vector2Array;
                    super(0);
                }
            });
            float[] floatValues = new float[value2.length * 2];
            int n = 0;
            int n2 = value2.length;
            while (n < n2) {
                void i;
                floatValues[i * 2] = (float)value2[i].getX();
                floatValues[i * 2 + true] = (float)value2[i].getY();
                ++i;
            }
            GL33C.glUniform2fv(index, floatValues);
            this.postUniformCheck(name, index, value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull String name, @NotNull Vector3[] value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(name, value2){
                final /* synthetic */ String $name;
                final /* synthetic */ Vector3[] $value;

                @NotNull
                public final String invoke() {
                    return "Setting uniform '" + this.$name + "' to " + this.$value;
                }
                {
                    this.$name = string;
                    this.$value = vector3Array;
                    super(0);
                }
            });
            float[] floatValues = new float[value2.length * 3];
            int n = 0;
            int n2 = value2.length;
            while (n < n2) {
                void i;
                floatValues[i * 3] = (float)value2[i].getX();
                floatValues[i * 3 + true] = (float)value2[i].getY();
                floatValues[i * 3 + 2] = (float)value2[i].getZ();
                ++i;
            }
            GL33C.glUniform3fv(index, floatValues);
            this.postUniformCheck(name, index, value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull String name, @NotNull Vector4[] value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(name, value2){
                final /* synthetic */ String $name;
                final /* synthetic */ Vector4[] $value;

                @NotNull
                public final String invoke() {
                    return "Setting uniform '" + this.$name + "' to " + this.$value;
                }
                {
                    this.$name = string;
                    this.$value = vector4Array;
                    super(0);
                }
            });
            float[] floatValues = new float[value2.length * 4];
            int n = 0;
            int n2 = value2.length;
            while (n < n2) {
                void i;
                floatValues[i * 4] = (float)value2[i].getX();
                floatValues[i * 4 + true] = (float)value2[i].getY();
                floatValues[i * 4 + 2] = (float)value2[i].getZ();
                floatValues[i * 4 + 3] = (float)value2[i].getW();
                ++i;
            }
            GL33C.glUniform4fv(index, floatValues);
            this.postUniformCheck(name, index, value2);
        }
    }

    @Override
    public void uniform(@NotNull String name, @NotNull float[] value2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        int index = ShaderGL3.uniformIndex$default(this, name, false, 2, null);
        if (index != -1) {
            ShaderGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(name, value2){
                final /* synthetic */ String $name;
                final /* synthetic */ float[] $value;

                @NotNull
                public final String invoke() {
                    return "Setting uniform '" + this.$name + "' to " + this.$value;
                }
                {
                    this.$name = string;
                    this.$value = fArray;
                    super(0);
                }
            });
            GL33C.glUniform1fv(index, value2);
            this.postUniformCheck(name, index, value2);
        }
    }

    private final void postUniformCheck(String name, int index, Object value2) {
        ErrorGL3Kt.debugGLErrors((Function1<? super Integer, String>)new Function1<Integer, String>(index, name){
            final /* synthetic */ int $index;
            final /* synthetic */ String $name;

            @Nullable
            public final String invoke(int it) {
                String string;
                int currentProgram = GL33C.glGetInteger(35725);
                Function0<String> checkUniform$ = new Function0<String>(this, currentProgram){
                    final /* synthetic */ postUniformCheck.1 this$0;
                    final /* synthetic */ int $currentProgram;

                    @NotNull
                    public final String invoke() {
                        if (this.$currentProgram > 0) {
                            IntBuffer lengthBuffer = BufferUtils.createIntBuffer(1);
                            IntBuffer sizeBuffer = BufferUtils.createIntBuffer(1);
                            IntBuffer typeBuffer = BufferUtils.createIntBuffer(1);
                            ByteBuffer nameBuffer = BufferUtils.createByteBuffer(256);
                            GL33C.glGetActiveUniform(this.$currentProgram, this.this$0.$index, lengthBuffer, sizeBuffer, typeBuffer, nameBuffer);
                            byte[] nameBytes = new byte[lengthBuffer.get(0)];
                            ByteBuffer byteBuffer = nameBuffer;
                            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "nameBuffer");
                            ShaderGL3Kt.access$safeRewind(byteBuffer);
                            nameBuffer.get(nameBytes);
                            String retrievedName = new String(nameBytes, Charsets.UTF_8);
                            return '(' + this.this$0.$name + '/' + retrievedName + "): " + sizeBuffer.get(0) + " / " + typeBuffer.get(0) + '}';
                        }
                        return "no program";
                    }
                    {
                        this.this$0 = var1_1;
                        this.$currentProgram = n;
                        super(0);
                    }
                };
                switch (it) {
                    case 1282: {
                        string = "no current program object (" + currentProgram + "), or uniform type mismatch (" + (String)checkUniform$.invoke();
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                return string;
            }
            {
                this.$index = n;
                this.$name = string;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final int attributeIndex(@NotNull String name) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Map<String, Integer> $receiver$iv = this.attributes;
        Integer value$iv = $receiver$iv.get(name);
        if (value$iv == null) {
            int location = GL33C.glGetAttribLocation(this.program, name);
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            Integer answer$iv = location;
            $receiver$iv.put(name, answer$iv);
            n = answer$iv;
        } else {
            void var3_3;
            n = var3_3;
        }
        return ((Number)n).intValue();
    }

    public final int getProgram() {
        return this.program;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final VertexShaderGL3 getVertexShader() {
        return this.vertexShader;
    }

    @NotNull
    public final FragmentShaderGL3 getFragmentShader() {
        return this.fragmentShader;
    }

    public ShaderGL3(int program2, @NotNull String name, @NotNull VertexShaderGL3 vertexShader, @NotNull FragmentShaderGL3 fragmentShader) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(vertexShader, "vertexShader");
        Intrinsics.checkParameterIsNotNull(fragmentShader, "fragmentShader");
        this.program = program2;
        this.name = name;
        this.vertexShader = vertexShader;
        this.fragmentShader = fragmentShader;
        ShaderGL3 shaderGL3 = this;
        HashMap hashMap = new HashMap();
        shaderGL3.uniforms = hashMap;
        shaderGL3 = this;
        hashMap = new HashMap();
        shaderGL3.attributes = hashMap;
        shaderGL3 = this;
        hashMap = new HashMap();
        shaderGL3.blockBindings = hashMap;
        shaderGL3 = this;
        hashMap = new HashMap();
        shaderGL3.blocks = hashMap;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/internal/gl3/ShaderGL3$Companion;", "", "()V", "create", "Lorg/openrndr/internal/gl3/ShaderGL3;", "vertexShader", "Lorg/openrndr/internal/gl3/VertexShaderGL3;", "fragmentShader", "Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "openrndr-gl3"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ShaderGL3 create(@NotNull VertexShaderGL3 vertexShader, @NotNull FragmentShaderGL3 fragmentShader) {
            Intrinsics.checkParameterIsNotNull(vertexShader, "vertexShader");
            Intrinsics.checkParameterIsNotNull(fragmentShader, "fragmentShader");
            Driver driver = Driver.Companion.getDriver();
            synchronized (driver) {
                ErrorGL3Kt.debugGLErrors$default(null, 1, null);
                String name = vertexShader.getName() + " / " + fragmentShader.getName();
                int program2 = GL33C.glCreateProgram();
                ErrorGL3Kt.debugGLErrors$default(null, 1, null);
                GL33C.glAttachShader(program2, vertexShader.getShaderObject());
                ErrorGL3Kt.debugGLErrors$default(null, 1, null);
                GL33C.glAttachShader(program2, fragmentShader.getShaderObject());
                ErrorGL3Kt.debugGLErrors$default(null, 1, null);
                GL33C.glLinkProgram(program2);
                ErrorGL3Kt.debugGLErrors$default(null, 1, null);
                int[] linkStatus = new int[1];
                GL33C.glGetProgramiv(program2, 35714, linkStatus);
                ErrorGL3Kt.debugGLErrors$default(null, 1, null);
                if (linkStatus[0] != 1) {
                    ShaderGL3Kt.checkProgramInfoLog(program2, "noname");
                }
                GL33C.glFinish();
                ShaderGL3 shaderGL3 = new ShaderGL3(program2, name, vertexShader, fragmentShader);
                return shaderGL3;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

