/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.demosystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.rndr.demosystem.Task;
import studio.rndr.demosystem.TaskBuilder;
import studio.rndr.demosystem.TaskContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0003J\u0006\u0010+\u001a\u00020(J\u0006\u0010,\u001a\u00020(J\u0006\u0010-\u001a\u00020(J\u0006\u0010.\u001a\u00020(J1\u0010\u0015\u001a\u00020(2\u0006\u0010/\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u00020\u00032\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020(02\u00a2\u0006\u0002\b4J\u000e\u00105\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0003R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0004R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0015\u0010 \u001a\u00020\u0003*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0015\u0010 \u001a\u00020\u0003*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010$R\u0015\u0010%\u001a\u00020\u0003*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0015\u0010%\u001a\u00020\u0003*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u00066"}, d2={"Lstudio/rndr/demosystem/Scheduler;", "", "bpm", "", "(D)V", "activeTasks", "", "Lstudio/rndr/demosystem/Task;", "getActiveTasks", "()Ljava/util/Set;", "setActiveTasks", "(Ljava/util/Set;)V", "getBpm", "()D", "cursorStack", "Ljava/util/Stack;", "getCursorStack", "()Ljava/util/Stack;", "startCursor", "getStartCursor", "setStartCursor", "task", "getTask", "()Lstudio/rndr/demosystem/Task;", "setTask", "(Lstudio/rndr/demosystem/Task;)V", "taskStack", "getTaskStack", "tasks", "", "getTasks", "()Ljava/util/List;", "bars", "getBars", "(D)D", "", "(I)D", "beats", "getBeats", "complete", "", "delay", "time", "popCursor", "popTask", "pushCursor", "pushTask", "duration", "offset", "builder", "Lkotlin/Function1;", "Lstudio/rndr/demosystem/TaskBuilder;", "Lkotlin/ExtensionFunctionType;", "update", "demo-silo"})
public final class Scheduler {
    @NotNull
    private final List<Task> tasks;
    @NotNull
    private Set<Task> activeTasks;
    private double startCursor;
    @Nullable
    private Task task;
    @NotNull
    private final Stack<Double> cursorStack;
    @NotNull
    private final Stack<Task> taskStack;
    private final double bpm;

    public final double getBeats(double $receiver) {
        return $receiver / (this.bpm / 60.0);
    }

    public final double getBeats(int $receiver) {
        return (double)$receiver / (this.bpm / 60.0);
    }

    public final double getBars(double $receiver) {
        return 4.0 * $receiver / (this.bpm / 60.0);
    }

    public final double getBars(int $receiver) {
        return 4.0 * (double)$receiver / (this.bpm / 60.0);
    }

    @NotNull
    public final List<Task> getTasks() {
        return this.tasks;
    }

    @NotNull
    public final Set<Task> getActiveTasks() {
        return this.activeTasks;
    }

    public final void setActiveTasks(@NotNull Set<Task> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.activeTasks = set;
    }

    public final double getStartCursor() {
        return this.startCursor;
    }

    public final void setStartCursor(double d) {
        this.startCursor = d;
    }

    @Nullable
    public final Task getTask() {
        return this.task;
    }

    public final void setTask(@Nullable Task task) {
        this.task = task;
    }

    @NotNull
    public final Stack<Double> getCursorStack() {
        return this.cursorStack;
    }

    @NotNull
    public final Stack<Task> getTaskStack() {
        return this.taskStack;
    }

    public final void pushCursor() {
        this.cursorStack.push(this.startCursor);
    }

    public final void popCursor() {
        Double d = this.cursorStack.pop();
        Intrinsics.checkExpressionValueIsNotNull(d, "cursorStack.pop()");
        this.startCursor = ((Number)d).doubleValue();
    }

    public final void pushTask() {
        this.taskStack.push(this.task);
    }

    public final void popTask() {
        this.task = this.taskStack.pop();
    }

    public final void task(double duration, double offset2, @NotNull Function1<? super TaskBuilder, Unit> builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        TaskBuilder tb = new TaskBuilder();
        builder.invoke(tb);
        this.tasks.add(new Task(this.startCursor + offset2, offset2 + this.startCursor + duration, tb.getDrawTask()));
        this.task = CollectionsKt.last(this.tasks);
        this.complete();
    }

    public static /* synthetic */ void task$default(Scheduler scheduler2, double d, double d2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        scheduler2.task(d, d2, function1);
    }

    public final void complete() {
        Task task = this.task;
        if (task == null) {
            Intrinsics.throwNpe();
        }
        this.startCursor = task.getEnd();
    }

    public final void update(double time) {
        Task it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.tasks;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Task)element$iv$iv;
            if (!(it.getStart() <= time && time < it.getEnd())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List timeStepTasks = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)timeStepTasks;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Task)element$iv$iv;
            if (!(it.getStart() <= time && time < it.getEnd())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Task it2 = (Task)element$iv;
            it2.getTask().invoke(new TaskContext(this, time - it2.getStart(), time, it2.getEnd() - it2.getStart(), !this.activeTasks.contains(it2)));
        }
        this.activeTasks = CollectionsKt.toSet(timeStepTasks);
    }

    public final void delay(double time) {
        this.startCursor += time;
    }

    public final double getBpm() {
        return this.bpm;
    }

    public Scheduler(double bpm) {
        Collection<Object> collection;
        this.bpm = bpm;
        Scheduler scheduler2 = this;
        scheduler2.tasks = collection = (List)new ArrayList();
        scheduler2 = this;
        collection = SetsKt.emptySet();
        scheduler2.activeTasks = collection;
        this.cursorStack = new Stack();
        this.taskStack = new Stack();
    }
}

