/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct GLFWgamepadstate")
public class GLFWGamepadState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUTTONS;
    public static final int AXES;

    GLFWGamepadState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public GLFWGamepadState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), GLFWGamepadState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[15]")
    public ByteBuffer buttons() {
        return GLFWGamepadState.nbuttons(this.address());
    }

    @NativeType(value="unsigned char")
    public byte buttons(int index) {
        return GLFWGamepadState.nbuttons(this.address(), index);
    }

    @NativeType(value="float[6]")
    public FloatBuffer axes() {
        return GLFWGamepadState.naxes(this.address());
    }

    public float axes(int index) {
        return GLFWGamepadState.naxes(this.address(), index);
    }

    public GLFWGamepadState buttons(@NativeType(value="unsigned char[15]") ByteBuffer value) {
        GLFWGamepadState.nbuttons(this.address(), value);
        return this;
    }

    public GLFWGamepadState buttons(int index, @NativeType(value="unsigned char") byte value) {
        GLFWGamepadState.nbuttons(this.address(), index, value);
        return this;
    }

    public GLFWGamepadState axes(@NativeType(value="float[6]") FloatBuffer value) {
        GLFWGamepadState.naxes(this.address(), value);
        return this;
    }

    public GLFWGamepadState axes(int index, float value) {
        GLFWGamepadState.naxes(this.address(), index, value);
        return this;
    }

    public GLFWGamepadState set(ByteBuffer buttons, FloatBuffer axes) {
        this.buttons(buttons);
        this.axes(axes);
        return this;
    }

    public GLFWGamepadState set(GLFWGamepadState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static GLFWGamepadState malloc() {
        return GLFWGamepadState.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static GLFWGamepadState calloc() {
        return GLFWGamepadState.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static GLFWGamepadState create() {
        return new GLFWGamepadState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static GLFWGamepadState create(long address) {
        return new GLFWGamepadState(address, null);
    }

    @Nullable
    public static GLFWGamepadState createSafe(long address) {
        return address == 0L ? null : GLFWGamepadState.create(address);
    }

    public static Buffer malloc(int capacity) {
        return GLFWGamepadState.create(GLFWGamepadState.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return GLFWGamepadState.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(GLFWGamepadState.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : GLFWGamepadState.create(address, capacity);
    }

    public static GLFWGamepadState mallocStack() {
        return GLFWGamepadState.mallocStack(MemoryStack.stackGet());
    }

    public static GLFWGamepadState callocStack() {
        return GLFWGamepadState.callocStack(MemoryStack.stackGet());
    }

    public static GLFWGamepadState mallocStack(MemoryStack stack) {
        return GLFWGamepadState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GLFWGamepadState callocStack(MemoryStack stack) {
        return GLFWGamepadState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return GLFWGamepadState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return GLFWGamepadState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return GLFWGamepadState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return GLFWGamepadState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nbuttons(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)BUTTONS, 15);
    }

    public static byte nbuttons(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 15);
        }
        return MemoryUtil.memGetByte(struct + (long)BUTTONS + (long)(index * 1));
    }

    public static FloatBuffer naxes(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)AXES, 6);
    }

    public static float naxes(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        return MemoryUtil.memGetFloat(struct + (long)AXES + (long)(index * 4));
    }

    public static void nbuttons(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)BUTTONS, value.remaining() * 1);
    }

    public static void nbuttons(long struct, int index, byte value) {
        if (Checks.CHECKS) {
            Checks.check(index, 15);
        }
        MemoryUtil.memPutByte(struct + (long)BUTTONS + (long)(index * 1), value);
    }

    public static void naxes(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)AXES, value.remaining() * 4);
    }

    public static void naxes(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        MemoryUtil.memPutFloat(struct + (long)AXES + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = GLFWGamepadState.__struct(GLFWGamepadState.__array(1, 15), GLFWGamepadState.__array(4, 6));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUTTONS = layout.offsetof(0);
        AXES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<GLFWGamepadState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected GLFWGamepadState newInstance(long address) {
            return new GLFWGamepadState(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned char[15]")
        public ByteBuffer buttons() {
            return GLFWGamepadState.nbuttons(this.address());
        }

        @NativeType(value="unsigned char")
        public byte buttons(int index) {
            return GLFWGamepadState.nbuttons(this.address(), index);
        }

        @NativeType(value="float[6]")
        public FloatBuffer axes() {
            return GLFWGamepadState.naxes(this.address());
        }

        public float axes(int index) {
            return GLFWGamepadState.naxes(this.address(), index);
        }

        public Buffer buttons(@NativeType(value="unsigned char[15]") ByteBuffer value) {
            GLFWGamepadState.nbuttons(this.address(), value);
            return this;
        }

        public Buffer buttons(int index, @NativeType(value="unsigned char") byte value) {
            GLFWGamepadState.nbuttons(this.address(), index, value);
            return this;
        }

        public Buffer axes(@NativeType(value="float[6]") FloatBuffer value) {
            GLFWGamepadState.naxes(this.address(), value);
            return this;
        }

        public Buffer axes(int index, float value) {
            GLFWGamepadState.naxes(this.address(), index, value);
            return this;
        }
    }
}

