/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBViewportArray {
    public static final int GL_MAX_VIEWPORTS = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE = 33373;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 33375;
    public static final int GL_UNDEFINED_VERTEX = 33376;

    protected ARBViewportArray() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glViewportArrayv, caps.glViewportIndexedf, caps.glViewportIndexedfv, caps.glScissorArrayv, caps.glScissorIndexed, caps.glScissorIndexedv, caps.glDepthRangeArrayv, caps.glDepthRangeIndexed, caps.glGetFloati_v, caps.glGetDoublei_v);
    }

    public static native void nglViewportArrayv(int var0, int var1, long var2);

    public static void glViewportArrayv(@NativeType(value="GLuint") int first, @NativeType(value="const GLfloat *") FloatBuffer v) {
        ARBViewportArray.nglViewportArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glViewportIndexedf(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4);

    public static native void nglViewportIndexedfv(int var0, long var1);

    public static void glViewportIndexedfv(@NativeType(value="GLuint") int index, @NativeType(value="const GLfloat *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        ARBViewportArray.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglScissorArrayv(int var0, int var1, long var2);

    public static void glScissorArrayv(@NativeType(value="GLuint") int first, @NativeType(value="const GLint *") IntBuffer v) {
        ARBViewportArray.nglScissorArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glScissorIndexed(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLsizei") int var3, @NativeType(value="GLsizei") int var4);

    public static native void nglScissorIndexedv(int var0, long var1);

    public static void glScissorIndexedv(@NativeType(value="GLuint") int index, @NativeType(value="const GLint *") IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        ARBViewportArray.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglDepthRangeArrayv(int var0, int var1, long var2);

    public static void glDepthRangeArrayv(@NativeType(value="GLuint") int first, @NativeType(value="const GLdouble *") DoubleBuffer v) {
        ARBViewportArray.nglDepthRangeArrayv(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void glDepthRangeIndexed(@NativeType(value="GLuint") int var0, @NativeType(value="GLdouble") double var1, @NativeType(value="GLdouble") double var3);

    public static native void nglGetFloati_v(int var0, int var1, long var2);

    public static void glGetFloati_v(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLfloat *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        ARBViewportArray.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetFloati(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            ARBViewportArray.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetDoublei_v(int var0, int var1, long var2);

    public static void glGetDoublei_v(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLdouble *") DoubleBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        ARBViewportArray.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static double glGetDoublei(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            ARBViewportArray.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glViewportArrayv(@NativeType(value="GLuint") int first, @NativeType(value="const GLfloat *") float[] v) {
        long __functionAddress = GL.getICD().glViewportArrayv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 2, v);
    }

    public static void glViewportIndexedfv(@NativeType(value="GLuint") int index, @NativeType(value="const GLfloat *") float[] v) {
        long __functionAddress = GL.getICD().glViewportIndexedfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glScissorArrayv(@NativeType(value="GLuint") int first, @NativeType(value="const GLint *") int[] v) {
        long __functionAddress = GL.getICD().glScissorArrayv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 2, v);
    }

    public static void glScissorIndexedv(@NativeType(value="GLuint") int index, @NativeType(value="const GLint *") int[] v) {
        long __functionAddress = GL.getICD().glScissorIndexedv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glDepthRangeArrayv(@NativeType(value="GLuint") int first, @NativeType(value="const GLdouble *") double[] v) {
        long __functionAddress = GL.getICD().glDepthRangeArrayv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 1, v);
    }

    public static void glGetFloati_v(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLfloat *") float[] data) {
        long __functionAddress = GL.getICD().glGetFloati_v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetDoublei_v(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLdouble *") double[] data) {
        long __functionAddress = GL.getICD().glGetDoublei_v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    static {
        GL.initialize();
    }
}

