/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexFormat;
import org.openrndr.math.Matrix44;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u001a4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a9\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u001d\u001a\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f\u001a\u001f\u0010 \u001a\u00020!2\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u001d\u001a#\u0010#\u001a\u00020\u001c*\u00020$2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u001d\u001a+\u0010&\u001a\u00020\u001c*\u00020$2\u0006\u0010'\u001a\u00020\u00182\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"lastModel", "Lorg/openrndr/math/Matrix44;", "lastModelNormal", "lastView", "lastViewNormal", "codeFromStream", "", "stream", "Ljava/io/InputStream;", "codeFromURL", "url", "Ljava/net/URL;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "width", "", "height", "contentScale", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "builder", "Lkotlin/Function1;", "Lorg/openrndr/draw/RenderTargetBuilder;", "", "Lkotlin/ExtensionFunctionType;", "vertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "isolated", "Lorg/openrndr/draw/Drawer;", "function", "isolatedWithTarget", "target", "openrndr-core"})
public final class DrawerKt {
    private static Matrix44 lastModel = Matrix44.Companion.getIDENTITY();
    private static Matrix44 lastModelNormal = Matrix44.Companion.getIDENTITY();
    private static Matrix44 lastView = Matrix44.Companion.getIDENTITY();
    private static Matrix44 lastViewNormal = Matrix44.Companion.getIDENTITY();

    @NotNull
    public static final VertexFormat vertexFormat(@NotNull Function1<? super VertexFormat, Unit> builder) {
        VertexFormat vertexFormat;
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        VertexFormat $receiver = vertexFormat = new VertexFormat();
        builder.invoke($receiver);
        return vertexFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String codeFromStream(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        Closeable closeable = new BufferedReader(new InputStreamReader(stream));
        Throwable throwable = null;
        try {
            BufferedReader it2 = (BufferedReader)closeable;
            String string = TextStreamsKt.readText(it2);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String codeFromURL(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream it2;
            InputStream inputStream = it2 = (InputStream)closeable;
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "it");
            String string = DrawerKt.codeFromStream(inputStream);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public static final String codeFromURL(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        return DrawerKt.codeFromURL(new URL(url));
    }

    @NotNull
    public static final VertexBuffer vertexBuffer(@NotNull VertexFormat vertexFormat, int vertexCount) {
        Intrinsics.checkParameterIsNotNull(vertexFormat, "vertexFormat");
        return VertexBuffer.Companion.createDynamic(vertexFormat, vertexCount);
    }

    @NotNull
    public static final ColorBuffer colorBuffer(int width, int height, double contentScale, @NotNull ColorFormat format2, @NotNull ColorType type) {
        Intrinsics.checkParameterIsNotNull((Object)format2, "format");
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        return ColorBuffer.Companion.create(width, height, contentScale, format2, type);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorBuffer colorBuffer$default(int n2, int n3, double d, ColorFormat colorFormat, ColorType colorType, int n4, Object object) {
        if ((n4 & 4) != 0) {
            d = 1.0;
        }
        if ((n4 & 8) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n4 & 0x10) != 0) {
            colorType = ColorType.UINT8;
        }
        return DrawerKt.colorBuffer(n2, n3, d, colorFormat, colorType);
    }

    @NotNull
    public static final RenderTarget renderTarget(int width, int height, double contentScale, @NotNull Function1<? super RenderTargetBuilder, Unit> builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        RenderTarget renderTarget = RenderTarget.Companion.create(width, height, contentScale);
        builder.invoke(new RenderTargetBuilder(renderTarget));
        return renderTarget;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ RenderTarget renderTarget$default(int n2, int n3, double d, Function1 function1, int n4, Object object) {
        if ((n4 & 4) != 0) {
            d = 1.0;
        }
        return DrawerKt.renderTarget(n2, n3, d, function1);
    }

    public static final void isolated(@NotNull Drawer $receiver, @NotNull Function1<? super Drawer, Unit> function) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(function, "function");
        $receiver.pushTransforms();
        $receiver.pushStyle();
        function.invoke($receiver);
        $receiver.popStyle();
        $receiver.popTransforms();
    }

    public static final void isolatedWithTarget(@NotNull Drawer $receiver, @NotNull RenderTarget target, @NotNull Function1<? super Drawer, Unit> function) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(function, "function");
        target.bind();
        DrawerKt.isolated($receiver, function);
        target.unbind();
    }

    @NotNull
    public static final /* synthetic */ Matrix44 access$getLastModel$p() {
        return lastModel;
    }

    public static final /* synthetic */ void access$setLastModel$p(@NotNull Matrix44 matrix44) {
        lastModel = matrix44;
    }

    @NotNull
    public static final /* synthetic */ Matrix44 access$getLastModelNormal$p() {
        return lastModelNormal;
    }

    public static final /* synthetic */ void access$setLastModelNormal$p(@NotNull Matrix44 matrix44) {
        lastModelNormal = matrix44;
    }

    @NotNull
    public static final /* synthetic */ Matrix44 access$getLastView$p() {
        return lastView;
    }

    public static final /* synthetic */ void access$setLastView$p(@NotNull Matrix44 matrix44) {
        lastView = matrix44;
    }

    @NotNull
    public static final /* synthetic */ Matrix44 access$getLastViewNormal$p() {
        return lastViewNormal;
    }

    public static final /* synthetic */ void access$setLastViewNormal$p(@NotNull Matrix44 matrix44) {
        lastViewNormal = matrix44;
    }
}

