/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J4\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J2\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/internal/RectangleDrawer;", "", "()V", "instanceAttributes", "Lorg/openrndr/draw/VertexBuffer;", "getInstanceAttributes", "()Lorg/openrndr/draw/VertexBuffer;", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "getShaderManager", "()Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "getVertices", "drawRectangle", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "x", "", "y", "width", "height", "drawRectangles", "count", "", "positions", "", "Lorg/openrndr/math/Vector2;", "dimensions", "openrndr-core"})
public final class RectangleDrawer {
    @NotNull
    private final VertexBuffer vertices;
    @NotNull
    private final VertexBuffer instanceAttributes;
    @NotNull
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    @NotNull
    public final VertexBuffer getInstanceAttributes() {
        return this.instanceAttributes;
    }

    @NotNull
    public final ShadeStyleManager getShaderManager() {
        return this.shaderManager;
    }

    /*
     * WARNING - void declaration
     */
    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, @NotNull List<Vector2> dimensions) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(dimensions, "dimensions");
        BufferWriter $receiver = bufferWriter = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        int n2 = 0;
        int n3 = positions.size();
        while (n2 < n3) {
            void i;
            $receiver.write(dimensions.get((int)i));
            $receiver.write(new Vector3(positions.get((int)i).getX(), positions.get((int)i).getY(), 0.0));
            ++i;
        }
        this.instanceAttributes.getShadow().uploadElements(0, positions.size());
        this.drawRectangles(drawContext, drawStyle, positions.size());
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, double width, double height) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        BufferWriter $receiver = bufferWriter = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        Iterable $receiver$iv = positions;
        for (Object element$iv : $receiver$iv) {
            Vector2 it2 = (Vector2)element$iv;
            $receiver.write((float)width);
            $receiver.write((float)height);
            $receiver.write(new Vector3(it2.getX(), it2.getY(), 0.0));
        }
        this.instanceAttributes.getShadow().uploadElements(0, positions.size());
        this.drawRectangles(drawContext, drawStyle, positions.size());
    }

    public final void drawRectangle(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double width, double height) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        BufferWriter $receiver = bufferWriter = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        $receiver.write((float)width);
        $receiver.write((float)height);
        $receiver.write(new Vector3(x, y, 0.0));
        this.instanceAttributes.getShadow().uploadElements(0, 1);
        this.drawRectangles(drawContext, drawStyle, 1);
    }

    private final void drawRectangles(DrawContext drawContext, DrawStyle drawStyle, int count) {
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(this.instanceAttributes.getVertexFormat()));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.listOf(this.instanceAttributes), DrawPrimitive.TRIANGLES, 0, 6, count);
        shader2.end();
    }

    public RectangleDrawer() {
        BufferWriter bufferWriter;
        VertexFormat vertexFormat = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        RectangleDrawer rectangleDrawer = this;
        VertexFormat $receiver = vertexFormat;
        $receiver.position(3);
        $receiver.normal(3);
        $receiver.textureCoordinate(2);
        VertexFormat vertexFormat2 = vertexFormat;
        rectangleDrawer.vertices = companion.createDynamic(vertexFormat2, 6);
        vertexFormat = new VertexFormat();
        companion = VertexBuffer.Companion;
        rectangleDrawer = this;
        $receiver = vertexFormat;
        $receiver.attribute("dimensions", 2, VertexElementType.FLOAT32);
        $receiver.attribute("offset", 3, VertexElementType.FLOAT32);
        vertexFormat2 = vertexFormat;
        rectangleDrawer.instanceAttributes = companion.createDynamic(vertexFormat2, 10000);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @Override
            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).rectangleVertexShader(p1);
            }

            @Override
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            @Override
            public final String getName() {
                return "rectangleVertexShader";
            }

            @Override
            public final String getSignature() {
                return "rectangleVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @Override
            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).rectangleFragmentShader(p1);
            }

            @Override
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            @Override
            public final String getName() {
                return "rectangleFragmentShader";
            }

            @Override
            public final String getSignature() {
                return "rectangleFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        double radius = 1.0;
        Vector3 pa = new Vector3(x, y, 0.0);
        Vector3 pb = new Vector3(x + radius, y, 0.0);
        Vector3 pc = new Vector3(x + radius, y + radius, 0.0);
        Vector3 pd = new Vector3(x, y + radius, 0.0);
        Vector2 ta = new Vector2(0.0, 0.0);
        Vector2 tb = new Vector2(1.0, 0.0);
        Vector2 tc = new Vector2(1.0, 1.0);
        Vector2 td = new Vector2(0.0, 1.0);
        Vector3 n2 = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $receiver2 = bufferWriter = w;
        $receiver2.write(pa);
        $receiver2.write(n2);
        $receiver2.write(ta);
        $receiver2.write(pd);
        $receiver2.write(n2);
        $receiver2.write(td);
        $receiver2.write(pc);
        $receiver2.write(n2);
        $receiver2.write(tc);
        $receiver2.write(pc);
        $receiver2.write(n2);
        $receiver2.write(tc);
        $receiver2.write(pb);
        $receiver2.write(n2);
        $receiver2.write(tb);
        $receiver2.write(pa);
        $receiver2.write(n2);
        $receiver2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

