/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math.transforms;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u000f\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a&\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a6\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u001e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a&\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a6\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003\u001a6\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003\u001a.\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d\u001a\u0016\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0003\u001a\u000e\u0010\"\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0003\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0003\u001a\u000e\u0010$\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0003\u001a\u001e\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003\u001a\u000e\u0010%\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000b\u001a\u001e\u0010)\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003\u001a\u000e\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u000b\u001a.\u0010+\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d\u00a8\u0006,"}, d2={"frustum", "Lorg/openrndr/math/Matrix44;", "left", "", "right", "bottom", "top", "zNear", "zFar", "lookAt", "eye", "Lorg/openrndr/math/Vector3;", "target", "up", "normalMatrix", "view", "ortho", "xMag", "yMag", "perspective", "fovY", "aspectRatio", "xOffset", "yOffset", "perspectiveHorizontal", "project", "point", "projection", "width", "", "height", "rotate", "axis", "angle", "rotateX", "rotateY", "rotateZ", "scale", "x", "y", "z", "translate", "translation", "unproject", "openrndr-math"})
public final class TransformsKt {
    @NotNull
    public static final Matrix44 perspective(double fovY, double aspectRatio, double zNear, double zFar) {
        double y = Math.toRadians(fovY);
        return new Matrix44(1.0 / (aspectRatio * Math.tan(0.5 * y)), 0.0, 0.0, 0.0, 0.0, 1.0 / Math.tan(0.5 * y), 0.0, 0.0, 0.0, 0.0, (zFar + zNear) / (zNear - zFar), (double)2 * zFar * zNear / (zNear - zFar), 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 perspective(double fovY, double aspectRatio, double zNear) {
        double y = Math.toRadians(fovY);
        return new Matrix44(1.0 / (aspectRatio * Math.tan(0.5 * y)), 0.0, 0.0, 0.0, 0.0, 1.0 / Math.tan(0.5 * y), 0.0, 0.0, 0.0, 0.0, -1.0, -2.0 * zNear, 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 perspective(double fovY, double aspectRatio, double zNear, double zFar, double xOffset, double yOffset) {
        double fW = Math.tan(Math.toRadians(fovY) / (double)2) * zNear;
        double fH = fW * aspectRatio;
        return TransformsKt.frustum(-fH + xOffset, fH + xOffset, -fW + yOffset, fW + yOffset, zNear, zFar);
    }

    @NotNull
    public static final Matrix44 perspectiveHorizontal(double fovY, double aspectRatio, double zNear, double zFar, double xOffset, double yOffset) {
        double fW = Math.tan(Math.toRadians(fovY) / (double)2) * zNear;
        double fH = fW / aspectRatio;
        return TransformsKt.frustum(-fW + xOffset, fW + xOffset, -fH + yOffset, fH + yOffset, zNear, zFar);
    }

    @NotNull
    public static final Matrix44 frustum(double left, double right, double bottom, double top, double zNear, double zFar) {
        double rl = 1.0 / (right - left);
        double tb = 1.0 / (top - bottom);
        return new Matrix44(zNear * (double)2 * rl, 0.0, 0.0, (right + left) * rl, 0.0, zNear * (double)2 * tb, 0.0, (top + bottom) * tb, 0.0, 0.0, (zFar + zNear) / (zNear - zFar), (double)2 * zFar * zNear / (zNear - zFar), 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 ortho(double xMag, double yMag, double zNear, double zFar) {
        return new Matrix44(1.0 / xMag, 0.0, 0.0, 0.0, 0.0, 1.0 / yMag, 0.0, 0.0, 0.0, 0.0, 2.0 / (zNear - zFar), (zFar + zNear) / (zNear - zFar), 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 ortho(double left, double right, double bottom, double top, double zNear, double zFar) {
        double tx = -(right + left) / (right - left);
        double ty = -(top + bottom) / (top - bottom);
        double tz = -(zFar + zNear) / (zFar - zNear);
        return new Matrix44(2.0 / (right - left), 0.0, 0.0, tx, 0.0, 2.0 / (top - bottom), 0.0, ty, 0.0, 0.0, -2.0 / (zFar - zNear), tz, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 lookAt(@NotNull Vector3 eye, @NotNull Vector3 target, @NotNull Vector3 up) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(up, "up");
        Vector3 f = target.minus(eye).getNormalized();
        Vector3 u = up.getNormalized();
        Vector3 s = f.cross(u).getNormalized();
        u = s.cross(f);
        return new Matrix44(s.getX(), s.getY(), s.getZ(), -s.dot(eye), u.getX(), u.getY(), u.getZ(), -u.dot(eye), -f.getX(), -f.getY(), -f.getZ(), f.dot(eye), 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Matrix44 lookAt$default(Vector3 vector3, Vector3 vector32, Vector3 vector33, int n2, Object object) {
        if ((n2 & 4) != 0) {
            vector33 = Vector3.Companion.getUNIT_Y();
        }
        return TransformsKt.lookAt(vector3, vector32, vector33);
    }

    @NotNull
    public static final Matrix44 rotate(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        double r = Math.toRadians(angle);
        double cosa = Math.cos(r);
        double sina = Math.sin(r);
        Vector3 _axis = axis.getNormalized();
        return new Matrix44(cosa + (1.0 - cosa) * _axis.getX() * _axis.getX(), (1.0 - cosa) * _axis.getX() * _axis.getY() - _axis.getZ() * sina, (1.0 - cosa) * _axis.getX() * _axis.getZ() + _axis.getY() * sina, 0.0, (1.0 - cosa) * _axis.getX() * _axis.getY() + _axis.getZ() * sina, cosa + (1.0 - cosa) * _axis.getY() * _axis.getY(), (1.0 - cosa) * _axis.getY() * _axis.getZ() - _axis.getX() * sina, 0.0, (1.0 - cosa) * _axis.getX() * _axis.getZ() - _axis.getY() * sina, (1.0 - cosa) * _axis.getY() * _axis.getZ() + _axis.getX() * sina, cosa + (1.0 - cosa) * _axis.getZ() * _axis.getZ(), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateX(double angle) {
        double r = Math.toRadians(angle);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(1.0, 0.0, 0.0, 0.0, 0.0, cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateY(double angle) {
        double r = Math.toRadians(angle);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, 0.0, sr, 0.0, 0.0, 1.0, 0.0, 0.0, -sr, 0.0, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateZ(double angle) {
        double r = Math.toRadians(angle);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 translate(@NotNull Vector3 translation) {
        Intrinsics.checkParameterIsNotNull(translation, "translation");
        return TransformsKt.translate(translation.getX(), translation.getY(), translation.getZ());
    }

    @NotNull
    public static final Matrix44 translate(double x, double y, double z) {
        return Matrix44.Companion.fromColumnVectors(Vector4.Companion.getUNIT_X(), Vector4.Companion.getUNIT_Y(), Vector4.Companion.getUNIT_Z(), new Vector4(x, y, z, 1.0));
    }

    @NotNull
    public static final Matrix44 scale(@NotNull Vector3 scale) {
        Intrinsics.checkParameterIsNotNull(scale, "scale");
        return TransformsKt.scale(scale.getX(), scale.getY(), scale.getZ());
    }

    @NotNull
    public static final Matrix44 scale(double x, double y, double z) {
        return new Matrix44(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Vector3 project(@NotNull Vector3 point, @NotNull Matrix44 projection, @NotNull Matrix44 view, int width, int height) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        Intrinsics.checkParameterIsNotNull(view, "view");
        Vector4 homo = new Vector4(point.getX(), point.getY(), point.getZ(), 1.0);
        Vector4 projectedHomo = projection.times(view).times(homo);
        double rhw = 1.0 / projectedHomo.getW();
        return new Vector3((projectedHomo.getX() * rhw + 1.0) * (double)width / (double)2, (1.0 - projectedHomo.getY() * rhw) * (double)height / (double)2, rhw);
    }

    @NotNull
    public static final Vector3 unproject(@NotNull Vector3 point, @NotNull Matrix44 projection, @NotNull Matrix44 view, int width, int height) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        Intrinsics.checkParameterIsNotNull(view, "view");
        Matrix44 ipm = projection.times(view).getInversed();
        Vector3 v = new Vector3((double)2 * point.getX() / (double)width - 1.0, (double)2 * point.getY() / (double)height - 1.0, (double)2 * point.getZ() - 1.0);
        return ipm.times(v);
    }

    @NotNull
    public static final Matrix44 normalMatrix(@NotNull Matrix44 view) {
        Intrinsics.checkParameterIsNotNull(view, "view");
        Matrix44 subView = new Matrix44(view.getC0r0(), view.getC1r0(), view.getC2r0(), 0.0, view.getC0r1(), view.getC1r1(), view.getC2r1(), 0.0, view.getC0r2(), view.getC1r2(), view.getC2r2(), 0.0, 0.0, 0.0, 0.0, 1.0);
        return Matrix44.copy$default(subView.getInversed().getTransposed(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Short.MAX_VALUE, null);
    }
}

