/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/shape/Circle;", "", "center", "Lorg/openrndr/math/Vector2;", "radius", "", "(Lorg/openrndr/math/Vector2;D)V", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getRadius", "()D", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "contains", "", "point", "Companion", "openrndr-shape"})
public final class Circle {
    @NotNull
    private final Vector2 center;
    private final double radius;
    public static final Companion Companion = new Companion(null);

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        return point.minus(this.center).getSquaredLength() < this.radius * this.radius;
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        double x = this.center.getX() - this.radius;
        double y = this.center.getY() - this.radius;
        double width = this.radius * 2.0;
        double height = this.radius * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        return ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(x, ym, oy, xm, ox, y, xe, ye){
            final /* synthetic */ double $x;
            final /* synthetic */ double $ym;
            final /* synthetic */ double $oy;
            final /* synthetic */ double $xm;
            final /* synthetic */ double $ox;
            final /* synthetic */ double $y;
            final /* synthetic */ double $xe;
            final /* synthetic */ double $ye;

            public final void invoke(@NotNull ContourBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.moveTo(new Vector2(this.$x, this.$ym));
                $receiver.curveTo(new Vector2(this.$x, this.$ym - this.$oy), new Vector2(this.$xm - this.$ox, this.$y), new Vector2(this.$xm, this.$y));
                $receiver.curveTo(new Vector2(this.$xm + this.$ox, this.$y), new Vector2(this.$xe, this.$ym - this.$oy), new Vector2(this.$xe, this.$ym));
                $receiver.curveTo(new Vector2(this.$xe, this.$ym + this.$oy), new Vector2(this.$xm + this.$ox, this.$ye), new Vector2(this.$xm, this.$ye));
                $receiver.curveTo(new Vector2(this.$xm - this.$ox, this.$ye), new Vector2(this.$x, this.$ym + this.$oy), new Vector2(this.$x, this.$ym));
                $receiver.close();
            }
            {
                this.$x = d;
                this.$ym = d2;
                this.$oy = d3;
                this.$xm = d4;
                this.$ox = d5;
                this.$y = d6;
                this.$xe = d7;
                this.$ye = d8;
                super(1);
            }
        });
    }

    @NotNull
    public final Vector2 getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    public Circle(@NotNull Vector2 center, double radius) {
        Intrinsics.checkParameterIsNotNull(center, "center");
        this.center = center;
        this.radius = radius;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/shape/Circle$Companion;", "", "()V", "fromPoints", "Lorg/openrndr/shape/Circle;", "a", "Lorg/openrndr/math/Vector2;", "b", "fromPoints$openrndr_shape", "openrndr-shape"})
    public static final class Companion {
        @NotNull
        public final Circle fromPoints$openrndr_shape(@NotNull Vector2 a, @NotNull Vector2 b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Vector2 center = a.plus(b).times(0.5);
            return new Circle(center, b.minus(center).getLength());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

