/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/shape/Triangulator;", "", "()V", "indices", "", "", "triangles", "vertexCount", "", "vertexTypes", "vertices", "", "", "classifyVertex", "index", "computeTriangles", "offset", "count", "cutEarTip", "", "earTipIndex", "findEarTip", "isEarTip", "", "nextIndex", "previousIndex", "triangulate", "Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "Companion", "openrndr-shape"})
public final class Triangulator {
    private List<Short> indices;
    private List<Float> vertices;
    private int vertexCount;
    private final List<Integer> vertexTypes;
    private final List<Short> triangles;
    private static final int CONCAVE = -1;
    private static final int CONVEX = 1;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> triangulate(@NotNull ShapeContour contour2) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        List list;
        Intrinsics.checkParameterIsNotNull(contour2, "contour");
        List it2 = list = ShapeContour.adaptivePositions$default(contour2, 0.0, 1, null);
        List vertices = it2.subList(0, it2.size() - 1);
        Iterable $i$a$1$let = $receiver$iv = (Iterable)vertices;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            Vector2 it3 = (Vector2)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.listOf(new Float[]{Float.valueOf((float)it3.getX()), Float.valueOf((float)it3.getY())});
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List floats = (List)destination$iv$iv;
        List indices = Triangulator.computeTriangles$default(this, floats, 0, 0, 6, null);
        Iterable $receiver$iv2 = indices;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it4;
            short $i$a$1$flatMap = ((Number)item$iv$iv).shortValue();
            Collection collection = destination$iv$iv2;
            Vector2 vector2 = (Vector2)vertices.get((int)it4);
            collection.add(vector2);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Short> computeTriangles(@NotNull List<Float> vertices, int offset, int count) {
        int i;
        List list;
        Intrinsics.checkParameterIsNotNull(vertices, "vertices");
        this.vertices = vertices;
        int vertexCount = this.vertexCount = count / 2;
        int vertexOffset = offset / 2;
        Triangulator triangulator = this;
        triangulator.indices = list = (List)new ArrayList();
        int n2 = 0;
        int n3 = vertexCount;
        while (n2 < n3) {
            void i2;
            List<Short> list2 = this.indices;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add((short)0);
            ++i2;
        }
        List<Short> indices = this.indices;
        if (Triangulator.Companion.areVerticesClockwise(vertices, offset, count)) {
            n3 = 0;
            int n4 = vertexCount;
            while (n3 < n4) {
                List<Short> list3 = indices;
                if (list3 == null) {
                    Intrinsics.throwNpe();
                }
                list3.set(i, (short)(vertexOffset + i));
                ++i;
            }
        } else {
            int n5 = vertexCount - 1;
            for (i = 0; i < vertexCount; ++i) {
                List<Short> list4 = indices;
                if (list4 == null) {
                    Intrinsics.throwNpe();
                }
                list4.set(i, (short)(vertexOffset + n5 - i));
            }
        }
        List<Integer> vertexTypes = this.vertexTypes;
        vertexTypes.clear();
        for (int i3 = 0; i3 < vertexCount; ++i3) {
            vertexTypes.add(this.classifyVertex(i3));
        }
        List<Short> triangles = this.triangles;
        triangles.clear();
        this.triangulate();
        return triangles;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List computeTriangles$default(Triangulator triangulator, List list, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = list.size();
        }
        return triangulator.computeTriangles(list, n2, n3);
    }

    private final void triangulate() {
        List<Integer> vertexTypes = this.vertexTypes;
        while (this.vertexCount > 3) {
            int earTipIndex = this.findEarTip();
            this.cutEarTip(earTipIndex);
            int previousIndex = this.previousIndex(earTipIndex);
            int nextIndex = earTipIndex == this.vertexCount ? 0 : earTipIndex;
            vertexTypes.set(previousIndex, this.classifyVertex(previousIndex));
            vertexTypes.set(nextIndex, this.classifyVertex(nextIndex));
        }
        if (this.vertexCount == 3) {
            List<Short> indices;
            List<Short> triangles = this.triangles;
            List<Short> list = indices = this.indices;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            triangles.add(list.get(0));
            triangles.add(indices.get(1));
            triangles.add(indices.get(2));
        }
    }

    private final int classifyVertex(int index) {
        List<Float> vertices;
        List<Short> indices;
        List<Short> list = indices = this.indices;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int previous = ((Number)list.get(this.previousIndex(index))).intValue() * 2;
        int current = ((Number)indices.get(index)).intValue() * 2;
        int next = ((Number)indices.get(this.nextIndex(index))).intValue() * 2;
        List<Float> list2 = vertices = this.vertices;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        return Triangulator.Companion.computeSpannedAreaSign(((Number)list2.get(previous)).floatValue(), ((Number)vertices.get(previous + 1)).floatValue(), ((Number)vertices.get(current)).floatValue(), ((Number)vertices.get(current + 1)).floatValue(), ((Number)vertices.get(next)).floatValue(), ((Number)vertices.get(next + 1)).floatValue());
    }

    /*
     * WARNING - void declaration
     */
    private final int findEarTip() {
        int vertexCount = this.vertexCount;
        int n2 = 0;
        int n3 = vertexCount;
        while (n2 < n3) {
            void i;
            if (this.isEarTip((int)i)) {
                return (int)i;
            }
            ++i;
        }
        List<Integer> vertexTypes = this.vertexTypes;
        n3 = 0;
        int n4 = vertexCount;
        while (n3 < n4) {
            void i;
            if (((Number)vertexTypes.get((int)i)).intValue() != Triangulator.Companion.getCONCAVE()) {
                return (int)i;
            }
            ++i;
        }
        return 0;
    }

    private final boolean isEarTip(int earTipIndex) {
        List<Float> vertices;
        List<Short> indices;
        List<Integer> vertexTypes = this.vertexTypes;
        if (((Number)vertexTypes.get(earTipIndex)).intValue() == Triangulator.Companion.getCONCAVE()) {
            return false;
        }
        int previousIndex = this.previousIndex(earTipIndex);
        int nextIndex = this.nextIndex(earTipIndex);
        List<Short> list = indices = this.indices;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int p1 = ((Number)list.get(previousIndex)).intValue() * 2;
        int p2 = ((Number)indices.get(earTipIndex)).intValue() * 2;
        int p3 = ((Number)indices.get(nextIndex)).intValue() * 2;
        List<Float> list2 = vertices = this.vertices;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        float p1x = ((Number)list2.get(p1)).floatValue();
        float p1y = ((Number)vertices.get(p1 + 1)).floatValue();
        float p2x = ((Number)vertices.get(p2)).floatValue();
        float p2y = ((Number)vertices.get(p2 + 1)).floatValue();
        float p3x = ((Number)vertices.get(p3)).floatValue();
        float p3y = ((Number)vertices.get(p3 + 1)).floatValue();
        int i = this.nextIndex(nextIndex);
        while (i != previousIndex) {
            float vy;
            int v;
            float vx;
            if (((Number)vertexTypes.get(i)).intValue() != Triangulator.Companion.getCONVEX() && Triangulator.Companion.computeSpannedAreaSign(p3x, p3y, p1x, p1y, vx = ((Number)vertices.get(v = ((Number)indices.get(i)).intValue() * 2)).floatValue(), vy = ((Number)vertices.get(v + 1)).floatValue()) >= 0 && Triangulator.Companion.computeSpannedAreaSign(p1x, p1y, p2x, p2y, vx, vy) >= 0 && Triangulator.Companion.computeSpannedAreaSign(p2x, p2y, p3x, p3y, vx, vy) >= 0) {
                return false;
            }
            i = this.nextIndex(i);
        }
        return true;
    }

    private final void cutEarTip(int earTipIndex) {
        List<Short> indices = this.indices;
        List<Short> triangles = this.triangles;
        List<Short> list = indices;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        triangles.add(list.get(this.previousIndex(earTipIndex)));
        triangles.add(indices.get(earTipIndex));
        triangles.add(indices.get(this.nextIndex(earTipIndex)));
        indices.remove(earTipIndex);
        this.vertexTypes.remove(earTipIndex);
        int n2 = this.vertexCount;
        this.vertexCount = n2 + -1;
    }

    private final int previousIndex(int index) {
        return (index == 0 ? this.vertexCount : index) - 1;
    }

    private final int nextIndex(int index) {
        return (index + 1) % this.vertexCount;
    }

    public Triangulator() {
        List list;
        Triangulator triangulator = this;
        triangulator.vertexTypes = list = (List)new ArrayList();
        triangulator = this;
        triangulator.triangles = list = (List)new ArrayList();
    }

    static {
        CONCAVE = -1;
        CONVEX = 1;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J8\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/shape/Triangulator$Companion;", "", "()V", "CONCAVE", "", "getCONCAVE", "()I", "CONVEX", "getCONVEX", "areVerticesClockwise", "", "vertices", "", "", "offset", "count", "computeSpannedAreaSign", "p1x", "p1y", "p2x", "p2y", "p3x", "p3y", "openrndr-shape"})
    public static final class Companion {
        private final int getCONCAVE() {
            return CONCAVE;
        }

        private final int getCONVEX() {
            return CONVEX;
        }

        private final boolean areVerticesClockwise(List<Float> vertices, int offset, int count) {
            float p2y;
            float p2x;
            float p1y;
            float p1x;
            if (count <= 2) {
                return false;
            }
            float area = 0.0f;
            int n2 = offset + count - 3;
            for (int i = offset; i < n2; i += 2) {
                p1x = ((Number)vertices.get(i)).floatValue();
                p1y = ((Number)vertices.get(i + 1)).floatValue();
                p2x = ((Number)vertices.get(i + 2)).floatValue();
                p2y = ((Number)vertices.get(i + 3)).floatValue();
                area += p1x * p2y - p2x * p1y;
            }
            p1x = ((Number)vertices.get(offset + count - 2)).floatValue();
            p1y = ((Number)vertices.get(offset + count - 1)).floatValue();
            p2x = ((Number)vertices.get(offset)).floatValue();
            p2y = ((Number)vertices.get(offset + 1)).floatValue();
            return area + p1x * p2y - p2x * p1y < 0.0f;
        }

        private final int computeSpannedAreaSign(float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
            float area = p1x * (p3y - p2y);
            area += p2x * (p1y - p3y);
            return (int)Math.signum(area += p3x * (p2y - p1y));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

