/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eJ(\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/shape/internal/BezierQuadraticSampler;", "", "()V", "angleTolerance", "", "angleToleranceEpsilon", "distanceTolerance", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "distanceToleranceSquare", "points", "", "Lorg/openrndr/math/Vector2;", "getPoints$openrndr_shape", "()Ljava/util/List;", "setPoints$openrndr_shape", "(Ljava/util/List;)V", "recursionLimit", "", "sample", "", "x1", "x2", "x3", "", "level", "Companion", "openrndr-shape"})
public final class BezierQuadraticSampler {
    private final int recursionLimit = 8;
    private double distanceTolerance = 0.5;
    private double distanceToleranceSquare;
    private final double angleToleranceEpsilon = 0.01;
    private final double angleTolerance = 0.0;
    @NotNull
    private List<Vector2> points;
    private static final double colinearityEpsilon = 1.0E-30;
    public static final Companion Companion = new Companion(null);

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final List<Vector2> getPoints$openrndr_shape() {
        return this.points;
    }

    public final void setPoints$openrndr_shape(@NotNull List<Vector2> list) {
        Intrinsics.checkParameterIsNotNull(list, "<set-?>");
        this.points = list;
    }

    private final void sample(Vector2 x1, Vector2 x2, Vector2 x3, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Vector2 x12 = x1.plus(x2).times(0.5);
        Vector2 x23 = x2.plus(x3).times(0.5);
        Vector2 x123 = x12.plus(x23).times(0.5);
        double dx = x3.getX() - x1.getX();
        double dy = x3.getY() - x1.getY();
        double d = Math.abs((x2.getX() - x3.getX()) * dy - (x2.getY() - x3.getY()) * dx);
        if (d > 1.0E-30) {
            if (d * d <= this.distanceToleranceSquare * (dx * dx + dy * dy)) {
                if (this.angleTolerance < this.angleToleranceEpsilon) {
                    this.points.add(x123);
                    return;
                }
                double da = Math.abs(Math.atan2(x3.getY() - x2.getY(), x3.getX() - x2.getX()) - Math.atan2(x2.getY() - x1.getY(), x2.getX() - x1.getX()));
                if (da >= Math.PI) {
                    da = Math.PI * 2 - da;
                }
                if (da < this.angleTolerance) {
                    this.points.add(x123);
                    return;
                }
            }
        } else {
            double da = dx * dx + dy * dy;
            if (da == 0.0) {
                d = BezierQuadraticSampler.Companion.squaredDistance(x1.getX(), x1.getY(), x2.getX(), x2.getY());
            } else {
                d = ((x2.getX() - x1.getX()) * dx + (x2.getY() - x1.getY()) * dy) / da;
                if (d > 0.0 && d < 1.0) {
                    return;
                }
                d = d <= 0.0 ? BezierQuadraticSampler.Companion.squaredDistance(x2.getX(), x2.getY(), x1.getX(), x1.getY()) : (d >= 1.0 ? BezierQuadraticSampler.Companion.squaredDistance(x2.getX(), x2.getY(), x3.getX(), x3.getY()) : BezierQuadraticSampler.Companion.squaredDistance(x2.getX(), x2.getY(), x1.getX() + d * dx, x1.getY() + d * dy));
            }
            if (d < this.distanceToleranceSquare) {
                this.points.add(x2);
                return;
            }
        }
        this.sample(x1, x12, x123, level + 1);
        this.sample(x123, x23, x3, level + 1);
    }

    @NotNull
    public final List<Vector2> sample(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3) {
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        Intrinsics.checkParameterIsNotNull(x2, "x2");
        Intrinsics.checkParameterIsNotNull(x3, "x3");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.points.add(x1);
        this.sample(x1, x2, x3, 0);
        this.points.add(x3);
        return this.points;
    }

    public BezierQuadraticSampler() {
        List list;
        BezierQuadraticSampler bezierQuadraticSampler = this;
        bezierQuadraticSampler.points = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/openrndr/shape/internal/BezierQuadraticSampler$Companion;", "", "()V", "colinearityEpsilon", "", "squaredDistance", "x1", "y1", "x2", "y2", "openrndr-shape"})
    public static final class Companion {
        private final double squaredDistance(double x1, double y1, double x2, double y2) {
            double dx = x2 - x1;
            double dy = y2 - y1;
            return dx * dx + dy * dy;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

