/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Color;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.svg.VisitStage;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2,\u0010\r\u001a(\u0012\u0004\u0012\u00020\f\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\u0002\b\u0013H\u0002\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\u00a8\u0006\u0017"}, d2={"svg", "", "Lorg/openrndr/color/ColorRGBa;", "getSvg", "(Lorg/openrndr/color/ColorRGBa;)Ljava/lang/String;", "Lorg/openrndr/math/Matrix44;", "(Lorg/openrndr/math/Matrix44;)Ljava/lang/String;", "Lorg/openrndr/shape/Shape;", "(Lorg/openrndr/shape/Shape;)Ljava/lang/String;", "process", "", "compositionNode", "Lorg/openrndr/shape/CompositionNode;", "visitor", "Lkotlin/Function2;", "Lorg/openrndr/svg/VisitStage;", "Lkotlin/ParameterName;", "name", "stage", "Lkotlin/ExtensionFunctionType;", "writeSVG", "composition", "Lorg/openrndr/shape/Composition;", "openrndr-svg"})
public final class SVGWriterKt {
    @NotNull
    public static final String writeSVG(@NotNull Composition composition2) {
        Intrinsics.checkParameterIsNotNull(composition2, "composition");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1 Tiny//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd\">\n");
        sb.append("<svg version=\"1.1\" baseProfile=\"tiny\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"  x=\"0px\" y=\"0px\"\n width=\"2676px\" height=\"2048px\">");
        SVGWriterKt.process(composition2.getRoot(), (Function2<? super CompositionNode, ? super VisitStage, Unit>)new Function2<CompositionNode, VisitStage, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;

            public final void invoke(@NotNull CompositionNode $receiver, @NotNull VisitStage it2) {
                block9: {
                    block7: {
                        Object object;
                        String fillAttribute;
                        block15: {
                            block13: {
                                block14: {
                                    Object object2;
                                    Object object3;
                                    CompositionColor it3;
                                    block12: {
                                        block10: {
                                            block11: {
                                                Object object4;
                                                CompositionNode compositionNode;
                                                block8: {
                                                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                                                    Intrinsics.checkParameterIsNotNull((Object)((Object)it2), "it");
                                                    if (!Intrinsics.areEqual((Object)((Object)it2), (Object)((Object)VisitStage.PRE))) break block7;
                                                    compositionNode = $receiver;
                                                    if (!(compositionNode instanceof GroupNode)) break block8;
                                                    if (Intrinsics.areEqual($receiver.getTransform(), Matrix44.Companion.getIDENTITY()) ^ true) {
                                                        this.$sb.append("<g transform=\"" + SVGWriterKt.access$getSvg$p($receiver.getTransform()) + "\">\n");
                                                    } else {
                                                        this.$sb.append("<g>\n");
                                                    }
                                                    break block9;
                                                }
                                                if (!(compositionNode instanceof ShapeNode)) break block9;
                                                CompositionColor compositionColor = $receiver.getFill();
                                                it3 = compositionColor;
                                                if (!(it3 instanceof Color)) break block10;
                                                object3 = ((Color)it3).getColor();
                                                if (object3 == null) break block11;
                                                Object it4 = object4 = object3;
                                                object3 = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it4) + '\"';
                                                if (object3 != null) break block12;
                                            }
                                            object3 = "fill=\"none\"";
                                            break block12;
                                        }
                                        object3 = "";
                                    }
                                    fillAttribute = object3;
                                    CompositionColor it5 = it3 = $receiver.getStroke();
                                    if (!(it5 instanceof Color)) break block13;
                                    object = ((Color)it5).getColor();
                                    if (object == null) break block14;
                                    Object it6 = object2 = object;
                                    object = "stroke=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it6) + '\"';
                                    if (object != null) break block15;
                                }
                                object = "stroke=\"none\"";
                                break block15;
                            }
                            object = "";
                        }
                        String strokeAttribute = object;
                        String strokeWidthAttribute = "stroke-weight=\"1.0\"";
                        String pathAttribute = "d=\"" + SVGWriterKt.access$getSvg$p(((ShapeNode)$receiver).getShape()) + '\"';
                        this.$sb.append("<path " + fillAttribute + ' ' + strokeAttribute + ' ' + strokeWidthAttribute + ' ' + pathAttribute + "/>\n");
                        break block9;
                    }
                    CompositionNode compositionNode = $receiver;
                    if (compositionNode instanceof GroupNode) {
                        this.$sb.append("</g>\n");
                    }
                }
            }
            {
                this.$sb = stringBuilder;
                super(2);
            }
        });
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private static final String getSvg(@NotNull ColorRGBa $receiver) {
        int ir = (int)(RangesKt.coerceIn($receiver.getR(), 0.0, 1.0) * 255.0);
        int ig = (int)(RangesKt.coerceIn($receiver.getG(), 0.0, 1.0) * 255.0);
        int ib = (int)(RangesKt.coerceIn($receiver.getB(), 0.0, 1.0) * 255.0);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "#%02X%02x%02x";
        Object[] objectArray = new Object[]{ir, ig, ib};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
        return string2;
    }

    private static final String getSvg(@NotNull Matrix44 $receiver) {
        return "matrix(" + $receiver.getC0r0() + ", " + $receiver.getC0r1() + ", " + $receiver.getC1r0() + ", " + $receiver.getC1r1() + ", " + $receiver.getC3r0() + ", " + $receiver.getC3r1() + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(@NotNull Shape $receiver) {
        StringBuilder sb = new StringBuilder();
        Iterable $receiver$iv = $receiver.getContours();
        for (Object element$iv : $receiver$iv) {
            ShapeContour it2 = (ShapeContour)element$iv;
            Iterable $receiver$iv2 = it2.getSegments();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                String string;
                void segment;
                int n2 = index$iv++;
                Segment segment2 = (Segment)item$iv;
                int index = n2;
                if (index == 0) {
                    sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
                }
                switch (((Object[])segment.getControl()).length) {
                    case 1: {
                        string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    case 2: {
                        string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    default: {
                        string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    }
                }
                sb.append(string);
            }
            if (!it2.getClosed()) continue;
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private static final void process(CompositionNode compositionNode, Function2<? super CompositionNode, ? super VisitStage, Unit> visitor) {
        visitor.invoke(compositionNode, VisitStage.PRE);
        if (compositionNode instanceof GroupNode) {
            Iterable $receiver$iv = ((GroupNode)compositionNode).getChildren();
            for (Object element$iv : $receiver$iv) {
                CompositionNode it2 = (CompositionNode)element$iv;
                SVGWriterKt.process(it2, visitor);
            }
        }
        visitor.invoke(compositionNode, VisitStage.POST);
    }

    @NotNull
    public static final /* synthetic */ String access$getSvg$p(@NotNull Matrix44 $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getSvg$p(@NotNull ColorRGBa $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getSvg$p(@NotNull Shape $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }
}

