/*
 * Decompiled with CFR 0.152.
 */
package sketches.ik002;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.ApplicationKt;
import org.openrndr.ProgramKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;
import sketches.ik002.IK002;
import sketches.ik002.IK002Kt;
import sketches.ik002.Joint;
import sketches.ik002.SceneNode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"forward", "Lorg/openrndr/math/Vector3;", "node", "Lsketches/ik002/SceneNode;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "optimize", "endPoint", "target", "pop", "push", "relax", "demo-strap"})
public final class IK002Kt {
    private static final Vector3 forward(SceneNode node) {
        List chain = CollectionsKt.reversed((Iterable)node.getIkChain());
        Matrix44 transform = Matrix44.Companion.getIDENTITY();
        Iterable $receiver$iv = chain;
        for (Object element$iv : $receiver$iv) {
            SceneNode it2 = (SceneNode)element$iv;
            transform = transform.times(it2.getTransform());
            transform = transform.times(it2.getJoint().getMatrix());
        }
        transform = transform.times(TransformsKt.translate(0.0, -1.0, 0.0));
        return transform.times(new Vector4(0.0, 0.0, 0.0, 1.0)).getXyz();
    }

    /*
     * WARNING - void declaration
     */
    public static final void push(@NotNull SceneNode endPoint) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(endPoint, "endPoint");
        Iterable $receiver$iv = endPoint.getIkChain();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            SceneNode sceneNode = (SceneNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            Joint joint = it2.getJoint();
            collection.add(joint);
        }
        List chain = (List)destination$iv$iv;
        $receiver$iv = chain;
        for (Object element$iv : $receiver$iv) {
            Joint it3 = (Joint)element$iv;
            it3.setTx(it3.getX());
            it3.setTy(it3.getY());
            it3.setTz(it3.getZ());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void pop(@NotNull SceneNode endPoint) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(endPoint, "endPoint");
        Iterable $receiver$iv = endPoint.getIkChain();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            SceneNode sceneNode = (SceneNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            Joint joint = it2.getJoint();
            collection.add(joint);
        }
        List chain = (List)destination$iv$iv;
        $receiver$iv = chain;
        for (Object element$iv : $receiver$iv) {
            Joint it3 = (Joint)element$iv;
            it3.setX(RangesKt.coerceIn(it3.getX() - it3.getTx(), -0.05, 0.05) + it3.getTx());
            it3.setY(RangesKt.coerceIn(it3.getY() - it3.getTy(), -0.05, 0.05) + it3.getTy());
            it3.setZ(RangesKt.coerceIn(it3.getZ() - it3.getTz(), -0.05, 0.05) + it3.getTz());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void optimize(@NotNull SceneNode endPoint, @NotNull Vector3 target) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(endPoint, "endPoint");
        Intrinsics.checkParameterIsNotNull(target, "target");
        double currentError = IK002Kt.forward(endPoint).minus(target).getLength();
        Iterable iterable = $receiver$iv = (Iterable)endPoint.getIkChain();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            SceneNode sceneNode = (SceneNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            Joint joint = it2.getJoint();
            collection.add(joint);
        }
        List chain = (List)destination$iv$iv;
        double delta = 0.01;
        double l = 0.001;
        List step = new ArrayList();
        Iterator $i$a$1$map = chain.iterator();
        while ($i$a$1$map.hasNext()) {
            Joint joint;
            Joint joint2 = joint = (Joint)$i$a$1$map.next();
            joint2.setX(joint2.getX() + delta);
            Object object = step;
            Double $i$f$map = (IK002Kt.forward(endPoint).minus(target).getLength() - currentError) / delta;
            object.add($i$f$map);
            Joint joint3 = joint;
            joint3.setX(joint3.getX() - delta);
            Joint joint4 = joint;
            joint4.setY(joint4.getY() + delta);
            object = step;
            $i$f$map = (IK002Kt.forward(endPoint).minus(target).getLength() - currentError) / delta;
            object.add($i$f$map);
            Joint joint5 = joint;
            joint5.setY(joint5.getY() - delta);
            Joint joint6 = joint;
            joint6.setZ(joint6.getZ() + delta);
            object = step;
            $i$f$map = (IK002Kt.forward(endPoint).minus(target).getLength() - currentError) / delta;
            object.add($i$f$map);
            Joint joint7 = joint;
            joint7.setZ(joint7.getZ() - delta);
        }
        Iterable $receiver$iv2 = chain;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv2) {
            void joint;
            int n2 = index$iv++;
            Joint joint8 = (Joint)item$iv;
            int index = n2;
            void v7 = joint;
            v7.setX(v7.getX() - ((Number)step.get(index * 3)).doubleValue() * l);
            void v8 = joint;
            v8.setY(v8.getY() - ((Number)step.get(index * 3 + 1)).doubleValue() * l);
            void v9 = joint;
            v9.setZ(v9.getZ() - ((Number)step.get(index * 3 + 2)).doubleValue() * l);
            joint.setX(RangesKt.coerceIn(joint.getX(), joint.getMinX(), joint.getMaxX()));
            joint.setY(RangesKt.coerceIn(joint.getY(), joint.getMinY(), joint.getMaxY()));
            joint.setZ(RangesKt.coerceIn(joint.getZ(), joint.getMinZ(), joint.getMaxZ()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void relax(@NotNull SceneNode endPoint) {
        Joint it2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(endPoint, "endPoint");
        Iterable iterable = $receiver$iv = (Iterable)endPoint.getIkChain();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            SceneNode sceneNode = (SceneNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            Joint joint = ((SceneNode)((Object)it2)).getJoint();
            collection.add(joint);
        }
        List chain = (List)destination$iv$iv;
        double[] step = new double[chain.size() * 3];
        Iterable $receiver$iv2 = chain;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv2) {
            void joint;
            int n2 = index$iv++;
            it2 = (Joint)item$iv;
            int index = n2;
            if (index > 0) {
                int n3 = index * 3;
                step[n3] = step[n3] + (((Joint)chain.get(index - 1)).getX() - joint.getX());
                int n4 = index * 3 + 1;
                step[n4] = step[n4] + (((Joint)chain.get(index - 1)).getY() - joint.getY());
                int n5 = index * 3 + 2;
                step[n5] = step[n5] + (((Joint)chain.get(index - 1)).getZ() - joint.getZ());
            }
            if (index >= chain.size() - 1) continue;
            int n6 = index * 3;
            step[n6] = step[n6] + (((Joint)chain.get(index + 1)).getX() - joint.getX());
            int n7 = index * 3 + 1;
            step[n7] = step[n7] + (((Joint)chain.get(index + 1)).getY() - joint.getY());
            int n8 = index * 3 + 2;
            step[n8] = step[n8] + (((Joint)chain.get(index + 1)).getZ() - joint.getZ());
        }
        double l = 0.1;
        Iterable $receiver$iv3 = chain;
        int index$iv2 = 0;
        for (Object item$iv : $receiver$iv3) {
            void joint;
            int n9 = index$iv2++;
            Joint $i$a$1$forEachIndexed = (Joint)item$iv;
            int index = n9;
            void v8 = joint;
            v8.setX(v8.getX() + step[index * 3] * l);
            void v9 = joint;
            v9.setY(v9.getY() + step[index * 3 + 1] * l);
            void v10 = joint;
            v10.setZ(v10.getZ() + step[index * 3 + 2] * l);
        }
    }

    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        ApplicationKt.application(new IK002(), ProgramKt.configuration(main.1.INSTANCE));
    }
}

