/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.sndr;

import com.jogamp.openal.AL;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class AudioBuffer {
    public static final int FORMAT_MONO8 = 4352;
    public static final int FORMAT_MONO16 = 4353;
    public static final int FORMAT_STEREO8 = 4354;
    public static final int FORMAT_STEREO16 = 4355;
    protected final AL al;
    protected ByteBuffer data;
    protected final int bufferID;
    protected int[] alResult = new int[1];

    public AudioBuffer(AL al, int bufferID) {
        this.bufferID = bufferID;
        this.al = al;
    }

    public void configure(ByteBuffer data, int format, int freq) {
        this.data = data;
        this.al.alBufferData(this.bufferID, format, (Buffer)data, data.capacity(), freq);
    }

    public void delete() {
        this.data = null;
        this.al.alDeleteBuffers(1, new int[]{this.bufferID}, 0);
    }

    public int getBitDepth() {
        this.al.alGetBufferi(this.bufferID, 8194, this.alResult, 0);
        return this.alResult[0];
    }

    public int getNumChannels() {
        this.al.alGetBufferi(this.bufferID, 8195, this.alResult, 0);
        return this.alResult[0];
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getFrequency() {
        this.al.alGetBufferi(this.bufferID, 8193, this.alResult, 0);
        return this.alResult[0];
    }

    public int getByteSize() {
        this.al.alGetBufferi(this.bufferID, 8196, this.alResult, 0);
        return this.alResult[0];
    }

    public int getSampleSize() {
        return this.getByteSize() * 8 / this.getBitDepth();
    }

    public int getID() {
        return this.bufferID;
    }
}

