/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.sndr;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.eax.EAX;
import com.jogamp.openal.eax.EAXFactory;
import com.jogamp.openal.util.ALut;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.lustlab.sndr.AudioBuffer;
import net.lustlab.sndr.AudioSource;
import net.lustlab.sndr.OggDecoder;
import net.lustlab.sndr.SoundListener;

public class JOALUtil {
    protected static final Logger logger = Logger.getLogger(JOALUtil.class.getName());
    protected static JOALUtil instance;
    protected ArrayList<AudioBuffer> buffers;
    protected ArrayList<AudioSource> sources;
    protected SoundListener listener;
    protected AL al;
    protected ALC alc;
    protected EAX eax;
    protected boolean isInited;
    protected boolean isEAX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JOALUtil getInstance() {
        if (instance != null) return instance;
        Class<JOALUtil> clazz = JOALUtil.class;
        synchronized (JOALUtil.class) {
            if (instance != null) return instance;
            instance = new JOALUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected JOALUtil() {
    }

    public void deleteBuffer(AudioBuffer b) {
        for (AudioSource s : this.sources) {
            if (s.getBuffer() != b) continue;
            s.stop();
            logger.fine("forced stopping source: " + s);
        }
        b.delete();
        this.buffers.remove(b);
        logger.info("deleted buffer: " + b);
    }

    public void deleteSource(AudioSource src) {
        src.delete();
        this.sources.remove(src);
        logger.info("deleted source: " + src);
    }

    public AudioBuffer[] generateBuffers(int numBuffers) {
        AudioBuffer[] result = new AudioBuffer[numBuffers];
        int[] arr = new int[numBuffers];
        this.al.alGenBuffers(numBuffers, arr, 0);
        for (int i = 0; i < numBuffers; ++i) {
            result[i] = new AudioBuffer(this.al, arr[i]);
            this.buffers.add(result[i]);
        }
        return result;
    }

    public AudioSource[] generateSources(int numSources) {
        AudioSource[] result = new AudioSource[numSources];
        int[] arr = new int[numSources];
        this.al.alGenSources(numSources, arr, 0);
        for (int i = 0; i < numSources; ++i) {
            result[i] = new AudioSource(this.al, arr[i]);
            this.sources.add(result[i]);
        }
        return result;
    }

    public AL getAL() {
        return this.al;
    }

    public SoundListener getListener() {
        if (this.listener == null) {
            this.listener = new SoundListener(this);
        }
        return this.listener;
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean attemptEAX) {
        if (!this.isInited) {
            try {
                ALut.alutInit();
                this.al = ALFactory.getAL();
                this.alc = ALFactory.getALC();
            }
            catch (ALException e) {
                throw new RuntimeException("OpenAL could not be initialized: " + e.getMessage());
            }
            this.buffers = new ArrayList();
            this.sources = new ArrayList();
            this.listener = new SoundListener(this);
            this.isEAX = this.al.alIsExtensionPresent("EAX2.0");
            if (this.isEAX && attemptEAX) {
                this.initEAX();
            }
            this.isInited = this.al.alGetError() == 0;
        }
        return this.isInited;
    }

    private void initEAX() {
        this.eax = EAXFactory.getEAX();
        IntBuffer b = IntBuffer.allocate(1);
        b.put(10);
        this.eax.setListenerProperty(11, (Buffer)b);
    }

    public boolean isEAXSupported() {
        return this.isEAX;
    }

    public AudioBuffer loadBuffer(InputStream is) throws UnsupportedAudioFileException, IOException {
        AudioBuffer[] tmp = this.generateBuffers(1);
        AudioBuffer result = tmp[0];
        WAVData wd = WAVLoader.loadFromStream((InputStream)is);
        result.configure(wd.data, wd.format, wd.freq);
        return result;
    }

    public AudioBuffer loadBuffer(String fileName) {
        if (fileName.endsWith(".wav")) {
            AudioBuffer result = null;
            try {
                WAVData wd = WAVLoader.loadFromFile((String)fileName);
                AudioBuffer[] tmp = this.generateBuffers(1);
                result = tmp[0];
                result.configure(wd.data, wd.format, wd.freq);
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
            }
            return result;
        }
        if (fileName.endsWith(".ogg")) {
            AudioBuffer result = null;
            try {
                OggDecoder decoder = new OggDecoder(new URL("file:" + fileName));
                byte[] data = decoder.readAll();
                AudioBuffer[] tmp = this.generateBuffers(1);
                result = tmp[0];
                int channels = decoder.getAudioFormat().getChannels();
                int format = channels == 1 ? 4353 : 4355;
                result.configure(ByteBuffer.wrap(data), format, (int)decoder.getAudioFormat().getSampleRate());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            return result;
        }
        throw new RuntimeException("file type not supported: " + fileName);
    }

    public void shutdown() {
        logger.info("shutting down JOAL");
        int[] tmpbuf = new int[this.buffers.size()];
        for (int i = 0; i < tmpbuf.length; ++i) {
            tmpbuf[i] = this.buffers.get(i).getID();
        }
        this.al.alDeleteBuffers(tmpbuf.length, tmpbuf, 0);
        logger.info(tmpbuf.length + " buffers released");
        int[] tmpsrc = new int[this.sources.size()];
        for (int i = 0; i < tmpsrc.length; ++i) {
            tmpsrc[i] = this.sources.get(i).getID();
        }
        this.al.alDeleteSources(tmpsrc.length, tmpsrc, 0);
        logger.info(tmpsrc.length + " sources released");
        ALCcontext curContext = this.alc.alcGetCurrentContext();
        ALCdevice curDevice = this.alc.alcGetContextsDevice(curContext);
        this.alc.alcMakeContextCurrent(null);
        this.alc.alcDestroyContext(curContext);
        this.alc.alcCloseDevice(curDevice);
        this.alc = null;
        this.al = null;
        this.buffers = null;
        this.sources = null;
        this.isInited = false;
    }
}

