/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.sndr;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.FileStream;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class OggDecoder {
    private static int BLOCK_SIZE = 262144;
    VorbisStream vStream;
    LogicalOggStream loStream;
    private AudioInputStream ais;
    private IdentificationHeader vStreamHdr;
    private AudioFormat audioFormat;
    private URL url;
    private boolean swap = false;
    private boolean endOfStream = false;

    public OggDecoder(URL url) {
        this.url = url;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public boolean initialize() {
        try {
            FileStream os = new FileStream(new RandomAccessFile(this.url.getFile(), "r"));
            this.loStream = (LogicalOggStream)os.getLogicalStreams().iterator().next();
            this.vStream = new VorbisStream(this.loStream);
            this.vStreamHdr = this.vStream.getIdentificationHeader();
            this.audioFormat = new AudioFormat(this.vStreamHdr.getSampleRate(), 16, this.vStreamHdr.getChannels(), true, true);
            this.ais = new AudioInputStream(new VorbisInputStream(this.vStream), this.audioFormat, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int numChannels() {
        return this.vStreamHdr.getChannels();
    }

    public int sampleRate() {
        return this.vStreamHdr.getSampleRate();
    }

    public void setSwap(boolean swap) {
        this.swap = swap;
    }

    public static void swapBytes(byte[] b) {
        OggDecoder.swapBytes(b, 0, b.length);
    }

    public static void swapBytes(byte[] b, int off, int len) {
        for (int i = off; i < off + len; i += 2) {
            byte tempByte = b[i];
            b[i] = b[i + 1];
            b[i + 1] = tempByte;
        }
    }

    public void play() {
        if (!this.initialize()) {
            return;
        }
        this.dump();
        try {
            int bytesRead;
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
            sourceDataLine.open(this.audioFormat);
            sourceDataLine.start();
            byte[] buffer = new byte[BLOCK_SIZE];
            do {
                if ((bytesRead = this.read(buffer)) <= 0) continue;
                sourceDataLine.write(buffer, 0, bytesRead);
            } while (bytesRead >= buffer.length);
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] readAll() {
        if (!this.initialize()) {
            return null;
        }
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        this.setSwap(true);
        this.dump();
        try {
            byte[] buffer;
            int bytesRead;
            int totalRead = 0;
            do {
                if ((bytesRead = this.read(buffer = new byte[BLOCK_SIZE])) > 0) {
                    blocks.add(buffer);
                }
                totalRead += bytesRead;
            } while (bytesRead >= buffer.length);
            byte[] fixedBuffer = new byte[bytesRead];
            for (int i = 0; i < bytesRead; ++i) {
                fixedBuffer[i] = buffer[i];
            }
            blocks.set(blocks.size() - 1, fixedBuffer);
            byte[] result = new byte[totalRead];
            int index = 0;
            for (byte[] block : blocks) {
                for (int i = 0; i < block.length; ++i) {
                    result[index++] = block[i];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load ogg", e);
        }
    }

    public void toraw(String fileName) {
        if (!this.initialize()) {
            return;
        }
        this.setSwap(true);
        this.dump();
        try {
            int bytesRead;
            byte[] buffer = new byte[BLOCK_SIZE];
            FileOutputStream fos = new FileOutputStream(fileName);
            do {
                if ((bytesRead = this.read(buffer)) <= 0) continue;
                fos.write(buffer, 0, bytesRead);
            } while (bytesRead >= buffer.length);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int read(byte[] buffer) throws IOException {
        int bytesRead;
        if (this.endOfStream) {
            return -1;
        }
        int cnt = 0;
        for (bytesRead = 0; bytesRead < buffer.length; bytesRead += cnt) {
            cnt = this.ais.read(buffer, bytesRead, buffer.length - bytesRead);
            if (cnt > 0) continue;
            this.endOfStream = true;
            break;
        }
        if (this.swap) {
            OggDecoder.swapBytes(buffer, 0, bytesRead);
        }
        return bytesRead;
    }

    public void dump() {
        System.err.println("#Channels: " + this.vStreamHdr.getChannels());
        System.err.println("Sample rate: " + this.vStreamHdr.getSampleRate());
        System.err.println("Bitrate: nominal=" + this.vStreamHdr.getNominalBitrate() + ", max=" + this.vStreamHdr.getMaximumBitrate() + ", min=" + this.vStreamHdr.getMinimumBitrate());
    }

    public static void main(String[] args) {
        int i = 0;
        String rawname = null;
        try {
            URL url;
            if (args.length == 0) {
                url = OggDecoder.class.getClassLoader().getResource("demos/data/crickets.ogg");
                new OggDecoder(url).play();
            }
            while (i < args.length) {
                if (args[i].equals("-r")) {
                    rawname = args[++i];
                } else {
                    System.err.println("Playing: " + args[i]);
                    URL uRL = url = new File(args[i]).exists() ? new URL("file:" + args[i]) : new URL(args[i]);
                    if (rawname != null) {
                        new OggDecoder(url).toraw(rawname);
                    } else {
                        new OggDecoder(url).play();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class VorbisInputStream
    extends InputStream {
        private VorbisStream source;

        public VorbisInputStream(VorbisStream source) {
            this.source = source;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                return this.source.readPcm(buffer, offset, length);
            }
            catch (EndOfOggStreamException e) {
                return -1;
            }
        }
    }
}

