/*
 * Decompiled with CFR 0.152.
 */
package framer;

import framer.AnimationCompleteCall;
import framer.AnimationCompletedCallback;
import framer.AnimationKey;
import framer.AnimationProgressCall;
import framer.AnimationProgressCallback;
import framer.Call;
import framer.Easing;
import framer.easing.Back;
import framer.easing.Bounce;
import framer.easing.Circ;
import framer.easing.Cubic;
import framer.easing.Elastic;
import framer.easing.Expo;
import framer.easing.Quad;
import framer.easing.Quart;
import framer.easing.Quint;
import framer.easing.Sine;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Animatable {
    long createAtTime;
    long lastTime;
    private ArrayList<AnimationKey> animationKeys;
    private String stage;

    public Animatable() {
        this.lastTime = this.createAtTime = System.currentTimeMillis();
        this.animationKeys = new ArrayList();
        this.stage = null;
    }

    public Animatable(long createAtTime) {
        this.lastTime = this.createAtTime = System.currentTimeMillis();
        this.animationKeys = new ArrayList();
        this.stage = null;
        this.createAtTime = createAtTime;
    }

    public Animatable delay(long duration) {
        this.createAtTime += duration;
        return this;
    }

    public Animatable waitUntil(long time) {
        this.createAtTime = time;
        return this;
    }

    public String stage() {
        return this.stage;
    }

    public Animatable stage(String stage) {
        AnimationKey key = new AnimationKey(null, 0.0, 0L, this.createAtTime);
        key.stage = stage;
        this.animationKeys.add(key);
        return this;
    }

    public Animatable animate(String variable, double target, long duration) {
        return this.animate(variable, target, duration, Easing.None);
    }

    public Animatable animate(String variable, double target, long duration, Easing easing) {
        AnimationKey key = new AnimationKey(variable, target, duration, this.createAtTime);
        key.setEasing(easing);
        this.animationKeys.add(key);
        return this;
    }

    public Animatable progress(AnimationProgressCallback callback) {
        if (this.animationKeys.size() > 0) {
            this.animationKeys.get(this.animationKeys.size() - 1).addProgressCallback(callback);
        }
        return this;
    }

    public boolean hasAnimations() {
        return this.animationKeys.size() != 0;
    }

    public Animatable add(String variable, double target, long duration) {
        return this.add(variable, target, duration, Easing.None);
    }

    public Animatable add(String variable, double target, long duration, Easing easing) {
        AnimationKey key = new AnimationKey(variable, target, duration, this.createAtTime);
        key.setAnimationMode(AnimationKey.AnimationMode.Additive);
        key.setEasing(easing);
        this.animationKeys.add(key);
        return this;
    }

    public Animatable complete() {
        return this.complete(this, null);
    }

    public Animatable complete(AnimationCompletedCallback callback) {
        return this.complete(this, callback);
    }

    public Animatable ease(Easing easing) {
        AnimationKey last = this.lastCueued();
        if (last != null) {
            last.setEasing(easing);
        }
        return this;
    }

    public double velocity(String variable) {
        for (AnimationKey key : this.animationKeys) {
            if (key.start > this.lastTime || !key.variable.equals(variable)) continue;
            if (key.getEasing().equals((Object)Easing.None)) {
                double df = key.target - key.from;
                double dt = (double)key.duration / 1000.0;
                return df / dt;
            }
            double delta = key.target - key.from;
            double dt = this.lastTime - key.start;
            dt /= (double)key.duration;
            switch (key.getEasing()) {
                case BackIn: {
                    return Back.velocityIn(dt, key.from, delta, 1.0);
                }
                case BackOut: {
                    return Back.velocityOut(dt, key.from, delta, 1.0);
                }
                case BackInOut: {
                    return Back.velocityInOut(dt, key.from, delta, 1.0);
                }
                case BounceIn: {
                    return Bounce.velocityIn(dt, key.from, delta, 1.0);
                }
                case BounceOut: {
                    return Bounce.velocityOut(dt, key.from, delta, 1.0);
                }
                case BounceInOut: {
                    return Bounce.velocityInOut(dt, key.from, delta, 1.0);
                }
                case CircIn: {
                    return Circ.velocityIn(dt, key.from, delta, 1.0);
                }
                case CircOut: {
                    return Circ.velocityOut(dt, key.from, delta, 1.0);
                }
                case CircInOut: {
                    return Circ.velocityInOut(dt, key.from, delta, 1.0);
                }
                case CubicIn: {
                    return Cubic.velocityIn(dt, key.from, delta, 1.0);
                }
                case CubicOut: {
                    return Cubic.velocityOut(dt, key.from, delta, 1.0);
                }
                case CubicInOut: {
                    return Cubic.velocityInOut(dt, key.from, delta, 1.0);
                }
                case ExpoIn: {
                    return Expo.velocityIn(dt, key.from, delta, 1.0);
                }
                case ExpoOut: {
                    return Expo.velocityOut(dt, key.from, delta, 1.0);
                }
                case ExpoInOut: {
                    return Expo.velocityInOut(dt, key.from, delta, 1.0);
                }
                case QuadIn: {
                    return Quad.velocityIn(dt, key.from, delta, 1.0);
                }
                case QuadOut: {
                    return Quad.velocityOut(dt, key.from, delta, 1.0);
                }
                case QuadInOut: {
                    return Quad.velocityInOut(dt, key.from, delta, 1.0);
                }
                case QuartIn: {
                    return Quart.velocityIn(dt, key.from, delta, 1.0);
                }
                case QuartOut: {
                    return Quart.velocityOut(dt, key.from, delta, 1.0);
                }
                case QuartInOut: {
                    return Quart.velocityInOut(dt, key.from, delta, 1.0);
                }
                case QuintIn: {
                    return Quint.velocityIn(dt, key.from, delta, 1.0);
                }
                case QuintOut: {
                    return Quint.velocityOut(dt, key.from, delta, 1.0);
                }
                case QuintInOut: {
                    return Quint.velocityInOut(dt, key.from, delta, 1.0);
                }
                case SineIn: {
                    return Sine.velocityIn(dt, key.from, delta, 1.0) / 1000.0;
                }
                case SineOut: {
                    return Sine.velocityOut(dt, key.from, delta, 1.0) / 1000.0;
                }
                case SineInOut: {
                    return Sine.velocityInOut(dt, key.from, delta, 1.0) / 1000.0;
                }
            }
            throw new RuntimeException("not supported");
        }
        return 0.0;
    }

    public Animatable complete(Animatable animatable) {
        return this.complete(animatable, null);
    }

    public Animatable complete(Animatable animatable, AnimationCompletedCallback callback) {
        AnimationKey waitForKey = animatable.lastCueued();
        if (waitForKey != null) {
            this.createAtTime = waitForKey.start + waitForKey.duration;
            if (callback != null) {
                this.animationKeys.get(this.animationKeys.size() - 1).addCompletionCallback(callback);
            }
        } else if (callback != null) {
            callback.animationCompleted(this);
        }
        return this;
    }

    public Animatable cancel() {
        this.animationKeys.clear();
        this.createAtTime = this.lastTime;
        return this;
    }

    public Animatable cancel(String[] fields) {
        HashSet<String> filter = new HashSet<String>();
        for (String a : fields) {
            filter.add(a);
        }
        ArrayList<AnimationKey> toRemove = new ArrayList<AnimationKey>();
        for (AnimationKey key : this.animationKeys) {
            if (!filter.contains(key.getVariable())) continue;
            toRemove.add(key);
        }
        this.animationKeys.removeAll(toRemove);
        this.createAtTime = this.lastTime;
        return this;
    }

    @Deprecated
    public Animatable cancelHard() {
        this.animationKeys.clear();
        this.createAtTime = System.currentTimeMillis();
        return this;
    }

    private Field getField(String variable) {
        for (Class<?> _class = this.getClass(); _class != null; _class = _class.getSuperclass()) {
            try {
                Field field = _class.getDeclaredField(variable);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static String array(String variable, int index) {
        variable = "[" + index + "]";
        return variable;
    }

    private double getFieldValue(String variable) {
        try {
            int indexPos = variable.indexOf("[");
            if (indexPos != -1) {
                String fieldName = variable.substring(0, indexPos);
                String keyName = variable.substring(indexPos + 1, variable.length() - 1);
                Field field = this.getField(fieldName);
                Class<?> _class = field.getType();
                field.setAccessible(true);
                if (_class == double[].class) {
                    int offset = Integer.parseInt(keyName);
                    double[] a = (double[])field.get(this);
                    return a[offset];
                }
                if (_class == float[].class) {
                    int offset = Integer.parseInt(keyName);
                    float[] a = (float[])field.get(this);
                    return a[offset];
                }
                if (field.get(this) instanceof List) {
                    int offset = Integer.parseInt(keyName);
                    List a = (List)field.get(this);
                    Object o = a.get(offset);
                    if (o instanceof Double) {
                        return (Double)o;
                    }
                    if (o instanceof Float) {
                        return ((Float)o).doubleValue();
                    }
                }
            } else {
                Field field = this.getField(variable);
                if (field != null) {
                    field.setAccessible(true);
                    double value = field.getDouble(this);
                    return value;
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    private AnimationKey lastCueued() {
        if (this.animationKeys.size() > 0) {
            return this.animationKeys.get(this.animationKeys.size() - 1);
        }
        return null;
    }

    private void setFieldValue(String variable, double value) {
        try {
            int indexPos = variable.indexOf("[");
            if (indexPos != -1) {
                String fieldName = variable.substring(0, indexPos);
                String keyName = variable.substring(indexPos + 1, variable.length() - 1);
                Field field = this.getField(fieldName);
                Class<?> _class = field.getType();
                field.setAccessible(true);
                if (_class == double[].class) {
                    int offset = Integer.parseInt(keyName);
                    double[] a = (double[])field.get(this);
                    a[offset] = value;
                } else if (_class == float[].class) {
                    int offset = Integer.parseInt(keyName);
                    float[] a = (float[])field.get(this);
                    a[offset] = (float)value;
                } else if (field.get(this) instanceof List) {
                    int offset = Integer.parseInt(keyName);
                    List list = (List)field.get(this);
                    Object o = list.get(offset);
                    if (o instanceof Double) {
                        list.set(offset, value);
                    } else if (o instanceof Float) {
                        list.set(offset, Float.valueOf((float)value));
                    }
                }
            } else {
                Field field = this.getField(variable);
                if (field != null) {
                    field.setAccessible(true);
                    if (field.getType() == Double.TYPE) {
                        field.setDouble(this, value);
                    } else if (field.getType() == Float.TYPE) {
                        field.setFloat(this, (float)value);
                    } else {
                        System.err.println("warning: could not set animatable value");
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private double blend(Easing easing, double dt, double from, double delta) {
        switch (easing) {
            case BackIn: {
                return Back.easeIn(dt, from, delta, 1.0);
            }
            case BackOut: {
                return Back.easeOut(dt, from, delta, 1.0);
            }
            case BackInOut: {
                return Back.easeInOut(dt, from, delta, 1.0);
            }
            case BounceIn: {
                return Bounce.easeIn(dt, from, delta, 1.0);
            }
            case BounceOut: {
                return Bounce.easeOut(dt, from, delta, 1.0);
            }
            case BounceInOut: {
                return Bounce.easeInOut(dt, from, delta, 1.0);
            }
            case CircIn: {
                return Circ.easeIn(dt, from, delta, 1.0);
            }
            case CircOut: {
                return Circ.easeOut(dt, from, delta, 1.0);
            }
            case CircInOut: {
                return Circ.easeInOut(dt, from, delta, 1.0);
            }
            case CubicIn: {
                return Cubic.easeIn(dt, from, delta, 1.0);
            }
            case CubicOut: {
                return Cubic.easeOut(dt, from, delta, 1.0);
            }
            case CubicInOut: {
                return Cubic.easeInOut(dt, from, delta, 1.0);
            }
            case ElasticIn: {
                return Elastic.easeIn(dt, from, delta, 1.0);
            }
            case ElasticOut: {
                return Elastic.easeOut(dt, from, delta, 1.0);
            }
            case ElasticInOut: {
                return Elastic.easeInOut(dt, from, delta, 1.0);
            }
            case ExpoIn: {
                return Expo.easeIn(dt, from, delta, 1.0);
            }
            case ExpoOut: {
                return Expo.easeOut(dt, from, delta, 1.0);
            }
            case ExpoInOut: {
                return Expo.easeInOut(dt, from, delta, 1.0);
            }
            case QuadIn: {
                return Quad.easeIn(dt, from, delta, 1.0);
            }
            case QuadOut: {
                return Quad.easeOut(dt, from, delta, 1.0);
            }
            case QuadInOut: {
                return Quad.easeInOut(dt, from, delta, 1.0);
            }
            case QuartIn: {
                return Quart.easeIn(dt, from, delta, 1.0);
            }
            case QuartOut: {
                return Quart.easeOut(dt, from, delta, 1.0);
            }
            case QuartInOut: {
                return Quart.easeInOut(dt, from, delta, 1.0);
            }
            case QuintIn: {
                return Quint.easeIn(dt, from, delta, 1.0);
            }
            case QuintOut: {
                return Quint.easeOut(dt, from, delta, 1.0);
            }
            case QuintInOut: {
                return Quint.easeInOut(dt, from, delta, 1.0);
            }
            case SineIn: {
                return Sine.easeIn(dt, from, delta, 1.0);
            }
            case SineOut: {
                return Sine.easeOut(dt, from, delta, 1.0);
            }
            case SineInOut: {
                return Sine.easeInOut(dt, from, delta, 1.0);
            }
        }
        return from + delta * dt;
    }

    public void updateAnimation() {
        this.updateAnimation(System.currentTimeMillis());
    }

    public void updateAnimation(long time) {
        ArrayList<AnimationKey> toRemove = new ArrayList<AnimationKey>();
        ArrayList<Call> calls = new ArrayList<Call>();
        String updateStage = null;
        for (AnimationKey key : this.animationKeys) {
            if (key.start == -1L) {
                key.start = time;
            }
            if (key.start > time) continue;
            if (key.getAnimationState() == AnimationKey.AnimationState.Queued) {
                if (key.getVariable() != null) {
                    key.play(this.getFieldValue(key.getVariable()));
                } else {
                    key.play(0.0);
                }
            }
            if (key.getAnimationState() == AnimationKey.AnimationState.Playing) {
                double dt = time - key.start;
                dt = key.duration > 0L ? (dt /= (double)key.duration) : 1.0;
                if (dt < 0.0) {
                    dt = 0.0;
                }
                if (dt >= 1.0) {
                    dt = 1.0;
                    key.stop();
                }
                for (AnimationProgressCallback callback : key.getProgressCallbacks()) {
                    calls.add(new AnimationProgressCall(callback, this, dt, key.duration));
                }
                if (key.getVariable() != null) {
                    if (key.getAnimationMode() == AnimationKey.AnimationMode.Blend) {
                        double value = this.blend(key.getEasing(), dt, key.from, key.target - key.from);
                        this.setFieldValue(key.getVariable(), value);
                    } else if (key.getAnimationMode() == AnimationKey.AnimationMode.Additive) {
                        double value = this.blend(key.getEasing(), dt, key.from, key.target);
                        this.setFieldValue(key.getVariable(), value);
                    }
                }
                if (key.variable == null && key.stage != null) {
                    updateStage = key.stage;
                }
            }
            if (key.getAnimationState() != AnimationKey.AnimationState.Stopped) continue;
            for (AnimationCompletedCallback callback : key.getCompletionCallbacks()) {
                calls.add(new AnimationCompleteCall(callback, this));
            }
            toRemove.add(key);
        }
        for (Call call : calls) {
            call.call();
        }
        if (updateStage != null) {
            this.stage = updateStage;
        }
        for (AnimationKey key : toRemove) {
            this.animationKeys.remove(key);
        }
        this.lastTime = time;
        if (this.lastTime > this.createAtTime) {
            this.createAtTime = this.lastTime;
        }
    }
}

