/*
 * Decompiled with CFR 0.152.
 */
package framer;

import framer.AnimationCompletedCallback;
import framer.AnimationProgressCallback;
import framer.Easing;
import java.util.ArrayList;

public class AnimationKey {
    String variable;
    double target;
    long duration;
    long start;
    double from;
    String stage;
    ArrayList<AnimationCompletedCallback> completionCallbacks = new ArrayList();
    ArrayList<AnimationProgressCallback> progressCallbacks = new ArrayList();
    private AnimationState animationState = AnimationState.Queued;
    private AnimationMode animationMode = AnimationMode.Blend;
    private Easing easing = Easing.None;

    public AnimationKey(String variable, double target, long duration, long start) {
        this.variable = variable;
        this.target = target;
        this.duration = duration;
        this.start = start;
    }

    public void setEasing(Easing easing) {
        this.easing = easing;
    }

    public Easing getEasing() {
        return this.easing;
    }

    public void setAnimationMode(AnimationMode animationMode) {
        this.animationMode = animationMode;
    }

    public AnimationMode getAnimationMode() {
        return this.animationMode;
    }

    public String getVariable() {
        return this.variable;
    }

    public void play(double from) {
        this.from = from;
        this.animationState = AnimationState.Playing;
    }

    public void stop() {
        this.animationState = AnimationState.Stopped;
    }

    public ArrayList<AnimationCompletedCallback> getCompletionCallbacks() {
        return this.completionCallbacks;
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public void addCompletionCallback(AnimationCompletedCallback callback) {
        this.completionCallbacks.add(callback);
    }

    public ArrayList<AnimationProgressCallback> getProgressCallbacks() {
        return this.progressCallbacks;
    }

    public void addProgressCallback(AnimationProgressCallback callback) {
        this.progressCallbacks.add(callback);
    }

    public static enum AnimationState {
        Queued,
        Playing,
        Stopped;

    }

    public static enum AnimationMode {
        Blend,
        Additive;

    }
}

