/*
 * Decompiled with CFR 0.152.
 */
package framer.easing;

public class Cubic {
    public static double velocityIn(double t, double b, double c, double d) {
        return 3.0 * c * t * t / (d * d * d);
    }

    public static double velocityOut(double t, double b, double c, double d) {
        return 3.0 * c * (d - t) * (d - t) / (d * d * d);
    }

    public static double velocityInOut(double t, double b, double c, double d) {
        if (t / (d / 2.0) < 1.0) {
            return 12.0 * c * t * t / (d * d * d);
        }
        return 12.0 * c * (d - t) * (d - t) / (d * d * d);
    }

    public static double easeIn(double t, double b, double c, double d) {
        return c * (t /= d) * t * t + b;
    }

    public static double easeOut(double t, double b, double c, double d) {
        t = t / d - 1.0;
        return c * (t * t * t + 1.0) + b;
    }

    public static double easeInOut(double t, double b, double c, double d) {
        double d2;
        t /= d / 2.0;
        if (d2 < 1.0) {
            return c / 2.0 * t * t * t + b;
        }
        return c / 2.0 * ((t -= 2.0) * t * t + 2.0) + b;
    }
}

