/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.PackNode;
import net.lustlab.packer.Rectangle;
import net.lustlab.packer.Splitter;

public class CenteredBinarySplitter
implements Splitter {
    private final Rectangle enclosement;
    boolean invert = false;

    public CenteredBinarySplitter(Rectangle enclosement) {
        this.enclosement = enclosement;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    @Override
    public PackNode[] split(PackNode node, Rectangle rect) {
        Rectangle rrect;
        Rectangle lrect;
        float dw = node.getArea().width - rect.width;
        float dh = node.getArea().height - rect.height;
        float s = this.invert ? 1.0f : -1.0f;
        float sanding = 0.0f;
        if (dw > dh) {
            if (s * (node.getArea().topLeft.x - this.enclosement.topLeft.x) > s * this.enclosement.width / 2.0f) {
                lrect = new Rectangle(node.getArea().topLeft.x, node.getArea().topLeft.y, rect.width, node.getArea().height);
                rrect = new Rectangle(node.getArea().topLeft.x + rect.width + sanding, node.getArea().topLeft.y, node.getArea().width - rect.width - sanding, node.getArea().height);
            } else {
                float ew = node.getArea().width - rect.width - sanding;
                rrect = new Rectangle(node.getArea().topLeft.x, node.getArea().topLeft.y, ew, node.getArea().height);
                lrect = new Rectangle(node.getArea().topLeft.x + ew + sanding, node.getArea().topLeft.y, rect.width, node.getArea().height);
            }
        } else if (s * (node.getArea().topLeft.y - this.enclosement.topLeft.y) > s * this.enclosement.height / 2.0f) {
            lrect = new Rectangle(node.getArea().topLeft.x, node.getArea().topLeft.y, node.getArea().width, rect.height);
            rrect = new Rectangle(node.getArea().topLeft.x, node.getArea().topLeft.y + rect.height + sanding, node.getArea().width, node.getArea().height - rect.height - sanding);
        } else {
            float eh = node.getArea().height - rect.height - sanding;
            rrect = new Rectangle(node.getArea().topLeft.x, node.getArea().topLeft.y, node.getArea().width, eh);
            lrect = new Rectangle(node.getArea().topLeft.x, node.getArea().topLeft.y + eh + sanding, node.getArea().width, rect.height);
        }
        return new PackNode[]{new PackNode(lrect), new PackNode(rrect)};
    }
}

