/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.PackNode;
import net.lustlab.packer.Presplitter;
import net.lustlab.packer.Rectangle;

public class GutterPresplitter
implements Presplitter {
    int verticalDivisions;
    int horizontalDivisions;
    float gutter;

    public void setGutter(float gutter) {
        this.gutter = gutter;
    }

    public GutterPresplitter(int verticalDivisions, int horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
        this.verticalDivisions = verticalDivisions;
    }

    public void setHorizontalDivisions(int horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
    }

    public void setVerticalDivisions(int verticalDivisions) {
        this.verticalDivisions = verticalDivisions;
    }

    public int getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    public int getVerticalDivisions() {
        return this.verticalDivisions;
    }

    @Override
    public PackNode[] split(PackNode input) {
        int i;
        float horizontalGutter = this.horizontalDivisions > 1 ? this.gutter : 0.0f;
        float verticalGutter = this.verticalDivisions > 1 ? this.gutter : 0.0f;
        float splitWidth = input.getArea().width / (float)this.horizontalDivisions - horizontalGutter;
        float splitHeight = input.getArea().height / (float)this.verticalDivisions - verticalGutter;
        PackNode[] result = new PackNode[(this.verticalDivisions * 2 - 1) * (this.horizontalDivisions * 2 - 1)];
        float[] xs = new float[this.horizontalDivisions * 2 - 1];
        float[] ys = new float[this.verticalDivisions * 2 - 1];
        int idx = 0;
        float x = input.getArea().topLeft.x;
        for (i = 0; i < this.horizontalDivisions; ++i) {
            xs[idx++] = x;
            x += splitWidth;
            if (idx >= xs.length - 1) continue;
            xs[idx++] = x;
            x += this.gutter;
        }
        idx = 0;
        float y = input.getArea().topLeft.y;
        for (i = 0; i < this.verticalDivisions; ++i) {
            ys[idx++] = y;
            y += splitHeight;
            if (idx >= ys.length - 1) continue;
            ys[idx++] = y;
            y += this.gutter;
        }
        for (int j = 0; j < this.verticalDivisions * 2 - 1; ++j) {
            for (int i2 = 0; i2 < this.horizontalDivisions * 2 - 1; ++i2) {
                Rectangle rect = new Rectangle(xs[i2], ys[j], i2 % 2 == 0 ? splitWidth : this.gutter, j % 2 == 0 ? splitHeight : this.gutter);
                result[j * (this.horizontalDivisions * 2 - 1) + i2] = new PackNode(rect);
            }
        }
        return result;
    }
}

