/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.PackNode;
import net.lustlab.packer.Presplitter;
import net.lustlab.packer.Rectangle;

public class IrregularGutterPresplitter
implements Presplitter {
    float[] verticalDivisions;
    float[] horizontalDivisions;
    float gutter;
    boolean outputGutters = true;
    boolean outputCells = true;

    public void setOutputCells(boolean outputCells) {
        this.outputCells = outputCells;
    }

    public void setOutputGutters(boolean outputGutters) {
        this.outputGutters = outputGutters;
    }

    public boolean isOutputCells() {
        return this.outputCells;
    }

    public boolean isOutputGutters() {
        return this.outputGutters;
    }

    public void setGutter(float gutter) {
        this.gutter = gutter;
    }

    public IrregularGutterPresplitter(float[] verticalDivisions, float[] horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
        this.verticalDivisions = verticalDivisions;
    }

    public void setHorizontalDivisions(float[] horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
    }

    public void setVerticalDivisions(float[] verticalDivisions) {
        this.verticalDivisions = verticalDivisions;
    }

    public float[] getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    public float[] getVerticalDivisions() {
        return this.verticalDivisions;
    }

    @Override
    public PackNode[] split(PackNode input) {
        int i;
        int hl = this.horizontalDivisions.length;
        float hg = hl > 1 ? this.gutter : 0.0f;
        int vl = this.verticalDivisions.length;
        float vg = vl > 1 ? this.gutter : 0.0f;
        float[] xs = new float[hl * 2 - 1];
        float[] ys = new float[vl * 2 - 1];
        float[] widths = new float[hl * 2 - 1];
        float[] heights = new float[vl * 2 - 1];
        int idx = 0;
        float x = input.getArea().topLeft.x;
        for (i = 0; i < hl; ++i) {
            xs[idx] = x;
            widths[idx] = (input.getArea().width - hg * (float)(hl - 1)) * this.horizontalDivisions[i];
            x += widths[idx];
            if (++idx >= xs.length - 1) continue;
            xs[idx] = x;
            widths[idx] = this.gutter;
            x += widths[idx];
            ++idx;
        }
        idx = 0;
        float y = input.getArea().topLeft.y;
        for (i = 0; i < vl; ++i) {
            ys[idx] = y;
            heights[idx] = (input.getArea().height - vg * (float)(hl - 1)) * this.verticalDivisions[i];
            y += heights[idx];
            if (++idx >= ys.length - 1) continue;
            ys[idx] = y;
            heights[idx] = this.gutter;
            y += heights[idx];
            ++idx;
        }
        int cellCount = vl * hl;
        int gutterCount = 3 * vl * hl - 2 * vl - 2 * hl + 1;
        PackNode[] result = new PackNode[(this.outputCells ? cellCount : 0) + (this.outputGutters ? gutterCount : 0)];
        int idx2 = 0;
        for (int j = 0; j < vl * 2 - 1; ++j) {
            for (int i2 = 0; i2 < hl * 2 - 1; ++i2) {
                boolean isCell;
                boolean bl = isCell = j % 2 == 0 && i2 % 2 == 0;
                if ((!this.outputCells || !isCell) && (!this.outputGutters || isCell)) continue;
                result[idx2++] = new PackNode(new Rectangle(xs[i2], ys[j], widths[i2], heights[j]));
            }
        }
        return result;
    }
}

