/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.lustlab.rndr.TextureDescriptor;

public class TextureManager {
    private static Map<TextureDescriptor, Texture> textures;

    public static Texture getTexture(String filename) {
        TextureDescriptor td = new TextureDescriptor(filename);
        Texture texture = textures.get(td);
        if (texture == null) {
            try {
                if (filename.contains(":")) {
                    String[] tokens = filename.split(":");
                    String cname = tokens[0];
                    String rname = tokens[1];
                    try {
                        Class<?> resourceClass = Class.forName(cname);
                        InputStream resourceStream = resourceClass.getResourceAsStream(rname);
                        texture = TextureIO.newTexture((InputStream)resourceStream, (boolean)true, (String)"png");
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    texture = TextureIO.newTexture((File)new File(filename), (boolean)true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return texture;
    }
}

