/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.util.List;
import java.util.Stack;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.BezierCubicRenderer;
import net.lustlab.rndr.draw.BezierQuadraticRenderer;
import net.lustlab.rndr.draw.SimplePolygon;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.draw.TessellationRenderer;
import net.lustlab.rndr.fbo.FBO;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.image.FontImageMap;
import net.lustlab.rndr.font.image.FontImageMapRenderer;
import net.lustlab.rndr.gl.GLError;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;

public class Drawer {
    private double aspect;
    public Style style = new Style();
    private Stack<Style> styleStack;
    final GL gl;
    final GL2 gl2;
    final GLU glu = new GLU();
    static Shader lineShader;
    static Shader fanShader;
    int width;
    int height;

    public void noFill() {
        this.style.fill = null;
    }

    public Drawer size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public Drawer(GL gl) {
        this.gl = gl;
        this.gl2 = gl.getGL2();
        if (lineShader == null) {
            lineShader = Shader.createShader(gl, VertexShader.load(gl, Drawer.class.getResourceAsStream("/shaders/smoothline.vert")), FragmentShader.load(gl, Drawer.class.getResourceAsStream("/shaders/smoothline.frag")));
        }
        if (fanShader == null) {
            fanShader = Shader.createShader(gl, VertexShader.load(gl, Drawer.class.getResourceAsStream("/shaders/smoothfan.vert")), FragmentShader.load(gl, Drawer.class.getResourceAsStream("/shaders/smoothfan.frag")));
        }
    }

    public Drawer blend() {
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        return this;
    }

    public Drawer noBlend() {
        this.gl.glDisable(3042);
        return this;
    }

    public Drawer draw(Image image, double x, double y) {
        return this.drawImage(image, x, y, image.width, image.height);
    }

    public Drawer drawFBO(FBO fbo, double x, double y) {
        return this.drawFBO(fbo, x, y, fbo.width(), fbo.height());
    }

    public Drawer drawFBO(FBO fbo, double x, double y, double width, double height) {
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 1.0f;
        float v1 = 0.0f;
        fbo.bindTexture();
        this.gl2.glEnable(3553);
        this.gl2.glMatrixMode(5888);
        this.gl2.glPushMatrix();
        this.gl2.glTranslated(x, y, 0.0);
        this.gl2.glBegin(7);
        this.gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        this.gl2.glTexCoord2f(u0, v0);
        this.gl2.glVertex2f(0.0f, 0.0f);
        this.gl2.glTexCoord2f(u1, v0);
        this.gl2.glVertex2d(width, 0.0);
        this.gl2.glTexCoord2f(u1, v1);
        this.gl2.glVertex2d(width, height);
        this.gl2.glTexCoord2f(u0, v1);
        this.gl2.glVertex2d(0.0, height);
        this.gl2.glEnd();
        this.gl2.glDisable(3553);
        this.gl2.glBindTexture(3553, 0);
        this.gl2.glPopMatrix();
        return this;
    }

    public Drawer drawFBO(FBO fbo, double sourceX, double sourceY, double sourceWidth, double sourceHeight, double destX, double destY, double destWidth, double destHeight) {
        double u0 = sourceX / (double)fbo.width;
        double u1 = (sourceX + sourceWidth) / (double)fbo.width;
        double v0 = (sourceY + sourceHeight) / (double)fbo.height;
        double v1 = sourceY / (double)fbo.height;
        fbo.bindTexture();
        this.gl2.glEnable(3553);
        this.gl2.glMatrixMode(5888);
        this.gl2.glPushMatrix();
        this.gl2.glTranslated(destX, destY, 0.0);
        this.gl2.glBegin(7);
        this.gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        this.gl2.glTexCoord2d(u0, v0);
        this.gl2.glVertex2f(0.0f, 0.0f);
        this.gl2.glTexCoord2d(u1, v0);
        this.gl2.glVertex2d(destWidth, 0.0);
        this.gl2.glTexCoord2d(u1, v1);
        this.gl2.glVertex2d(destWidth, destHeight);
        this.gl2.glTexCoord2d(u0, v1);
        this.gl2.glVertex2d(0.0, destHeight);
        this.gl2.glEnd();
        this.gl2.glDisable(3553);
        this.gl2.glBindTexture(3553, 0);
        this.gl2.glPopMatrix();
        return this;
    }

    public Drawer drawImage(Image image, double x, double y, double width, double height) {
        TextureCoords tc = image.texture.getImageTexCoords();
        float u0 = tc.left();
        float u1 = tc.right();
        float v0 = tc.top();
        float v1 = tc.bottom();
        image.texture.bind((GL)this.gl2);
        image.texture.enable((GL)this.gl2);
        this.gl2.glMatrixMode(5888);
        this.gl2.glPushMatrix();
        this.gl2.glTranslated(x, y, 0.0);
        this.gl2.glBegin(7);
        this.gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        this.gl2.glTexCoord2f(u0, v0);
        this.gl2.glVertex2f(0.0f, 0.0f);
        this.gl2.glTexCoord2f(u1, v0);
        this.gl2.glVertex2d(width, 0.0);
        this.gl2.glTexCoord2f(u1, v1);
        this.gl2.glVertex2d(width, height);
        this.gl2.glTexCoord2f(u0, v1);
        this.gl2.glVertex2d(0.0, height);
        this.gl2.glEnd();
        image.texture.disable((GL)this.gl2);
        this.gl2.glBindTexture(image.texture.getTarget(), 0);
        this.gl2.glPopMatrix();
        return this;
    }

    public Drawer draw(Texture texture, double x, double y, double width, double height) {
        this.gl2.glActiveTexture(33984);
        TextureCoords tc = texture.getImageTexCoords();
        float u0 = tc.left();
        float u1 = tc.right();
        float v0 = tc.top();
        float v1 = tc.bottom();
        System.out.println(u0 + " " + u1 + " " + v0 + " " + v1);
        texture.bind((GL)this.gl2);
        texture.enable((GL)this.gl2);
        this.gl2.glEnable(3553);
        this.gl2.glBindTexture(3553, texture.getTextureObject((GL)this.gl2));
        this.gl2.glGenerateMipmap(3553);
        this.gl2.glTexParameteri(3553, 10241, 9729);
        this.gl2.glTexParameteri(3553, 10240, 9729);
        this.gl2.glTexParameteri(3553, 10242, 33071);
        this.gl2.glTexParameteri(3553, 10243, 33071);
        this.gl2.glMatrixMode(5888);
        this.gl2.glPushMatrix();
        this.gl2.glTranslated(x, y, 0.0);
        this.gl2.glBegin(7);
        this.gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        this.gl2.glTexCoord2f(u0, v0);
        this.gl2.glVertex2f(0.0f, 0.0f);
        this.gl2.glTexCoord2f(u1, v0);
        this.gl2.glVertex2d(width, 0.0);
        this.gl2.glTexCoord2f(u1, v1);
        this.gl2.glVertex2d(width, height);
        this.gl2.glTexCoord2f(u0, v1);
        this.gl2.glVertex2d(0.0, height);
        this.gl2.glEnd();
        texture.disable((GL)this.gl2);
        this.gl2.glBindTexture(texture.getTarget(), 0);
        this.gl2.glPopMatrix();
        GLError.check((GL)this.gl2);
        return this;
    }

    public Drawer push() {
        this.gl2.glPushMatrix();
        return this;
    }

    public Drawer pop() {
        this.gl2.glPopMatrix();
        return this;
    }

    public Drawer scale(double s) {
        this.gl2.glScaled(s, s, s);
        return this;
    }

    public Drawer scale(double x, double y, double z) {
        this.gl2.glScaled(x, y, z);
        return this;
    }

    public Drawer rotate(double angle) {
        this.gl2.glRotated(angle / Math.PI * 180.0, 0.0, 0.0, 1.0);
        return this;
    }

    public Drawer rotateX(double angle) {
        this.gl2.glRotated(angle / Math.PI * 180.0, 1.0, 0.0, 0.0);
        return this;
    }

    public Drawer rotateY(double angle) {
        this.gl2.glRotated(angle / Math.PI * 180.0, 0.0, 1.0, 0.0);
        return this;
    }

    public Drawer rotateZ(double angle) {
        this.gl2.glRotated(angle / Math.PI * 180.0, 0.0, 0.0, 1.0);
        return this;
    }

    public Drawer rotate(double angle, double x, double y, double z) {
        this.gl2.glRotated(angle / Math.PI * 180.0, x, y, z);
        return this;
    }

    public Drawer translate(double x, double y, double z) {
        this.gl2.glTranslated(x, y, z);
        return this;
    }

    public Drawer rectangle(double x, double y, double width, double height) {
        this.gl2.glBegin(7);
        this.gl2.glColor4d(this.style.fill.r, this.style.fill.g, this.style.fill.b, this.style.fill.a);
        this.gl2.glVertex2d(x, y);
        this.gl2.glVertex2d(x + width, y);
        this.gl2.glVertex2d(x + width, y + height);
        this.gl2.glVertex2d(x, y + height);
        this.gl2.glEnd();
        return this;
    }

    public Drawer perspective(double fov, double aspectRatio, double near, double far) {
        this.gl2.glMatrixMode(5889);
        this.gl2.glLoadIdentity();
        this.glu.gluPerspective(fov, aspectRatio, near, far);
        this.gl2.glMatrixMode(5888);
        return this;
    }

    public Drawer quickPerspective() {
        double fov = 1.0471975511965976;
        double cameraZ = (double)this.height / 2.0 / Math.tan(fov / 2.0);
        this.gl2.glMatrixMode(5889);
        this.gl2.glLoadIdentity();
        this.glu.gluPerspective(fov / Math.PI * 180.0, (double)this.width / (double)this.height, cameraZ / 10.0, cameraZ * 10.0);
        this.gl2.glMatrixMode(5888);
        this.gl2.glLoadIdentity();
        this.gl2.glScaled(1.0, -1.0, 1.0);
        this.gl2.glTranslated((double)(-this.width) / 2.0, (double)(-this.height) / 2.0, -cameraZ);
        return this;
    }

    public Drawer quickPerspective(double xOff, double yOff) {
        double fov = 1.0471975511965976;
        double cameraZ = (double)this.height / 2.0 / Math.tan(fov / 2.0);
        this.gl2.glMatrixMode(5889);
        this.gl2.glLoadIdentity();
        this.aspect = (double)this.width / (double)this.height;
        double fH = Math.tan(180.0 * (fov / Math.PI) / 360.0 * Math.PI) * cameraZ / 10.0;
        double fW = fH * this.aspect;
        this.gl2.glFrustum(-fW - xOff / 10.0, fW - xOff / 10.0, -fH + yOff / 10.0, fH + yOff / 10.0, cameraZ / 10.0, cameraZ * 10.0);
        this.gl2.glMatrixMode(5888);
        this.gl2.glLoadIdentity();
        this.gl2.glScaled(1.0, -1.0, 1.0);
        this.gl2.glTranslated((double)(-this.width) / 2.0, (double)(-this.height) / 2.0, -cameraZ);
        return this;
    }

    public Drawer ortho(double x0, double x1, double y0, double y1, double z0, double z1) {
        this.gl2.glMatrixMode(5889);
        this.gl2.glLoadIdentity();
        this.gl2.glOrtho(x0, x1, y0, y1, z0, z1);
        this.gl2.glMatrixMode(5888);
        return this;
    }

    public Drawer lookAt(double ex, double ey, double ez, double tx, double ty, double tz, double ux, double uy, double uz) {
        this.gl2.glMatrixMode(5888);
        this.gl2.glLoadIdentity();
        this.glu.gluLookAt(ex, ey, ez, tx, ty, tz, ux, uy, uz);
        return this;
    }

    public Drawer fill(Color color) {
        this.style.fill = new Color(color);
        return this;
    }

    public Drawer fill(double r, double g, double b) {
        this.style.fill = new Color(r, g, b, 1.0);
        return this;
    }

    public Drawer fill(double r, double g, double b, double a) {
        this.style.fill = new Color(r, g, b, a);
        return this;
    }

    public Drawer stroke(double r, double g, double b) {
        this.style.stroke = new Color(r, g, b, 1.0);
        return this;
    }

    public Drawer stroke(double r, double g, double b, double a) {
        this.style.stroke = new Color(r, g, b, a);
        return this;
    }

    public Drawer stroke(double c, double a) {
        this.style.stroke = new Color(c, c, c, a);
        return this;
    }

    public void stroke(Color color) {
        this.stroke(color.r, color.g, color.b, color.a);
    }

    public Drawer bezier(Vector2 p0, Vector2 c0, Vector2 c1, Vector2 p1) {
        return this.polyLine(new BezierCubicRenderer().render(p0, c0, c1, p1));
    }

    public Drawer bezier(Vector2 p0, Vector2 c, Vector2 p1) {
        return this.polyLine(new BezierQuadraticRenderer().render(p0, c, p1));
    }

    public Drawer polyLine(List<Vector2> points) {
        this.gl2.glColor4d(this.style.stroke.r, this.style.stroke.g, this.style.stroke.b, this.style.stroke.a);
        this.gl2.glLineWidth(1.0f);
        this.gl2.glBegin(1);
        for (int i = 0; i < points.size() - 1; ++i) {
            Vector2 left = points.get(i);
            Vector2 right = points.get(i + 1);
            this.gl2.glVertex2d(left.x, left.y);
            this.gl2.glVertex2d(right.x, right.y);
        }
        this.gl2.glEnd();
        return this;
    }

    public void polygon(SimplePolygon polygon) {
        if (this.style.fill != null) {
            this.gl2.glBegin(4);
            this.pushFill();
            Vector2 pivot = polygon.vertices.get(0);
            for (int i = 0; i < polygon.vertices.size(); ++i) {
                int i1 = (i + 1) % polygon.vertices.size();
                int i2 = (i + 2) % polygon.vertices.size();
                this.gl2.glVertex2d(pivot.x, pivot.y);
                Vector2 left = polygon.vertices.get(i1);
                Vector2 right = polygon.vertices.get(i2);
                this.gl2.glVertex2d(left.x, left.y);
                this.gl2.glVertex2d(right.x, right.y);
            }
            this.gl2.glEnd();
        }
        if (this.style.stroke != null) {
            this.pushStroke();
            this.gl2.glLineWidth(1.0f);
            this.gl2.glBegin(1);
            for (int i = 0; i < polygon.vertices.size(); ++i) {
                Vector2 left = polygon.vertices.get(i);
                Vector2 right = polygon.vertices.get((i + 1) % polygon.vertices.size());
                this.gl2.glVertex2d(left.x, left.y);
                this.gl2.glVertex2d(right.x, right.y);
            }
            this.gl2.glEnd();
        }
    }

    public Drawer triangle(Vector2 p0, Vector2 p1, Vector2 p2) {
        this.pushFill();
        this.gl2.glBegin(4);
        this.gl2.glVertex2d(p0.x, p0.y);
        this.gl2.glVertex2d(p1.x, p1.y);
        this.gl2.glVertex2d(p2.x, p2.y);
        this.gl2.glEnd();
        return this;
    }

    public Drawer line(Vector2 p0, Vector2 p1) {
        return this.line(p0.x, p0.y, p1.x, p1.y);
    }

    public Drawer line(double x0, double y0, double x1, double y1) {
        this.gl2.glColor4d(this.style.stroke.r, this.style.stroke.g, this.style.stroke.b, this.style.stroke.a);
        this.gl2.glLineWidth(1.0f);
        this.gl2.glBegin(1);
        this.gl2.glVertex2d(x0, y0);
        this.gl2.glVertex2d(x1, y1);
        this.gl2.glEnd();
        return this;
    }

    private void pushStroke() {
        this.gl2.glColor4d(this.style.stroke.r, this.style.stroke.g, this.style.stroke.b, this.style.stroke.a);
    }

    private void pushFill() {
        this.gl2.glColor4d(this.style.fill.r, this.style.fill.g, this.style.fill.b, this.style.fill.a);
    }

    public Drawer circle(double x, double y, double r) {
        int sides = (int)(2.0 * r);
        double phi = Math.PI * 2 / (double)sides;
        this.pushFill();
        this.gl2.glBegin(4);
        for (int side = 0; side < sides; ++side) {
            this.gl2.glVertex2d(x, y);
            this.gl2.glVertex2d(x + Math.cos((double)side * phi) * r, y + Math.sin((double)side * phi) * r);
            this.gl2.glVertex2d(x + Math.cos((double)(side + 1) * phi) * r, y + Math.sin((double)(side + 1) * phi) * r);
        }
        this.gl2.glEnd();
        return this;
    }

    public Drawer smoothCircle(double x, double y, double r) {
        fanShader.begin();
        int sides = (int)(2.0 * r);
        double phi = Math.PI * 2 / (double)sides;
        this.pushFill();
        this.gl2.glBegin(4);
        for (int side = 0; side < sides; ++side) {
            this.gl2.glTexCoord2d(0.0, -r);
            this.gl2.glVertex2d(x, y);
            this.gl2.glTexCoord2d(0.0, 1.0);
            this.gl2.glVertex2d(x + Math.cos((double)side * phi) * r, y + Math.sin((double)side * phi) * r);
            this.gl2.glVertex2d(x + Math.cos((double)(side + 1) * phi) * r, y + Math.sin((double)(side + 1) * phi) * r);
        }
        this.gl2.glEnd();
        fanShader.end();
        return this;
    }

    public Drawer smoothLine(double x0, double y0, double x1, double y1) {
        lineShader.begin();
        double dx = x1 - x0;
        double dy = y1 - y0;
        double nx = -dy;
        double ny = dx;
        double l = Math.sqrt(nx * nx + ny * ny);
        nx /= l;
        ny /= l;
        this.gl2.glBegin(7);
        this.gl2.glTexCoord2d(0.0, 0.0);
        this.gl2.glVertex2d(x0 - (nx *= 10.0), y0 - (ny *= 10.0));
        this.gl2.glTexCoord2d(1.0, 0.0);
        this.gl2.glVertex2d(x1 - nx, y1 - ny);
        this.gl2.glTexCoord2d(1.0, 1.0);
        this.gl2.glVertex2d(x1 + nx, y1 + ny);
        this.gl2.glTexCoord2d(0.0, 1.0);
        this.gl2.glVertex2d(x0 + nx, y0 + ny);
        this.gl2.glEnd();
        lineShader.end();
        return this;
    }

    public Drawer line(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.pushFill();
        this.gl2.glBegin(1);
        this.gl2.glVertex3d(x0, y0, z0);
        this.gl2.glVertex3d(x1, y1, z1);
        this.gl2.glEnd();
        return this;
    }

    public Drawer draw(Tessellation ts) {
        this.gl2.glEnable(2881);
        this.gl2.glEnable(2848);
        this.gl2.glEnable(3042);
        this.pushFill();
        TessellationRenderer.drawTessellation(this.gl2, ts);
        return this;
    }

    public Drawer smoothDraw(Tessellation ts) {
        this.pushFill();
        TessellationRenderer.drawTessellationSmooth(this.gl2, ts);
        return this;
    }

    public Drawer text(FontImageMap map, String text, double x, double y) {
        this.pushFill();
        FontImageMapRenderer fr = new FontImageMapRenderer((GL)this.gl2);
        fr.render((GL)this.gl2, (FontMap)map, text, (float)x, (float)y);
        return this;
    }

    public static class Style {
        public Color fill = Color.WHITE;
        public Color stroke = Color.WHITE;

        public Style() {
        }

        public Style(Style other) {
            this.fill = new Color(other.fill);
            this.stroke = new Color(other.stroke);
        }
    }
}

