/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import com.jogamp.opengl.util.texture.Texture;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.SolidsRenderer;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.draw.TessellationRendererGL3;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transform;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class DrawerGL3 {
    private Shader textureShader;
    Stack<Matrix44> modelViewStack = new Stack();
    Stack<Matrix44> projectionStack = new Stack();
    public double width;
    public double height;
    SolidsRenderer solidsRenderer;
    Stack<Style> styleStack = new Stack();
    Style style = new Style();
    Transform modelViewTransform = Transform.Identity;
    Transform projectionTransform = new Transform(Transforms.ortho(0.0, 1280.0, 720.0, 0.0, -1.0, 1.0));
    VBO lineVBO;
    VBO texturedQuadVBO;
    VBOLayout vboLayout;
    Shader shader;
    GL3 gl3;

    public void rotateX(double v) {
        this.modelViewTransform = this.modelViewTransform.rotateX(v);
    }

    public void rotateY(double v) {
        this.modelViewTransform = this.modelViewTransform.rotateY(v);
    }

    public void rotateZ(double v) {
        this.modelViewTransform = this.modelViewTransform.rotateZ(v);
    }

    public DrawerGL3 quickPerspective() {
        double fov = 1.0471975511965976;
        double cameraZ = this.height / 2.0 / Math.tan(fov / 2.0);
        this.projectionTransform = new Transform(Transforms.perspective(fov, this.width / this.height, cameraZ / 10.0, cameraZ * 10.0));
        this.modelViewTransform = new Transform(Matrix44.Identity).scale(1.0, -1.0, 1.0).translate(-this.width / 2.0, -this.height / 2.0, -cameraZ);
        return this;
    }

    public DrawerGL3 multiply(Matrix44 t) {
        this.modelViewTransform = new Transform(Linear.multiply(this.modelViewTransform.matrix, t));
        return this;
    }

    public Matrix44 projection() {
        return this.projectionTransform.matrix;
    }

    public Matrix44 modelView() {
        return this.modelViewTransform.matrix;
    }

    public DrawerGL3 ortho(double left, double right, double bottom, double top, double near, double far) {
        this.projectionTransform = new Transform(Transforms.ortho(left, right, bottom, top, near, far));
        return this;
    }

    public DrawerGL3 perspective(double fov, double aspect, double near, double far) {
        this.projectionTransform = new Transform(Transforms.perspective(fov, aspect, near, far));
        return this;
    }

    public DrawerGL3 depthTest(boolean state) {
        if (state) {
            this.gl3.glEnable(2929);
        } else {
            this.gl3.glDisable(2929);
        }
        return this;
    }

    public DrawerGL3(GL3 gl3, int width, int height) {
        this.gl3 = gl3;
        gl3.glViewport(0, 0, width, height);
        this.vboLayout = new VBOLayout();
        this.vboLayout.textureCoordinate(2);
        this.vboLayout.color(4);
        this.vboLayout.position(3);
        this.texturedQuadVBO = VBO.createMappedVBO((GL)gl3, this.vboLayout.size() / 4 * 6);
        this.lineVBO = VBO.createMappedVBO((GL)gl3, this.vboLayout.size() / 4 * 2);
        this.shader = Shader.createShader((GL)gl3, VertexShader.load((GL)gl3, this.getClass().getResourceAsStream("/shaders/drawergl3.vert")), FragmentShader.load((GL)gl3, this.getClass().getResourceAsStream("/shaders/drawergl3.frag")));
        this.textureShader = Shader.createShader((GL)gl3, VertexShader.load((GL)gl3, this.getClass().getResourceAsStream("/shaders/gl3/texture.vert")), FragmentShader.load((GL)gl3, this.getClass().getResourceAsStream("/shaders/gl3/texture.frag")));
        this.solidsRenderer = new SolidsRenderer(gl3);
    }

    public DrawerGL3 fill(Color fill) {
        this.style.fill = fill;
        return this;
    }

    public DrawerGL3 stroke(Color stroke) {
        this.style.stroke = stroke;
        return this;
    }

    public DrawerGL3 lookAt(double ex, double ey, double ez, double tx, double ty, double tz, double ux, double uy, double uz) {
        this.modelViewTransform = new Transform(Transforms.lookAt(new Vector3(ex, ey, ez), new Vector3(tx, ty, tz), new Vector3(ux, uy, uz)));
        return this;
    }

    public DrawerGL3 translate(double x, double y) {
        this.modelViewTransform = this.modelViewTransform.translate(x, y, 0.0);
        return this;
    }

    public DrawerGL3 translate(double x, double y, double z) {
        this.modelViewTransform = this.modelViewTransform.translate(x, y, z);
        return this;
    }

    public DrawerGL3 rotate(double radians) {
        this.modelViewTransform = this.modelViewTransform.rotateZ(radians);
        return this;
    }

    public void scale(double v) {
        this.modelViewTransform = this.modelViewTransform.scale(v);
    }

    public DrawerGL3 pushMatrix() {
        this.modelViewStack.push(this.modelViewTransform.matrix);
        return this;
    }

    public DrawerGL3 popMatrix() {
        this.modelViewTransform = new Transform(this.modelViewStack.pop());
        return this;
    }

    void setupShader(Shader shader) {
        shader.setUniform("modelViewMatrix", this.modelViewTransform.matrix.transpose());
        shader.setUniform("modelViewProjectionMatrix", this.projectionTransform.matrix.multiply(this.modelViewTransform.matrix).transpose());
        shader.setUniform("projectionMatrix", this.projectionTransform.matrix.transpose());
        shader.setUniform("normalMatrix", this.modelViewTransform.matrix.inverse().transpose());
        shader.setUniform("fill", this.style.fill);
        shader.setUniform("stroke", this.style.stroke);
    }

    public DrawerGL3 line(double x0, double y0, double x1, double y1) {
        return this.line(x0, y0, 0.0, x1, y1, 0.0);
    }

    public DrawerGL3 line(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.lineVBO.map().rewind();
        new Vertex(x0, y0, z0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0).writeToBuffer(this.lineVBO.getMappedBuffer());
        new Vertex(x1, y1, z1, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0).writeToBuffer(this.lineVBO.getMappedBuffer());
        this.lineVBO.rewind().unmap();
        this.shader.begin();
        this.setupShader(this.shader);
        VBODrawer.draw((GL)this.gl3, this.shader, this.lineVBO, this.vboLayout, 1, 2);
        this.shader.end();
        return this;
    }

    public DrawerGL3 rectangle(double x, double y, double width, double height) {
        this.texturedQuadVBO.map();
        this.texturedQuadVBO.rewind();
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + width, y, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + width, y + height, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y + height, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + width, y + height, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        this.texturedQuadVBO.unmap();
        this.shader.begin();
        this.setupShader(this.shader);
        VBODrawer.draw((GL)this.gl3, this.shader, this.texturedQuadVBO, this.vboLayout, 4, 6);
        this.shader.end();
        return this;
    }

    public void draw(Tessellation tessellation) {
        TessellationRendererGL3.drawTessellationSmooth(this.gl3, this.projectionTransform.matrix, this.modelViewTransform.matrix, tessellation);
    }

    public DrawerGL3 box(double x, double y, double z, double width, double height, double depth) {
        this.solidsRenderer.solid((GL)this.gl3, this.projection(), this.modelView(), this.style.fill, "box", new Vector3(x, y, z), new Vector3(width, height, depth));
        return this;
    }

    public void draw(ColorBuffer colorBuffer, double x, double y) {
        this.draw(colorBuffer, x, y, false);
    }

    public void draw(ColorBuffer colorBuffer, double x, double y, boolean flipV) {
        this.gl3.glActiveTexture(33984);
        colorBuffer.bindTexture((GL)this.gl3);
        this.textureShader.begin();
        this.setupShader(this.textureShader);
        this.texturedQuadVBO.map();
        this.texturedQuadVBO.rewind();
        this.texturedQuadVBO.getMappedBuffer().order(ByteOrder.nativeOrder());
        double v0 = flipV ? 0.0 : 1.0;
        double v1 = flipV ? 1.0 : 0.0;
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, v0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + (double)colorBuffer.width, y, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, v0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + (double)colorBuffer.width, y + (double)colorBuffer.height, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, v1).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, v0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y + (double)colorBuffer.height, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, v1).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + (double)colorBuffer.width, y + (double)colorBuffer.height, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, v1).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        this.texturedQuadVBO.unmap();
        VBODrawer.draw((GL)this.gl3, this.textureShader, this.texturedQuadVBO, this.vboLayout, 4, 6);
        this.texturedQuadVBO.rewind();
        this.textureShader.end();
        this.gl3.glBindTexture(3553, 0);
    }

    public void draw(Texture texture, double x, double y, double width, double height) {
        this.gl3.glActiveTexture(33984);
        texture.bind((GL)this.gl3);
        this.textureShader.begin();
        this.setupShader(this.textureShader);
        this.texturedQuadVBO.map();
        this.texturedQuadVBO.rewind();
        this.texturedQuadVBO.getMappedBuffer().order(ByteOrder.nativeOrder());
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + width, y, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + width, y + height, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y + height, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + width, y + height, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        this.texturedQuadVBO.unmap();
        VBODrawer.draw((GL)this.gl3, this.textureShader, this.texturedQuadVBO, this.vboLayout, 4, 6);
        this.texturedQuadVBO.rewind();
        this.textureShader.end();
        this.gl3.glBindTexture(3553, 0);
    }

    public void draw(Texture texture, double x, double y, boolean flipV) {
        this.gl3.glActiveTexture(33984);
        texture.bind((GL)this.gl3);
        this.textureShader.begin();
        this.setupShader(this.textureShader);
        this.texturedQuadVBO.map();
        this.texturedQuadVBO.rewind();
        this.texturedQuadVBO.getMappedBuffer().order(ByteOrder.nativeOrder());
        double v0 = flipV ? 0.0 : 1.0;
        double v1 = flipV ? 1.0 : 0.0;
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, v0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + (double)texture.getWidth(), y, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, v0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + (double)texture.getWidth(), y + (double)texture.getHeight(), 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, v1).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, v0).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x, y + (double)texture.getHeight(), 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, v1).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        new Vertex(x + (double)texture.getWidth(), y + (double)texture.getHeight(), 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, v1).writeToBuffer(this.texturedQuadVBO.getMappedBuffer());
        this.texturedQuadVBO.unmap();
        VBODrawer.draw((GL)this.gl3, this.textureShader, this.texturedQuadVBO, this.vboLayout, 4, 6);
        this.texturedQuadVBO.rewind();
        this.textureShader.end();
        this.gl3.glBindTexture(3553, 0);
    }

    public static class Vertex {
        float x;
        float y;
        float z;
        float u;
        float v;
        float r;
        float g;
        float b;
        float a;

        Vertex(double x, double y, double z, double r, double g, double b, double a, double u, double v) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.r = (float)r;
            this.g = (float)g;
            this.b = (float)b;
            this.a = (float)a;
            this.u = (float)u;
            this.v = (float)v;
        }

        public void writeToBuffer(ByteBuffer buffer) {
            buffer.putFloat(this.u).putFloat(this.v).putFloat(this.r).putFloat(this.g).putFloat(this.b).putFloat(this.a).putFloat(this.x).putFloat(this.y).putFloat(this.z);
        }
    }

    public static class Style {
        Color fill = Color.WHITE;
        Color stroke = Color.BLACK;
        double strokeWeight = 1.0;
    }
}

