/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Node;
import net.lustlab.rndr.draw.PolygonContour;
import net.lustlab.rndr.draw.Rectangle;
import net.lustlab.rndr.draw.Vertex;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector3;

public class Polygon
extends Node
implements Iterable<PolygonContour>,
Serializable {
    public List<PolygonContour> polygonContours = new ArrayList<PolygonContour>();
    public Color fill;
    public Color stroke;

    @Override
    public Rectangle bounds() {
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        Matrix44 m = this.transform.matrix;
        for (PolygonContour contour : this.polygonContours) {
            for (Vertex segment : contour) {
                Vector3 p = segment.position;
                p = p.multiply(m);
                minx = Math.min(minx, p.x);
                maxx = Math.max(maxx, p.x);
                miny = Math.min(miny, p.y);
                maxy = Math.max(maxy, p.y);
            }
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public boolean contoursClosed() {
        boolean closed = true;
        for (PolygonContour contour : this.polygonContours) {
            if (contour.closed) continue;
            closed = false;
            break;
        }
        return closed;
    }

    @Override
    public Iterator<PolygonContour> iterator() {
        return this.polygonContours.iterator();
    }

    @Override
    public String toString() {
        return "Polygon{polygonContours=" + this.polygonContours + ", fill=" + this.fill + ", stroke=" + this.stroke + "} " + super.toString();
    }
}

