/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.lustlab.rndr.draw.BezierCubicRenderer;
import net.lustlab.rndr.draw.BezierQuadraticRenderer;
import net.lustlab.rndr.math.Vector2;

public class Segment
implements Serializable {
    public Vector2 start;
    public Vector2 end;
    public Vector2[] control;

    public Segment(Vector2 start, Vector2 end) {
        this.start = start;
        this.end = end;
        this.control = null;
    }

    public Segment(Vector2 start, Vector2 c0, Vector2 c1, Vector2 end) {
        this.start = start;
        this.end = end;
        this.control = new Vector2[]{c0, c1};
    }

    public Segment(Vector2 start, Vector2 c0, Vector2 end) {
        this.start = start;
        this.end = end;
        this.control = new Vector2[]{c0};
    }

    public Vector2[] quadraticBezier() {
        if (this.control == null || this.control.length == 0) {
            Vector2 cp0 = this.start.add(this.end.subtract(this.start).scale(0.3333333333333333));
            Vector2 cp1 = this.start.add(this.end.subtract(this.start).scale(0.6666666666666666));
            return new Vector2[]{this.start, cp0, cp1, this.end};
        }
        if (this.control.length == 2) {
            return new Vector2[]{this.start, this.control[0], this.control[1], this.end};
        }
        if (this.control.length == 1) {
            Vector2 cp0 = this.start.add(this.control[0].subtract(this.start).scale(0.6666666666666666));
            Vector2 cp1 = this.end.add(this.control[0].subtract(this.end).scale(0.6666666666666666));
            return new Vector2[]{this.start, cp0, cp1, this.end};
        }
        throw new RuntimeException("unsupported amount of control points");
    }

    boolean isLinear() {
        return this.control == null || this.control.length == 0;
    }

    public double length() {
        if (this.isLinear()) {
            return this.start.subtract(this.end).length();
        }
        if (this.control.length == 1) {
            BezierQuadraticRenderer bqr = new BezierQuadraticRenderer();
            List<Vector2> pieces = bqr.render(this.start, this.control[0], this.end);
            double length = 0.0;
            for (int i = 0; i < pieces.size(); ++i) {
                length += pieces.get(i).subtract(pieces.get(i + 1)).length();
            }
            return length;
        }
        if (this.control.length == 2) {
            BezierCubicRenderer bcr = new BezierCubicRenderer();
            List<Vector2> pieces = bcr.render(this.start, this.control[0], this.control[1], this.end);
            double length = 0.0;
            for (int i = 0; i < pieces.size(); ++i) {
                length += pieces.get(i).subtract(pieces.get(i + 1)).length();
            }
            return length;
        }
        return 0.0;
    }

    public Vector2 position(double t) {
        if (this.isLinear()) {
            return new Vector2(this.start.x * (1.0 - t) + this.end.x * t, this.start.y * (1.0 - t) + this.end.y * t);
        }
        if (this.control.length == 1) {
            t = Math.min(1.0, Math.max(0.0, t));
            double it = 1.0 - t;
            double it2 = (1.0 - t) * (1.0 - t);
            double t2 = t * t;
            double x = it2 * this.start.x + 2.0 * it * t * this.control[0].x + t2 * this.end.x;
            double y = it2 * this.start.y + 2.0 * it * t * this.control[0].y + t2 * this.end.y;
            return new Vector2(x, y);
        }
        if (this.control.length == 2) {
            return null;
        }
        return null;
    }

    public String toString() {
        return "Segment{start=" + this.start + ", end=" + this.end + ", control=" + Arrays.toString(this.control) + '}';
    }
}

